/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors.impl;

import com.amazonaws.services.kinesis.connectors.BasicJsonTransformer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonToByteArrayTransformer<T>
extends BasicJsonTransformer<T, byte[]> {
    private static final Log LOG = LogFactory.getLog(JsonToByteArrayTransformer.class);

    public JsonToByteArrayTransformer(Class<T> inputClass) {
        super(inputClass);
    }

    @Override
    public byte[] fromClass(T record) throws IOException {
        try {
            return new ObjectMapper().writeValueAsString(record).getBytes();
        }
        catch (JsonProcessingException e) {
            String message = "Error parsing record to JSON";
            LOG.error((Object)message, (Throwable)e);
            throw new IOException(message, e);
        }
    }
}

