/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import com.amazonaws.services.kinesis.connectors.KinesisConnectorConfiguration;
import com.amazonaws.services.kinesis.connectors.KinesisConnectorRecordProcessorFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class KinesisConnectorExecutorBase<T, U>
implements Runnable {
    private static final Log LOG = LogFactory.getLog(KinesisConnectorExecutorBase.class);
    protected Worker worker;

    protected void initialize(KinesisConnectorConfiguration kinesisConnectorConfiguration) {
        this.initialize(kinesisConnectorConfiguration, null);
    }

    protected void initialize(KinesisConnectorConfiguration kinesisConnectorConfiguration, IMetricsFactory metricFactory) {
        KinesisClientLibConfiguration kinesisClientLibConfiguration = new KinesisClientLibConfiguration(kinesisConnectorConfiguration.APP_NAME, kinesisConnectorConfiguration.KINESIS_INPUT_STREAM, kinesisConnectorConfiguration.AWS_CREDENTIALS_PROVIDER, kinesisConnectorConfiguration.WORKER_ID).withKinesisEndpoint(kinesisConnectorConfiguration.KINESIS_ENDPOINT).withFailoverTimeMillis(kinesisConnectorConfiguration.FAILOVER_TIME).withMaxRecords(kinesisConnectorConfiguration.MAX_RECORDS).withInitialPositionInStream(kinesisConnectorConfiguration.INITIAL_POSITION_IN_STREAM).withIdleTimeBetweenReadsInMillis(kinesisConnectorConfiguration.IDLE_TIME_BETWEEN_READS).withCallProcessRecordsEvenForEmptyRecordList(true).withCleanupLeasesUponShardCompletion(kinesisConnectorConfiguration.CLEANUP_TERMINATED_SHARDS_BEFORE_EXPIRY).withParentShardPollIntervalMillis(kinesisConnectorConfiguration.PARENT_SHARD_POLL_INTERVAL).withShardSyncIntervalMillis(kinesisConnectorConfiguration.SHARD_SYNC_INTERVAL).withTaskBackoffTimeMillis(kinesisConnectorConfiguration.BACKOFF_INTERVAL).withMetricsBufferTimeMillis(kinesisConnectorConfiguration.CLOUDWATCH_BUFFER_TIME).withMetricsMaxQueueSize(kinesisConnectorConfiguration.CLOUDWATCH_MAX_QUEUE_SIZE).withUserAgent(kinesisConnectorConfiguration.APP_NAME + "," + kinesisConnectorConfiguration.CONNECTOR_DESTINATION + "," + "amazon-kinesis-connector-java-1.2.0").withRegionName(kinesisConnectorConfiguration.REGION_NAME);
        if (!kinesisConnectorConfiguration.CALL_PROCESS_RECORDS_EVEN_FOR_EMPTY_LIST) {
            LOG.warn((Object)"The false value of callProcessRecordsEvenForEmptyList will be ignored. It must be set to true for the bufferTimeMillisecondsLimit to work correctly.");
        }
        if (kinesisConnectorConfiguration.IDLE_TIME_BETWEEN_READS > kinesisConnectorConfiguration.BUFFER_MILLISECONDS_LIMIT) {
            LOG.warn((Object)"idleTimeBetweenReads is greater than bufferTimeMillisecondsLimit. For best results, ensure that bufferTimeMillisecondsLimit is more than or equal to idleTimeBetweenReads ");
        }
        this.worker = metricFactory != null ? new Worker(this.getKinesisConnectorRecordProcessorFactory(), kinesisClientLibConfiguration, metricFactory) : new Worker(this.getKinesisConnectorRecordProcessorFactory(), kinesisClientLibConfiguration);
        LOG.info((Object)(this.getClass().getSimpleName() + " worker created"));
    }

    @Override
    public void run() {
        if (this.worker != null) {
            LOG.info((Object)("Starting worker in " + this.getClass().getSimpleName()));
            try {
                this.worker.run();
            }
            catch (Throwable t) {
                LOG.error((Object)t);
                throw t;
            }
            finally {
                LOG.error((Object)("Worker " + this.getClass().getSimpleName() + " is not running."));
            }
        } else {
            throw new RuntimeException("Initialize must be called before run.");
        }
    }

    public abstract KinesisConnectorRecordProcessorFactory<T, U> getKinesisConnectorRecordProcessorFactory();
}

