/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors.redshift;

import com.amazonaws.services.kinesis.connectors.KinesisConnectorConfiguration;
import com.amazonaws.services.kinesis.connectors.UnmodifiableBuffer;
import com.amazonaws.services.kinesis.connectors.s3.S3Emitter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RedshiftBasicEmitter
extends S3Emitter {
    private static final Log LOG = LogFactory.getLog(RedshiftBasicEmitter.class);
    private final String s3bucket;
    private final String redshiftTable;
    private final String redshiftURL;
    private final char redshiftDelimiter;
    private final Properties loginProperties;
    private final String accessKey;
    private final String secretKey;

    public RedshiftBasicEmitter(KinesisConnectorConfiguration configuration) {
        super(configuration);
        this.s3bucket = configuration.S3_BUCKET;
        this.redshiftTable = configuration.REDSHIFT_DATA_TABLE;
        this.redshiftDelimiter = configuration.REDSHIFT_DATA_DELIMITER.charValue();
        this.redshiftURL = configuration.REDSHIFT_URL;
        this.loginProperties = new Properties();
        this.loginProperties.setProperty("user", configuration.REDSHIFT_USERNAME);
        this.loginProperties.setProperty("password", configuration.REDSHIFT_PASSWORD);
        this.accessKey = configuration.AWS_CREDENTIALS_PROVIDER.getCredentials().getAWSAccessKeyId();
        this.secretKey = configuration.AWS_CREDENTIALS_PROVIDER.getCredentials().getAWSSecretKey();
    }

    @Override
    public List<byte[]> emit(UnmodifiableBuffer<byte[]> buffer) throws IOException {
        List<byte[]> failed = super.emit(buffer);
        if (!failed.isEmpty()) {
            return buffer.getRecords();
        }
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(this.redshiftURL, this.loginProperties);
            String s3File = this.getS3FileName(buffer.getFirstSequenceNumber(), buffer.getLastSequenceNumber());
            this.executeStatement(this.generateCopyStatement(s3File), conn);
            LOG.info((Object)("Successfully copied " + this.getNumberOfCopiedRecords(conn) + " records to Amazon Redshift from file s3://" + this.s3Bucket + "/" + s3File));
            this.closeConnection(conn);
            return Collections.emptyList();
        }
        catch (IOException | SQLException e) {
            LOG.error((Object)e);
            this.closeConnection(conn);
            return buffer.getRecords();
        }
    }

    @Override
    public void fail(List<byte[]> records) {
        super.fail(records);
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }

    private void closeConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    protected String generateCopyStatement(String s3File) {
        StringBuilder exec = new StringBuilder();
        exec.append("COPY " + this.redshiftTable + " ");
        exec.append("FROM 's3://" + this.s3bucket + "/" + s3File + "' ");
        exec.append("CREDENTIALS 'aws_access_key_id=" + this.accessKey);
        exec.append(";aws_secret_access_key=" + this.secretKey + "' ");
        exec.append("DELIMITER '" + this.redshiftDelimiter + "'");
        exec.append(";");
        return exec.toString();
    }

    private void executeStatement(String statement, Connection conn) throws IOException {
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(statement);
            stmt.close();
            return;
        }
        catch (SQLException e) {
            LOG.error((Object)e);
            throw new IOException(e);
        }
    }

    private int getNumberOfCopiedRecords(Connection conn) throws IOException {
        String cmd = "select pg_last_copy_count();";
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(cmd);
            resultSet.next();
            int numCopiedRecords = resultSet.getInt(1);
            resultSet.close();
            stmt.close();
            return numCopiedRecords;
        }
        catch (SQLException e) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(e);
        }
    }
}

