/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors;

import com.amazonaws.services.kinesis.connectors.interfaces.IBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UnmodifiableBuffer<T>
implements IBuffer<T> {
    private final IBuffer<?> buf;
    private final List<T> records;

    public UnmodifiableBuffer(IBuffer<T> buf) {
        this.buf = buf;
        this.records = buf.getRecords();
    }

    public UnmodifiableBuffer(IBuffer<?> buf, List<T> records) {
        this.buf = buf;
        this.records = records;
    }

    @Override
    public long getBytesToBuffer() {
        return this.buf.getBytesToBuffer();
    }

    @Override
    public long getNumRecordsToBuffer() {
        return this.buf.getNumRecordsToBuffer();
    }

    @Override
    public long getMillisecondsToBuffer() {
        return this.buf.getMillisecondsToBuffer();
    }

    @Override
    public boolean shouldFlush() {
        return this.buf.shouldFlush();
    }

    @Override
    public void consumeRecord(T record, int recordBytes, String sequenceNumber) {
        throw new UnsupportedOperationException("This is an unmodifiable buffer");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This is an unmodifiable buffer");
    }

    @Override
    public String getFirstSequenceNumber() {
        return this.buf.getFirstSequenceNumber();
    }

    @Override
    public String getLastSequenceNumber() {
        return this.buf.getLastSequenceNumber();
    }

    @Override
    public List<T> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public int hashCode() {
        return Objects.hash(this.buf, this.records);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UnmodifiableBuffer) {
            UnmodifiableBuffer other = (UnmodifiableBuffer)obj;
            return Objects.equals(this.buf, other.buf) && Objects.equals(this.records, this.records);
        }
        return false;
    }
}

