/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.connectors;

import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import com.amazonaws.services.kinesis.connectors.KinesisConnectorConfiguration;
import com.amazonaws.services.kinesis.connectors.KinesisConnectorRecordProcessor;
import com.amazonaws.services.kinesis.connectors.interfaces.IBuffer;
import com.amazonaws.services.kinesis.connectors.interfaces.IEmitter;
import com.amazonaws.services.kinesis.connectors.interfaces.IFilter;
import com.amazonaws.services.kinesis.connectors.interfaces.IKinesisConnectorPipeline;
import com.amazonaws.services.kinesis.connectors.interfaces.ITransformerBase;

public class KinesisConnectorRecordProcessorFactory<T, U>
implements IRecordProcessorFactory {
    private IKinesisConnectorPipeline<T, U> pipeline;
    private KinesisConnectorConfiguration configuration;

    public KinesisConnectorRecordProcessorFactory(IKinesisConnectorPipeline<T, U> pipeline, KinesisConnectorConfiguration configuration) {
        this.configuration = configuration;
        this.pipeline = pipeline;
    }

    public KinesisConnectorRecordProcessor<T, U> createProcessor() {
        try {
            IBuffer<T> buffer = this.pipeline.getBuffer(this.configuration);
            IEmitter<U> emitter = this.pipeline.getEmitter(this.configuration);
            ITransformerBase<T, U> transformer = this.pipeline.getTransformer(this.configuration);
            IFilter<T> filter = this.pipeline.getFilter(this.configuration);
            KinesisConnectorRecordProcessor<T, U> processor = new KinesisConnectorRecordProcessor<T, U>(buffer, filter, emitter, transformer, this.configuration);
            return processor;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

