/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.BlockingGetRecordsCache;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.DataFetchingStrategy;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsCache;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsRetrievalStrategy;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.PrefetchGetRecordsCache;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.RecordsFetcherFactory;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleRecordsFetcherFactory
implements RecordsFetcherFactory {
    private static final Log log = LogFactory.getLog(SimpleRecordsFetcherFactory.class);
    private final int maxRecords;
    private int maxPendingProcessRecordsInput = 3;
    private int maxByteSize = 0x800000;
    private int maxRecordsCount = 30000;
    private long idleMillisBetweenCalls = 1500L;
    private DataFetchingStrategy dataFetchingStrategy = DataFetchingStrategy.DEFAULT;

    public SimpleRecordsFetcherFactory(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    @Override
    public GetRecordsCache createRecordsFetcher(GetRecordsRetrievalStrategy getRecordsRetrievalStrategy, String shardId, IMetricsFactory metricsFactory) {
        if (this.dataFetchingStrategy.equals((Object)DataFetchingStrategy.DEFAULT)) {
            return new BlockingGetRecordsCache(this.maxRecords, getRecordsRetrievalStrategy);
        }
        return new PrefetchGetRecordsCache(this.maxPendingProcessRecordsInput, this.maxByteSize, this.maxRecordsCount, this.maxRecords, getRecordsRetrievalStrategy, Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("prefetch-cache-" + shardId + "-%04d").build()), this.idleMillisBetweenCalls, metricsFactory, "ProcessTask");
    }

    @Override
    public void setMaxPendingProcessRecordsInput(int maxPendingProcessRecordsInput) {
        this.maxPendingProcessRecordsInput = maxPendingProcessRecordsInput;
    }

    @Override
    public void setMaxByteSize(int maxByteSize) {
        this.maxByteSize = maxByteSize;
    }

    @Override
    public void setMaxRecordsCount(int maxRecordsCount) {
        this.maxRecordsCount = maxRecordsCount;
    }

    @Override
    public void setDataFetchingStrategy(DataFetchingStrategy dataFetchingStrategy) {
        this.dataFetchingStrategy = dataFetchingStrategy;
    }

    @Override
    public void setIdleMillisBetweenCalls(long idleMillisBetweenCalls) {
        this.idleMillisBetweenCalls = idleMillisBetweenCalls;
    }
}

