/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsCache;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsRetrievalStrategy;
import com.amazonaws.services.kinesis.clientlibrary.types.ProcessRecordsInput;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import java.time.Duration;
import java.time.Instant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockingGetRecordsCache
implements GetRecordsCache {
    private static final Log log = LogFactory.getLog(BlockingGetRecordsCache.class);
    private final int maxRecordsPerCall;
    private final GetRecordsRetrievalStrategy getRecordsRetrievalStrategy;
    private final long idleMillisBetweenCalls;
    private Instant lastSuccessfulCall;

    public BlockingGetRecordsCache(int maxRecordsPerCall, GetRecordsRetrievalStrategy getRecordsRetrievalStrategy, long idleMillisBetweenCalls) {
        this.maxRecordsPerCall = maxRecordsPerCall;
        this.getRecordsRetrievalStrategy = getRecordsRetrievalStrategy;
        this.idleMillisBetweenCalls = idleMillisBetweenCalls;
    }

    @Override
    public void start() {
    }

    @Override
    public ProcessRecordsInput getNextResult() {
        this.sleepBeforeNextCall();
        GetRecordsResult getRecordsResult = this.getRecordsRetrievalStrategy.getRecords(this.maxRecordsPerCall);
        this.lastSuccessfulCall = Instant.now();
        ProcessRecordsInput processRecordsInput = new ProcessRecordsInput().withRecords(getRecordsResult.getRecords()).withMillisBehindLatest(getRecordsResult.getMillisBehindLatest());
        return processRecordsInput;
    }

    private void sleepBeforeNextCall() {
        if (!Thread.interrupted()) {
            if (this.lastSuccessfulCall == null) {
                return;
            }
            long timeSinceLastCall = Duration.between(this.lastSuccessfulCall, Instant.now()).abs().toMillis();
            if (timeSinceLastCall < this.idleMillisBetweenCalls) {
                try {
                    Thread.sleep(this.idleMillisBetweenCalls - timeSinceLastCall);
                }
                catch (InterruptedException e) {
                    log.info((Object)"Thread was interrupted, indicating that shutdown was called.");
                }
            }
        } else {
            log.info((Object)"Thread has been interrupted, indicating that it is in the shutdown phase.");
        }
    }

    @Override
    public GetRecordsRetrievalStrategy getGetRecordsRetrievalStrategy() {
        return this.getRecordsRetrievalStrategy;
    }

    @Override
    public void shutdown() {
        this.getRecordsRetrievalStrategy.shutdown();
    }
}

