/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ShardSyncTask
implements ITask {
    private static final Log LOG = LogFactory.getLog(ShardSyncTask.class);
    private final IKinesisProxy kinesisProxy;
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private InitialPositionInStream initialPosition;
    private final boolean cleanupLeasesUponShardCompletion;
    private final long shardSyncTaskIdleTimeMillis;
    private final TaskType taskType = TaskType.SHARDSYNC;

    ShardSyncTask(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStream initialPositionInStream, boolean cleanupLeasesUponShardCompletion, long shardSyncTaskIdleTimeMillis) {
        this.kinesisProxy = kinesisProxy;
        this.leaseManager = leaseManager;
        this.initialPosition = initialPositionInStream;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.shardSyncTaskIdleTimeMillis = shardSyncTaskIdleTimeMillis;
    }

    @Override
    public TaskResult call() {
        Exception exception = null;
        try {
            ShardSyncer.checkAndCreateLeasesForNewShards(this.kinesisProxy, this.leaseManager, this.initialPosition, this.cleanupLeasesUponShardCompletion);
            if (this.shardSyncTaskIdleTimeMillis > 0L) {
                Thread.sleep(this.shardSyncTaskIdleTimeMillis);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Caught exception while sync'ing Kinesis shards and leases", (Throwable)e);
            exception = e;
        }
        return new TaskResult(exception);
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }
}

