/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.multilang;

import com.amazonaws.services.kinesis.clientlibrary.config.KinesisClientLibConfigurator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.multilang.MultiLangRecordProcessorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiLangDaemonConfig {
    private static final Log LOG = LogFactory.getLog(MultiLangDaemonConfig.class);
    private static final String USER_AGENT = "amazon-kinesis-multi-lang-daemon";
    private static final String VERSION = "1.0.1";
    private static final String PROP_EXECUTABLE_NAME = "executableName";
    private static final String PROP_PROCESSING_LANGUAGE = "processingLanguage";
    private static final String PROP_MAX_ACTIVE_THREADS = "maxActiveThreads";
    private KinesisClientLibConfiguration kinesisClientLibConfig;
    private ExecutorService executorService;
    private MultiLangRecordProcessorFactory recordProcessorFactory;

    public MultiLangDaemonConfig(String propertiesFile) throws IOException, IllegalArgumentException {
        this(propertiesFile, Thread.currentThread().getContextClassLoader());
    }

    public MultiLangDaemonConfig(String propertiesFile, ClassLoader classLoader) throws IOException, IllegalArgumentException {
        this(propertiesFile, classLoader, new KinesisClientLibConfigurator());
    }

    public MultiLangDaemonConfig(String propertiesFile, ClassLoader classLoader, KinesisClientLibConfigurator configurator) throws IOException, IllegalArgumentException {
        Properties properties = MultiLangDaemonConfig.loadProperties(classLoader, propertiesFile);
        if (!MultiLangDaemonConfig.validateProperties(properties)) {
            throw new IllegalArgumentException("Must provide an executable name in the properties file, e.g. executableName = sampleapp.py");
        }
        String executableName = properties.getProperty(PROP_EXECUTABLE_NAME);
        String processingLanguage = properties.getProperty(PROP_PROCESSING_LANGUAGE);
        this.kinesisClientLibConfig = configurator.getConfiguration(properties);
        this.executorService = MultiLangDaemonConfig.buildExecutorService(properties);
        this.recordProcessorFactory = new MultiLangRecordProcessorFactory(executableName, this.executorService);
        LOG.info((Object)("Running " + this.kinesisClientLibConfig.getApplicationName() + " to process stream " + this.kinesisClientLibConfig.getStreamName() + " with executable " + executableName));
        this.prepare(processingLanguage);
    }

    private void prepare(String processingLanguage) {
        Security.setProperty("networkaddress.cache.ttl", "60");
        LOG.info((Object)("Using workerId: " + this.kinesisClientLibConfig.getWorkerIdentifier()));
        LOG.info((Object)("Using credentials with access key id: " + this.kinesisClientLibConfig.getKinesisCredentialsProvider().getCredentials().getAWSAccessKeyId()));
        StringBuilder userAgent = new StringBuilder("amazon-kinesis-client-library-java-1.5.0");
        userAgent.append(" ");
        userAgent.append(USER_AGENT);
        userAgent.append("/");
        userAgent.append(VERSION);
        if (processingLanguage != null) {
            userAgent.append(" ");
            userAgent.append(processingLanguage);
        }
        if (this.recordProcessorFactory.getCommandArray().length > 0) {
            userAgent.append(" ");
            userAgent.append(this.recordProcessorFactory.getCommandArray()[0]);
        }
        LOG.info((Object)String.format("MultiLangDaemon is adding the following fields to the User Agent: %s", userAgent.toString()));
        this.kinesisClientLibConfig.withUserAgent(userAgent.toString());
    }

    private static Properties loadProperties(ClassLoader classLoader, String propertiesFileName) throws IOException {
        Properties properties = new Properties();
        try (InputStream propertiesStream = classLoader.getResourceAsStream(propertiesFileName);){
            properties.load(propertiesStream);
            Properties properties2 = properties;
            return properties2;
        }
    }

    private static boolean validateProperties(Properties properties) {
        return properties != null && properties.getProperty(PROP_EXECUTABLE_NAME) != null;
    }

    private static int getMaxActiveThreads(Properties properties) {
        return Integer.parseInt(properties.getProperty(PROP_MAX_ACTIVE_THREADS, "0"));
    }

    private static ExecutorService buildExecutorService(Properties properties) {
        int maxActiveThreads = MultiLangDaemonConfig.getMaxActiveThreads(properties);
        LOG.debug((Object)String.format("Value for %s property is %d", PROP_MAX_ACTIVE_THREADS, maxActiveThreads));
        if (maxActiveThreads <= 0) {
            LOG.info((Object)"Using a cached thread pool.");
            return Executors.newCachedThreadPool();
        }
        LOG.info((Object)String.format("Using a fixed thread pool with %d max active threads.", maxActiveThreads));
        return Executors.newFixedThreadPool(maxActiveThreads);
    }

    public KinesisClientLibConfiguration getKinesisClientLibConfiguration() {
        return this.kinesisClientLibConfig;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public MultiLangRecordProcessorFactory getRecordProcessorFactory() {
        return this.recordProcessorFactory;
    }
}

