/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class ShardInfo {
    private final String shardId;
    private final String concurrencyToken;
    private final List<String> parentShardIds;

    public ShardInfo(String shardId, String concurrencyToken, Collection<String> parentShardIds) {
        this.shardId = shardId;
        this.concurrencyToken = concurrencyToken;
        this.parentShardIds = new LinkedList<String>();
        if (parentShardIds != null) {
            this.parentShardIds.addAll(parentShardIds);
        }
        Collections.sort(this.parentShardIds);
    }

    protected String getShardId() {
        return this.shardId;
    }

    protected String getConcurrencyToken() {
        return this.concurrencyToken;
    }

    protected List<String> getParentShardIds() {
        return new LinkedList<String>(this.parentShardIds);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.concurrencyToken == null ? 0 : this.concurrencyToken.hashCode());
        result = 31 * result + (this.parentShardIds == null ? 0 : this.parentShardIds.hashCode());
        result = 31 * result + (this.shardId == null ? 0 : this.shardId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShardInfo other = (ShardInfo)obj;
        if (this.concurrencyToken == null ? other.concurrencyToken != null : !this.concurrencyToken.equals(other.concurrencyToken)) {
            return false;
        }
        if (this.parentShardIds == null ? other.parentShardIds != null : !this.parentShardIds.equals(other.parentShardIds)) {
            return false;
        }
        return !(this.shardId == null ? other.shardId != null : !this.shardId.equals(other.shardId));
    }

    public String toString() {
        return "ShardInfo [shardId=" + this.shardId + ", concurrencyToken=" + this.concurrencyToken + ", parentShardIds=" + this.parentShardIds + "]";
    }
}

