/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ShutdownException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.checkpoint.SentinelCheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.CheckpointValueComparator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.SequenceNumberValidator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RecordProcessorCheckpointer
implements IRecordProcessorCheckpointer {
    private static final Log LOG = LogFactory.getLog(RecordProcessorCheckpointer.class);
    private ICheckpoint checkpoint;
    private String largestPermittedCheckpointValue;
    private String lastCheckpointValue;
    private ShardInfo shardInfo;
    private SequenceNumberValidator sequenceNumberValidator;
    private CheckpointValueComparator checkpointValueComparator;
    private String sequenceNumberAtShardEnd;

    RecordProcessorCheckpointer(ShardInfo shardInfo, ICheckpoint checkpoint, SequenceNumberValidator validator, CheckpointValueComparator comparator) {
        this.shardInfo = shardInfo;
        this.checkpoint = checkpoint;
        this.sequenceNumberValidator = validator;
        this.checkpointValueComparator = comparator;
    }

    @Override
    public synchronized void checkpoint() throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checkpointing " + this.shardInfo.getShardId() + ", " + " token " + this.shardInfo.getConcurrencyToken() + " at largest permitted value " + this.largestPermittedCheckpointValue));
        }
        this.advancePosition(this.largestPermittedCheckpointValue);
    }

    @Override
    public synchronized void checkpoint(String sequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        this.sequenceNumberValidator.validateSequenceNumber(sequenceNumber);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Validated checkpoint sequence number " + sequenceNumber + " for " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken()));
        }
        if (this.checkpointValueComparator.compare(this.lastCheckpointValue, sequenceNumber) <= 0 && this.checkpointValueComparator.compare(sequenceNumber, this.largestPermittedCheckpointValue) <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checkpointing " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken() + " at specific sequence number " + sequenceNumber));
            }
        } else {
            throw new IllegalArgumentException("Could not checkpoint at sequence number " + sequenceNumber + " it did not fall into acceptable range between the last sequence number checkpointed " + this.lastCheckpointValue + " and the greatest sequence number passed to this record processor " + this.largestPermittedCheckpointValue);
        }
        this.advancePosition(sequenceNumber);
    }

    String getLastCheckpointValue() {
        return this.lastCheckpointValue;
    }

    synchronized void setInitialCheckpointValue(String initialCheckpoint) {
        this.lastCheckpointValue = initialCheckpoint;
    }

    synchronized String getLargestPermittedCheckpointValue() {
        return this.largestPermittedCheckpointValue;
    }

    synchronized void setLargestPermittedCheckpointValue(String checkpointValue) {
        this.largestPermittedCheckpointValue = checkpointValue;
    }

    synchronized void setSequenceNumberAtShardEnd(String sequenceNumber) {
        this.sequenceNumberAtShardEnd = sequenceNumber;
    }

    void advancePosition(String sequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        String checkpointValue = sequenceNumber;
        if (this.sequenceNumberAtShardEnd != null && this.sequenceNumberAtShardEnd.equals(sequenceNumber)) {
            checkpointValue = SentinelCheckpoint.SHARD_END.toString();
        }
        if (sequenceNumber != null && !sequenceNumber.equals(this.lastCheckpointValue)) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken() + " checkpoint to " + checkpointValue));
                }
                this.checkpoint.setCheckpoint(this.shardInfo.getShardId(), checkpointValue, this.shardInfo.getConcurrencyToken());
                this.lastCheckpointValue = checkpointValue;
            }
            catch (InvalidStateException | KinesisClientLibDependencyException | ShutdownException | ThrottlingException e) {
                throw e;
            }
            catch (KinesisClientLibException e) {
                LOG.warn((Object)"Caught exception setting checkpoint.", (Throwable)e);
                throw new KinesisClientLibDependencyException("Caught exception while checkpointing", e);
            }
        }
    }
}

