/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaseSynchronizer;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.impl.Lease;
import com.amazonaws.services.kinesis.model.Shard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class NonEmptyLeaseTableSynchronizer
implements LeaseSynchronizer {
    private static final Log LOG = LogFactory.getLog(NonEmptyLeaseTableSynchronizer.class);
    private final Map<String, Shard> shardIdToShardMap;
    private final Map<String, Set<String>> shardIdToChildShardIdsMap;

    @Override
    public List<KinesisClientLease> determineNewLeasesToCreate(List<Shard> shards, List<KinesisClientLease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds) {
        HashMap<String, KinesisClientLease> shardIdToNewLeaseMap = new HashMap<String, KinesisClientLease>();
        Map<String, Shard> shardIdToShardMapOfAllKinesisShards = KinesisShardSyncer.constructShardIdToShardMap(shards);
        HashSet<String> shardIdsOfCurrentLeases = new HashSet<String>();
        for (Lease lease : currentLeases) {
            shardIdsOfCurrentLeases.add(lease.getLeaseKey());
            LOG.debug((Object)("Existing lease: " + lease));
        }
        List<Shard> openShards = KinesisShardSyncer.getOpenShards(shards);
        KinesisShardSyncer.MemoizationContext memoizationContext = new KinesisShardSyncer.MemoizationContext();
        for (Shard shard : openShards) {
            String shardId = shard.getShardId();
            LOG.debug((Object)("Evaluating leases for open shard " + shardId + " and its ancestors."));
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                LOG.debug((Object)("Lease for shardId " + shardId + " already exists. Not creating a lease"));
                continue;
            }
            if (inconsistentShardIds.contains(shardId)) {
                LOG.info((Object)("shardId " + shardId + " is an inconsistent child.  Not creating a lease"));
                continue;
            }
            LOG.debug((Object)("Beginning traversal of ancestry tree for shardId " + shardId));
            boolean isDescendant = KinesisShardSyncer.checkIfDescendantAndAddNewLeasesForAncestors(shardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToNewLeaseMap, memoizationContext);
            if (!isDescendant) {
                LOG.debug((Object)("ShardId " + shardId + " has no ancestors. Creating a lease."));
                KinesisClientLease newLease = KinesisShardSyncer.newKCLLease(shard);
                newLease.setCheckpoint(KinesisShardSyncer.convertToCheckpoint(initialPosition));
                LOG.debug((Object)("Set checkpoint of " + newLease.getLeaseKey() + " to " + newLease.getCheckpoint()));
                shardIdToNewLeaseMap.put(shardId, newLease);
                continue;
            }
            LOG.debug((Object)("ShardId " + shardId + " is a descendant whose ancestors should already have leases. Not creating a lease."));
        }
        ArrayList<KinesisClientLease> newLeasesToCreate = new ArrayList<KinesisClientLease>();
        newLeasesToCreate.addAll(shardIdToNewLeaseMap.values());
        KinesisShardSyncer.StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new KinesisShardSyncer.StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMapOfAllKinesisShards);
        Collections.sort(newLeasesToCreate, startingSequenceNumberComparator);
        return newLeasesToCreate;
    }

    public NonEmptyLeaseTableSynchronizer(Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap) {
        this.shardIdToShardMap = shardIdToShardMap;
        this.shardIdToChildShardIdsMap = shardIdToChildShardIdsMap;
    }
}

