/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.leases.interfaces;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.kinesis.leases.impl.Lease;
import com.amazonaws.services.kinesis.leases.impl.UpdateField;
import java.util.Collection;
import java.util.Map;

public interface ILeaseSerializer<T extends Lease> {
    public Map<String, AttributeValue> toDynamoRecord(T var1);

    public T fromDynamoRecord(Map<String, AttributeValue> var1);

    public Map<String, AttributeValue> getDynamoHashKey(T var1);

    public Map<String, AttributeValue> getDynamoHashKey(String var1);

    public Map<String, ExpectedAttributeValue> getDynamoLeaseCounterExpectation(T var1);

    public Map<String, ExpectedAttributeValue> getDynamoLeaseOwnerExpectation(T var1);

    public Map<String, ExpectedAttributeValue> getDynamoNonexistantExpectation();

    default public Map<String, ExpectedAttributeValue> getDynamoExistentExpectation(String leaseKey) {
        throw new UnsupportedOperationException("DynamoExistentExpectation is not implemented");
    }

    public Map<String, AttributeValueUpdate> getDynamoLeaseCounterUpdate(T var1);

    public Map<String, AttributeValueUpdate> getDynamoTakeLeaseUpdate(T var1, String var2);

    public Map<String, AttributeValueUpdate> getDynamoEvictLeaseUpdate(T var1);

    public Map<String, AttributeValueUpdate> getDynamoUpdateLeaseUpdate(T var1);

    default public Map<String, AttributeValueUpdate> getDynamoUpdateLeaseUpdate(T lease, UpdateField updateField) {
        throw new UnsupportedOperationException();
    }

    public Collection<KeySchemaElement> getKeySchema();

    public Collection<AttributeDefinition> getAttributeDefinitions();
}

