/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.internal.KinesisClientLibIOException;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.EmptyLeaseTableSynchronizer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaseCleanupValidator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaseSynchronizer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.NonEmptyLeaseTableSynchronizer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.amazonaws.services.kinesis.model.ChildShard;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardFilter;
import com.amazonaws.services.kinesis.model.ShardFilterType;
import com.amazonaws.util.CollectionUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class KinesisShardSyncer
implements ShardSyncer {
    private static final Log LOG = LogFactory.getLog(KinesisShardSyncer.class);
    private final LeaseCleanupValidator leaseCleanupValidator;

    public KinesisShardSyncer(LeaseCleanupValidator leaseCleanupValidator) {
        this.leaseCleanupValidator = leaseCleanupValidator;
    }

    synchronized void bootstrapShardLeases(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPositionInStream, boolean ignoreUnexpectedChildShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        this.syncShardLeases(kinesisProxy, leaseManager, initialPositionInStream, ignoreUnexpectedChildShards);
    }

    @Override
    public synchronized void checkAndCreateLeasesForNewShards(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        this.syncShardLeases(kinesisProxy, leaseManager, initialPositionInStream, ignoreUnexpectedChildShards);
    }

    @Override
    public synchronized void checkAndCreateLeasesForNewShards(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards, List<Shard> latestShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        this.syncShardLeases(kinesisProxy, leaseManager, initialPositionInStream, ignoreUnexpectedChildShards, latestShards, leaseManager.isLeaseTableEmpty());
    }

    private synchronized void syncShardLeases(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPosition, boolean ignoreUnexpectedChildShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        boolean isLeaseTableEmpty = leaseManager.isLeaseTableEmpty();
        List<Shard> latestShards = isLeaseTableEmpty ? this.getShardListAtInitialPosition(kinesisProxy, initialPosition) : this.getCompleteShardList(kinesisProxy);
        this.syncShardLeases(kinesisProxy, leaseManager, initialPosition, ignoreUnexpectedChildShards, latestShards, isLeaseTableEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void syncShardLeases(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPosition, boolean ignoreUnexpectedChildShards, List<Shard> latestShards, boolean isLeaseTableEmpty) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        List<Shard> shards = CollectionUtils.isNullOrEmpty(latestShards) ? (isLeaseTableEmpty ? this.getShardListAtInitialPosition(kinesisProxy, initialPosition) : this.getCompleteShardList(kinesisProxy)) : latestShards;
        LOG.debug((Object)("Num Shards: " + shards.size()));
        Map<String, Shard> shardIdToShardMap = KinesisShardSyncer.constructShardIdToShardMap(shards);
        Map<String, Set<String>> shardIdToChildShardIdsMap = KinesisShardSyncer.constructShardIdToChildShardIdsMap(shardIdToShardMap);
        Set<String> inconsistentShardIds = this.findInconsistentShardIds(shardIdToChildShardIdsMap, shardIdToShardMap);
        if (!ignoreUnexpectedChildShards) {
            this.assertAllParentShardsAreClosed(inconsistentShardIds);
        }
        LeaseSynchronizer leaseSynchronizer = isLeaseTableEmpty ? new EmptyLeaseTableSynchronizer() : new NonEmptyLeaseTableSynchronizer(shardIdToShardMap, shardIdToChildShardIdsMap);
        List<KinesisClientLease> currentLeases = leaseManager.listLeases();
        List<KinesisClientLease> newLeasesToCreate = this.determineNewLeasesToCreate(leaseSynchronizer, shards, currentLeases, initialPosition, inconsistentShardIds);
        LOG.debug((Object)("Num new leases to create: " + newLeasesToCreate.size()));
        for (KinesisClientLease lease : newLeasesToCreate) {
            long startTimeMillis = System.currentTimeMillis();
            boolean success = false;
            try {
                leaseManager.createLeaseIfNotExists(lease);
                success = true;
            }
            finally {
                MetricsHelper.addSuccessAndLatency("CreateLease", startTimeMillis, success, MetricsLevel.DETAILED);
            }
        }
        ArrayList<KinesisClientLease> trackedLeases = new ArrayList<KinesisClientLease>();
        if (currentLeases != null) {
            trackedLeases.addAll(currentLeases);
        }
        trackedLeases.addAll(newLeasesToCreate);
    }

    private void assertAllParentShardsAreClosed(Set<String> inconsistentShardIds) throws KinesisClientLibIOException {
        if (!inconsistentShardIds.isEmpty()) {
            String ids = StringUtils.join(inconsistentShardIds, (char)' ');
            throw new KinesisClientLibIOException(String.format("%d open child shards (%s) are inconsistent. This can happen due to a race condition between describeStream and a reshard operation.", inconsistentShardIds.size(), ids));
        }
    }

    private Set<String> findInconsistentShardIds(Map<String, Set<String>> shardIdToChildShardIdsMap, Map<String, Shard> shardIdToShardMap) {
        HashSet<String> result = new HashSet<String>();
        for (String parentShardId : shardIdToChildShardIdsMap.keySet()) {
            Shard parentShard = shardIdToShardMap.get(parentShardId);
            if (parentShardId != null && parentShard.getSequenceNumberRange().getEndingSequenceNumber() != null) continue;
            Set<String> childShardIdsMap = shardIdToChildShardIdsMap.get(parentShardId);
            result.addAll(childShardIdsMap);
        }
        return result;
    }

    Map<String, KinesisClientLease> constructShardIdToKCLLeaseMap(List<KinesisClientLease> trackedLeaseList) {
        HashMap<String, KinesisClientLease> trackedLeasesMap = new HashMap<String, KinesisClientLease>();
        for (KinesisClientLease lease : trackedLeaseList) {
            trackedLeasesMap.put(lease.getLeaseKey(), lease);
        }
        return trackedLeasesMap;
    }

    synchronized void assertClosedShardsAreCoveredOrAbsent(Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap, Set<String> shardIdsOfClosedShards) throws KinesisClientLibIOException {
        String exceptionMessageSuffix = "This can happen if we constructed the list of shards  while a reshard operation was in progress.";
        for (String shardId : shardIdsOfClosedShards) {
            Shard shard = shardIdToShardMap.get(shardId);
            if (shard == null) {
                LOG.info((Object)("Shard " + shardId + " is not present in Kinesis anymore."));
                continue;
            }
            String endingSequenceNumber = shard.getSequenceNumberRange().getEndingSequenceNumber();
            if (endingSequenceNumber == null) {
                throw new KinesisClientLibIOException("Shard " + shardIdsOfClosedShards + " is not closed. " + exceptionMessageSuffix);
            }
            Set<String> childShardIds = shardIdToChildShardIdsMap.get(shardId);
            if (childShardIds == null) {
                throw new KinesisClientLibIOException("Incomplete shard list: Closed shard " + shardId + " has no children." + exceptionMessageSuffix);
            }
            this.assertHashRangeOfClosedShardIsCovered(shard, shardIdToShardMap, childShardIds);
        }
    }

    private synchronized void assertHashRangeOfClosedShardIsCovered(Shard closedShard, Map<String, Shard> shardIdToShardMap, Set<String> childShardIds) throws KinesisClientLibIOException {
        BigInteger startingHashKeyOfClosedShard = new BigInteger(closedShard.getHashKeyRange().getStartingHashKey());
        BigInteger endingHashKeyOfClosedShard = new BigInteger(closedShard.getHashKeyRange().getEndingHashKey());
        BigInteger minStartingHashKeyOfChildren = null;
        BigInteger maxEndingHashKeyOfChildren = null;
        for (String childShardId : childShardIds) {
            Shard childShard = shardIdToShardMap.get(childShardId);
            BigInteger startingHashKey = new BigInteger(childShard.getHashKeyRange().getStartingHashKey());
            if (minStartingHashKeyOfChildren == null || startingHashKey.compareTo(minStartingHashKeyOfChildren) < 0) {
                minStartingHashKeyOfChildren = startingHashKey;
            }
            BigInteger endingHashKey = new BigInteger(childShard.getHashKeyRange().getEndingHashKey());
            if (maxEndingHashKeyOfChildren != null && endingHashKey.compareTo(maxEndingHashKeyOfChildren) <= 0) continue;
            maxEndingHashKeyOfChildren = endingHashKey;
        }
        if (minStartingHashKeyOfChildren == null || maxEndingHashKeyOfChildren == null || minStartingHashKeyOfChildren.compareTo(startingHashKeyOfClosedShard) > 0 || maxEndingHashKeyOfChildren.compareTo(endingHashKeyOfClosedShard) < 0) {
            throw new KinesisClientLibIOException("Incomplete shard list: hash key range of shard " + closedShard.getShardId() + " is not covered by its child shards.");
        }
    }

    static Map<String, Set<String>> constructShardIdToChildShardIdsMap(Map<String, Shard> shardIdToShardMap) {
        HashMap<String, Set<String>> shardIdToChildShardIdsMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Shard> entry : shardIdToShardMap.entrySet()) {
            String adjacentParentShardId;
            String shardId = entry.getKey();
            Shard shard = entry.getValue();
            String parentShardId = shard.getParentShardId();
            if (parentShardId != null && shardIdToShardMap.containsKey(parentShardId)) {
                HashSet<String> childShardIds = (HashSet<String>)shardIdToChildShardIdsMap.get(parentShardId);
                if (childShardIds == null) {
                    childShardIds = new HashSet<String>();
                    shardIdToChildShardIdsMap.put(parentShardId, childShardIds);
                }
                childShardIds.add(shardId);
            }
            if ((adjacentParentShardId = shard.getAdjacentParentShardId()) == null || !shardIdToShardMap.containsKey(adjacentParentShardId)) continue;
            HashSet<String> childShardIds = (HashSet<String>)shardIdToChildShardIdsMap.get(adjacentParentShardId);
            if (childShardIds == null) {
                childShardIds = new HashSet<String>();
                shardIdToChildShardIdsMap.put(adjacentParentShardId, childShardIds);
            }
            childShardIds.add(shardId);
        }
        return shardIdToChildShardIdsMap;
    }

    private List<Shard> getCompleteShardList(IKinesisProxy kinesisProxy) throws KinesisClientLibIOException {
        List<Shard> shards = kinesisProxy.getShardList();
        if (shards == null) {
            throw new KinesisClientLibIOException("Stream is not in ACTIVE OR UPDATING state - will retry getting the shard list.");
        }
        return shards;
    }

    private List<Shard> getShardListAtInitialPosition(IKinesisProxy kinesisProxy, InitialPositionInStreamExtended initialPosition) throws KinesisClientLibIOException {
        ShardFilter shardFilter = KinesisShardSyncer.getShardFilterAtInitialPosition(initialPosition);
        List<Shard> shards = kinesisProxy.getShardListWithFilter(shardFilter);
        if (shards == null) {
            throw new KinesisClientLibIOException("Stream is not in ACTIVE OR UPDATING state - will retry getting the shard list.");
        }
        return shards;
    }

    private static ShardFilter getShardFilterAtInitialPosition(InitialPositionInStreamExtended initialPosition) {
        ShardFilter shardFilter = new ShardFilter();
        switch (initialPosition.getInitialPositionInStream()) {
            case LATEST: {
                shardFilter = shardFilter.withType(ShardFilterType.AT_LATEST);
                break;
            }
            case TRIM_HORIZON: {
                shardFilter = shardFilter.withType(ShardFilterType.AT_TRIM_HORIZON);
                break;
            }
            case AT_TIMESTAMP: {
                shardFilter = shardFilter.withType(ShardFilterType.AT_TIMESTAMP).withTimestamp(initialPosition.getTimestamp());
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)initialPosition.getInitialPositionInStream()) + " is not a supported initial position in a Kinesis stream. Supported initial positions are AT_LATEST, AT_TRIM_HORIZON, and AT_TIMESTAMP.");
            }
        }
        return shardFilter;
    }

    List<KinesisClientLease> determineNewLeasesToCreate(LeaseSynchronizer leaseSynchronizer, List<Shard> shards, List<KinesisClientLease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds) {
        return leaseSynchronizer.determineNewLeasesToCreate(shards, currentLeases, initialPosition, inconsistentShardIds);
    }

    List<KinesisClientLease> determineNewLeasesToCreate(LeaseSynchronizer leaseSynchronizer, List<Shard> shards, List<KinesisClientLease> currentLeases, InitialPositionInStreamExtended initialPosition) {
        HashSet<String> inconsistentShardIds = new HashSet<String>();
        return this.determineNewLeasesToCreate(leaseSynchronizer, shards, currentLeases, initialPosition, inconsistentShardIds);
    }

    static boolean checkIfDescendantAndAddNewLeasesForAncestors(String shardId, InitialPositionInStreamExtended initialPosition, Set<String> shardIdsOfCurrentLeases, Map<String, Shard> shardIdToShardMapOfAllKinesisShards, Map<String, KinesisClientLease> shardIdToLeaseMapOfNewShards, MemoizationContext memoizationContext) {
        Boolean previousValue = memoizationContext.isDescendant(shardId);
        if (previousValue != null) {
            return previousValue;
        }
        boolean isDescendant = false;
        HashSet<String> descendantParentShardIds = new HashSet<String>();
        if (shardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(shardId)) {
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                isDescendant = true;
            } else {
                Shard shard = shardIdToShardMapOfAllKinesisShards.get(shardId);
                Set<String> parentShardIds = KinesisShardSyncer.getParentShardIds(shard, shardIdToShardMapOfAllKinesisShards);
                for (String parentShardId : parentShardIds) {
                    boolean isParentDescendant = KinesisShardSyncer.checkIfDescendantAndAddNewLeasesForAncestors(parentShardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToLeaseMapOfNewShards, memoizationContext);
                    if (isParentDescendant || memoizationContext.shouldCreateLease(parentShardId).booleanValue()) {
                        isDescendant = true;
                        descendantParentShardIds.add(parentShardId);
                        LOG.debug((Object)("Parent shard " + parentShardId + " is a descendant."));
                        continue;
                    }
                    LOG.debug((Object)("Parent shard " + parentShardId + " is NOT a descendant."));
                }
                if (isDescendant) {
                    for (String parentShardId : parentShardIds) {
                        if (shardIdsOfCurrentLeases.contains(parentShardId)) continue;
                        KinesisClientLease lease = shardIdToLeaseMapOfNewShards.get(parentShardId);
                        if (lease == null && (memoizationContext.shouldCreateLease(parentShardId).booleanValue() || !descendantParentShardIds.contains(parentShardId))) {
                            LOG.debug((Object)("Need to create a lease for shardId " + parentShardId));
                            lease = KinesisShardSyncer.newKCLLease(shardIdToShardMapOfAllKinesisShards.get(parentShardId));
                            shardIdToLeaseMapOfNewShards.put(parentShardId, lease);
                        }
                        if (lease == null) continue;
                        if (descendantParentShardIds.contains(parentShardId) && !initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
                            lease.setCheckpoint(ExtendedSequenceNumber.TRIM_HORIZON);
                            continue;
                        }
                        lease.setCheckpoint(KinesisShardSyncer.convertToCheckpoint(initialPosition));
                    }
                } else if (initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.TRIM_HORIZON) || initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
                    memoizationContext.setShouldCreateLease(shardId, true);
                }
            }
        }
        memoizationContext.setIsDescendant(shardId, isDescendant);
        return isDescendant;
    }

    static Set<String> getParentShardIds(Shard shard, Map<String, Shard> shardIdToShardMapOfAllKinesisShards) {
        String adjacentParentShardId;
        HashSet<String> parentShardIds = new HashSet<String>(2);
        String parentShardId = shard.getParentShardId();
        if (parentShardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(parentShardId)) {
            parentShardIds.add(parentShardId);
        }
        if ((adjacentParentShardId = shard.getAdjacentParentShardId()) != null && shardIdToShardMapOfAllKinesisShards.containsKey(adjacentParentShardId)) {
            parentShardIds.add(adjacentParentShardId);
        }
        return parentShardIds;
    }

    static KinesisClientLease newKCLLease(Shard shard) {
        KinesisClientLease newLease = new KinesisClientLease();
        newLease.setLeaseKey(shard.getShardId());
        ArrayList<String> parentShardIds = new ArrayList<String>(2);
        if (shard.getParentShardId() != null) {
            parentShardIds.add(shard.getParentShardId());
        }
        if (shard.getAdjacentParentShardId() != null) {
            parentShardIds.add(shard.getAdjacentParentShardId());
        }
        newLease.setParentShardIds(parentShardIds);
        newLease.setOwnerSwitchesSinceCheckpoint(0L);
        return newLease;
    }

    static KinesisClientLease newKCLLeaseForChildShard(ChildShard childShard) throws InvalidStateException {
        KinesisClientLease newLease = new KinesisClientLease();
        newLease.setLeaseKey(childShard.getShardId());
        ArrayList<String> parentShardIds = new ArrayList<String>();
        if (CollectionUtils.isNullOrEmpty((Collection)childShard.getParentShards())) {
            throw new InvalidStateException("Unable to populate new lease for child shard " + childShard.getShardId() + " because parent shards cannot be found.");
        }
        parentShardIds.addAll(childShard.getParentShards());
        newLease.setParentShardIds(parentShardIds);
        newLease.setOwnerSwitchesSinceCheckpoint(0L);
        newLease.setCheckpoint(ExtendedSequenceNumber.TRIM_HORIZON);
        return newLease;
    }

    static Map<String, Shard> constructShardIdToShardMap(List<Shard> shards) {
        HashMap<String, Shard> shardIdToShardMap = new HashMap<String, Shard>();
        for (Shard shard : shards) {
            shardIdToShardMap.put(shard.getShardId(), shard);
        }
        return shardIdToShardMap;
    }

    static List<Shard> getOpenShards(List<Shard> allShards) {
        ArrayList<Shard> openShards = new ArrayList<Shard>();
        for (Shard shard : allShards) {
            String endingSequenceNumber = shard.getSequenceNumberRange().getEndingSequenceNumber();
            if (endingSequenceNumber != null) continue;
            openShards.add(shard);
            LOG.debug((Object)("Found open shard: " + shard.getShardId()));
        }
        return openShards;
    }

    static ExtendedSequenceNumber convertToCheckpoint(InitialPositionInStreamExtended position) {
        ExtendedSequenceNumber checkpoint = null;
        if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.TRIM_HORIZON)) {
            checkpoint = ExtendedSequenceNumber.TRIM_HORIZON;
        } else if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.LATEST)) {
            checkpoint = ExtendedSequenceNumber.LATEST;
        } else if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
            checkpoint = ExtendedSequenceNumber.AT_TIMESTAMP;
        }
        return checkpoint;
    }

    static class MemoizationContext {
        private Map<String, Boolean> isDescendantMap = new HashMap<String, Boolean>();
        private Map<String, Boolean> shouldCreateLeaseMap = new HashMap<String, Boolean>();

        Boolean isDescendant(String shardId) {
            return this.isDescendantMap.get(shardId);
        }

        void setIsDescendant(String shardId, Boolean isDescendant) {
            this.isDescendantMap.put(shardId, isDescendant);
        }

        Boolean shouldCreateLease(String shardId) {
            return this.shouldCreateLeaseMap.computeIfAbsent(shardId, x -> Boolean.FALSE);
        }

        void setShouldCreateLease(String shardId, Boolean shouldCreateLease) {
            this.shouldCreateLeaseMap.put(shardId, shouldCreateLease);
        }
    }

    static class StartingSequenceNumberAndShardIdBasedComparator
    implements Comparator<KinesisClientLease>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, Shard> shardIdToShardMap;

        public StartingSequenceNumberAndShardIdBasedComparator(Map<String, Shard> shardIdToShardMapOfAllKinesisShards) {
            this.shardIdToShardMap = shardIdToShardMapOfAllKinesisShards;
        }

        @Override
        public int compare(KinesisClientLease lease1, KinesisClientLease lease2) {
            int result = 0;
            String shardId1 = lease1.getLeaseKey();
            String shardId2 = lease2.getLeaseKey();
            Shard shard1 = this.shardIdToShardMap.get(shardId1);
            Shard shard2 = this.shardIdToShardMap.get(shardId2);
            if (shard1 != null && shard2 != null) {
                BigInteger sequenceNumber1 = new BigInteger(shard1.getSequenceNumberRange().getStartingSequenceNumber());
                BigInteger sequenceNumber2 = new BigInteger(shard2.getSequenceNumberRange().getStartingSequenceNumber());
                result = sequenceNumber1.compareTo(sequenceNumber2);
            }
            if (result == 0) {
                result = shardId1.compareTo(shardId2);
            }
            return result;
        }
    }
}

