/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.multilang;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.config.KinesisClientLibConfigurator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.multilang.MultiLangRecordProcessorFactory;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Security;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiLangDaemonConfig {
    private static final Log LOG = LogFactory.getLog(MultiLangDaemonConfig.class);
    private static final String USER_AGENT = "amazon-kinesis-multi-lang-daemon";
    private static final String VERSION = "1.0.1";
    private static final String PROP_EXECUTABLE_NAME = "executableName";
    private static final String PROP_PROCESSING_LANGUAGE = "processingLanguage";
    private static final String PROP_MAX_ACTIVE_THREADS = "maxActiveThreads";
    public static final String PROXY_HOST_PROP = "http.proxyHost";
    public static final String PROXY_PORT_PROP = "http.proxyPort";
    public static final String HTTP_PROXY_ENV_VAR = "HTTP_PROXY";
    private KinesisClientLibConfiguration kinesisClientLibConfig;
    private ExecutorService executorService;
    private MultiLangRecordProcessorFactory recordProcessorFactory;

    public MultiLangDaemonConfig(String propertiesFile) throws IOException, IllegalArgumentException {
        this(propertiesFile, Thread.currentThread().getContextClassLoader());
    }

    public MultiLangDaemonConfig(String propertiesFile, ClassLoader classLoader) throws IOException, IllegalArgumentException {
        this(propertiesFile, classLoader, new KinesisClientLibConfigurator());
    }

    public MultiLangDaemonConfig(String propertiesFile, ClassLoader classLoader, KinesisClientLibConfigurator configurator) throws IOException, IllegalArgumentException {
        Properties properties = MultiLangDaemonConfig.loadProperties(classLoader, propertiesFile);
        if (!MultiLangDaemonConfig.validateProperties(properties)) {
            throw new IllegalArgumentException("Must provide an executable name in the properties file, e.g. executableName = sampleapp.py");
        }
        String executableName = properties.getProperty(PROP_EXECUTABLE_NAME);
        String processingLanguage = properties.getProperty(PROP_PROCESSING_LANGUAGE);
        ClientConfiguration clientConfig = this.buildClientConfig(properties);
        this.kinesisClientLibConfig = configurator.getConfiguration(properties).withKinesisClientConfig(clientConfig).withCloudWatchClientConfig(clientConfig).withDynamoDBClientConfig(clientConfig);
        this.executorService = MultiLangDaemonConfig.buildExecutorService(properties);
        this.recordProcessorFactory = new MultiLangRecordProcessorFactory(executableName, this.executorService, this.kinesisClientLibConfig);
        LOG.info((Object)("Running " + this.kinesisClientLibConfig.getApplicationName() + " to process stream " + this.kinesisClientLibConfig.getStreamName() + " with executable " + executableName));
        this.prepare(processingLanguage);
    }

    private ClientConfiguration buildClientConfig(Properties properties) {
        ClientConfiguration clientConfig = new ClientConfiguration();
        String proxyHost = null;
        int proxyPort = 0;
        if (properties.getProperty(PROXY_HOST_PROP) != null) {
            LOG.debug((Object)"Getting proxy info from properties file.");
            proxyHost = properties.getProperty(PROXY_HOST_PROP);
            proxyPort = Integer.parseInt(properties.getProperty(PROXY_PORT_PROP));
        } else if (System.getProperty(PROXY_HOST_PROP) != null) {
            LOG.debug((Object)"Getting proxy info from java system properties");
            proxyHost = System.getProperty(PROXY_HOST_PROP);
            proxyPort = Integer.parseInt(System.getProperty(PROXY_PORT_PROP));
        } else if (System.getenv(HTTP_PROXY_ENV_VAR) != null) {
            LOG.debug((Object)"Getting proxy info environment settings");
            try {
                URI proxyAddr = new URI(System.getenv(HTTP_PROXY_ENV_VAR));
                proxyHost = proxyAddr.getHost();
                proxyPort = proxyAddr.getPort();
            }
            catch (URISyntaxException e) {
                LOG.error((Object)"System proxy not set correctly", (Throwable)e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)proxyHost) && proxyPort > 0) {
            clientConfig = clientConfig.withProxyHost(proxyHost).withProxyPort(proxyPort);
        } else {
            LOG.debug((Object)"Not configuring proxy as none specified");
        }
        return clientConfig;
    }

    private void prepare(String processingLanguage) {
        Security.setProperty("networkaddress.cache.ttl", "60");
        LOG.info((Object)("Using workerId: " + this.kinesisClientLibConfig.getWorkerIdentifier()));
        LOG.info((Object)("Using credentials with access key id: " + this.kinesisClientLibConfig.getKinesisCredentialsProvider().getCredentials().getAWSAccessKeyId()));
        StringBuilder userAgent = new StringBuilder("amazon-kinesis-client-library-java-1.11.0");
        userAgent.append(" ");
        userAgent.append(USER_AGENT);
        userAgent.append("/");
        userAgent.append(VERSION);
        if (processingLanguage != null) {
            userAgent.append(" ");
            userAgent.append(processingLanguage);
        }
        if (this.recordProcessorFactory.getCommandArray().length > 0) {
            userAgent.append(" ");
            userAgent.append(this.recordProcessorFactory.getCommandArray()[0]);
        }
        LOG.info((Object)String.format("MultiLangDaemon is adding the following fields to the User Agent: %s", userAgent.toString()));
        this.kinesisClientLibConfig.withUserAgent(userAgent.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(ClassLoader classLoader, String propertiesFileName) throws IOException {
        Properties properties = new Properties();
        try (InputStream propertyStream = null;){
            File propertyFile;
            propertyStream = classLoader.getResourceAsStream(propertiesFileName);
            if (propertyStream == null && (propertyFile = new File(propertiesFileName)).exists()) {
                propertyStream = new FileInputStream(propertyFile);
            }
            if (propertyStream == null) {
                throw new FileNotFoundException("Unable to find property file in classpath, or file system: '" + propertiesFileName + "'");
            }
            properties.load(propertyStream);
            Properties properties2 = properties;
            return properties2;
        }
    }

    private static boolean validateProperties(Properties properties) {
        return properties != null && properties.getProperty(PROP_EXECUTABLE_NAME) != null;
    }

    private static int getMaxActiveThreads(Properties properties) {
        return Integer.parseInt(properties.getProperty(PROP_MAX_ACTIVE_THREADS, "0"));
    }

    private static ExecutorService buildExecutorService(Properties properties) {
        int maxActiveThreads = MultiLangDaemonConfig.getMaxActiveThreads(properties);
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setNameFormat("multi-lang-daemon-%04d");
        LOG.debug((Object)String.format("Value for %s property is %d", PROP_MAX_ACTIVE_THREADS, maxActiveThreads));
        if (maxActiveThreads <= 0) {
            LOG.info((Object)"Using a cached thread pool.");
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), builder.build());
        }
        LOG.info((Object)String.format("Using a fixed thread pool with %d max active threads.", maxActiveThreads));
        return new ThreadPoolExecutor(maxActiveThreads, maxActiveThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), builder.build());
    }

    public KinesisClientLibConfiguration getKinesisClientLibConfiguration() {
        return this.kinesisClientLibConfig;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public MultiLangRecordProcessorFactory getRecordProcessorFactory() {
        return this.recordProcessorFactory;
    }
}

