/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.internal.KinesisClientLibIOException;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaseCleanupValidator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.leases.exceptions.DependencyException;
import com.amazonaws.services.kinesis.leases.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.leases.exceptions.ProvisionedThroughputException;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import com.amazonaws.services.kinesis.model.Shard;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class KinesisShardSyncer
implements ShardSyncer {
    private static final Log LOG = LogFactory.getLog(KinesisShardSyncer.class);
    private final LeaseCleanupValidator leaseCleanupValidator;

    public KinesisShardSyncer(LeaseCleanupValidator leaseCleanupValidator) {
        this.leaseCleanupValidator = leaseCleanupValidator;
    }

    synchronized void bootstrapShardLeases(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        this.syncShardLeases(kinesisProxy, leaseManager, initialPositionInStream, cleanupLeasesOfCompletedShards, ignoreUnexpectedChildShards);
    }

    @Override
    public synchronized void checkAndCreateLeasesForNewShards(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        this.syncShardLeases(kinesisProxy, leaseManager, initialPositionInStream, cleanupLeasesOfCompletedShards, ignoreUnexpectedChildShards);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void syncShardLeases(IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager, InitialPositionInStreamExtended initialPosition, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        List<Shard> shards = this.getShardList(kinesisProxy);
        LOG.debug((Object)("Num shards: " + shards.size()));
        Map<String, Shard> shardIdToShardMap = this.constructShardIdToShardMap(shards);
        Map<String, Set<String>> shardIdToChildShardIdsMap = this.constructShardIdToChildShardIdsMap(shardIdToShardMap);
        Set<String> inconsistentShardIds = this.findInconsistentShardIds(shardIdToChildShardIdsMap, shardIdToShardMap);
        if (!ignoreUnexpectedChildShards) {
            this.assertAllParentShardsAreClosed(inconsistentShardIds);
        }
        List<KinesisClientLease> currentLeases = leaseManager.listLeases();
        List<KinesisClientLease> newLeasesToCreate = this.determineNewLeasesToCreate(shards, currentLeases, initialPosition, inconsistentShardIds);
        LOG.debug((Object)("Num new leases to create: " + newLeasesToCreate.size()));
        for (KinesisClientLease lease : newLeasesToCreate) {
            long startTimeMillis = System.currentTimeMillis();
            boolean success = false;
            try {
                leaseManager.createLeaseIfNotExists(lease);
                success = true;
            }
            finally {
                MetricsHelper.addSuccessAndLatency("CreateLease", startTimeMillis, success, MetricsLevel.DETAILED);
            }
        }
        ArrayList<KinesisClientLease> trackedLeases = new ArrayList<KinesisClientLease>();
        if (currentLeases != null) {
            trackedLeases.addAll(currentLeases);
        }
        trackedLeases.addAll(newLeasesToCreate);
        this.cleanupGarbageLeases(shards, trackedLeases, kinesisProxy, leaseManager);
        if (cleanupLeasesOfCompletedShards) {
            this.cleanupLeasesOfFinishedShards(currentLeases, shardIdToShardMap, shardIdToChildShardIdsMap, trackedLeases, leaseManager);
        }
    }

    private void assertAllParentShardsAreClosed(Set<String> inconsistentShardIds) throws KinesisClientLibIOException {
        if (!inconsistentShardIds.isEmpty()) {
            String ids = StringUtils.join(inconsistentShardIds, (char)' ');
            throw new KinesisClientLibIOException(String.format("%d open child shards (%s) are inconsistent. This can happen due to a race condition between describeStream and a reshard operation.", inconsistentShardIds.size(), ids));
        }
    }

    private Set<String> findInconsistentShardIds(Map<String, Set<String>> shardIdToChildShardIdsMap, Map<String, Shard> shardIdToShardMap) {
        HashSet<String> result = new HashSet<String>();
        for (String parentShardId : shardIdToChildShardIdsMap.keySet()) {
            Shard parentShard = shardIdToShardMap.get(parentShardId);
            if (parentShardId != null && parentShard.getSequenceNumberRange().getEndingSequenceNumber() != null) continue;
            Set<String> childShardIdsMap = shardIdToChildShardIdsMap.get(parentShardId);
            result.addAll(childShardIdsMap);
        }
        return result;
    }

    Map<String, KinesisClientLease> constructShardIdToKCLLeaseMap(List<KinesisClientLease> trackedLeaseList) {
        HashMap<String, KinesisClientLease> trackedLeasesMap = new HashMap<String, KinesisClientLease>();
        for (KinesisClientLease lease : trackedLeaseList) {
            trackedLeasesMap.put(lease.getLeaseKey(), lease);
        }
        return trackedLeasesMap;
    }

    synchronized void assertClosedShardsAreCoveredOrAbsent(Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap, Set<String> shardIdsOfClosedShards) throws KinesisClientLibIOException {
        String exceptionMessageSuffix = "This can happen if we constructed the list of shards  while a reshard operation was in progress.";
        for (String shardId : shardIdsOfClosedShards) {
            Shard shard = shardIdToShardMap.get(shardId);
            if (shard == null) {
                LOG.info((Object)("Shard " + shardId + " is not present in Kinesis anymore."));
                continue;
            }
            String endingSequenceNumber = shard.getSequenceNumberRange().getEndingSequenceNumber();
            if (endingSequenceNumber == null) {
                throw new KinesisClientLibIOException("Shard " + shardIdsOfClosedShards + " is not closed. " + exceptionMessageSuffix);
            }
            Set<String> childShardIds = shardIdToChildShardIdsMap.get(shardId);
            if (childShardIds == null) {
                throw new KinesisClientLibIOException("Incomplete shard list: Closed shard " + shardId + " has no children." + exceptionMessageSuffix);
            }
            this.assertHashRangeOfClosedShardIsCovered(shard, shardIdToShardMap, childShardIds);
        }
    }

    private synchronized void assertHashRangeOfClosedShardIsCovered(Shard closedShard, Map<String, Shard> shardIdToShardMap, Set<String> childShardIds) throws KinesisClientLibIOException {
        BigInteger startingHashKeyOfClosedShard = new BigInteger(closedShard.getHashKeyRange().getStartingHashKey());
        BigInteger endingHashKeyOfClosedShard = new BigInteger(closedShard.getHashKeyRange().getEndingHashKey());
        BigInteger minStartingHashKeyOfChildren = null;
        BigInteger maxEndingHashKeyOfChildren = null;
        for (String childShardId : childShardIds) {
            Shard childShard = shardIdToShardMap.get(childShardId);
            BigInteger startingHashKey = new BigInteger(childShard.getHashKeyRange().getStartingHashKey());
            if (minStartingHashKeyOfChildren == null || startingHashKey.compareTo(minStartingHashKeyOfChildren) < 0) {
                minStartingHashKeyOfChildren = startingHashKey;
            }
            BigInteger endingHashKey = new BigInteger(childShard.getHashKeyRange().getEndingHashKey());
            if (maxEndingHashKeyOfChildren != null && endingHashKey.compareTo(maxEndingHashKeyOfChildren) <= 0) continue;
            maxEndingHashKeyOfChildren = endingHashKey;
        }
        if (minStartingHashKeyOfChildren == null || maxEndingHashKeyOfChildren == null || minStartingHashKeyOfChildren.compareTo(startingHashKeyOfClosedShard) > 0 || maxEndingHashKeyOfChildren.compareTo(endingHashKeyOfClosedShard) < 0) {
            throw new KinesisClientLibIOException("Incomplete shard list: hash key range of shard " + closedShard.getShardId() + " is not covered by its child shards.");
        }
    }

    Map<String, Set<String>> constructShardIdToChildShardIdsMap(Map<String, Shard> shardIdToShardMap) {
        HashMap<String, Set<String>> shardIdToChildShardIdsMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Shard> entry : shardIdToShardMap.entrySet()) {
            String adjacentParentShardId;
            String shardId = entry.getKey();
            Shard shard = entry.getValue();
            String parentShardId = shard.getParentShardId();
            if (parentShardId != null && shardIdToShardMap.containsKey(parentShardId)) {
                HashSet<String> childShardIds = (HashSet<String>)shardIdToChildShardIdsMap.get(parentShardId);
                if (childShardIds == null) {
                    childShardIds = new HashSet<String>();
                    shardIdToChildShardIdsMap.put(parentShardId, childShardIds);
                }
                childShardIds.add(shardId);
            }
            if ((adjacentParentShardId = shard.getAdjacentParentShardId()) == null || !shardIdToShardMap.containsKey(adjacentParentShardId)) continue;
            HashSet<String> childShardIds = (HashSet<String>)shardIdToChildShardIdsMap.get(adjacentParentShardId);
            if (childShardIds == null) {
                childShardIds = new HashSet<String>();
                shardIdToChildShardIdsMap.put(adjacentParentShardId, childShardIds);
            }
            childShardIds.add(shardId);
        }
        return shardIdToChildShardIdsMap;
    }

    private List<Shard> getShardList(IKinesisProxy kinesisProxy) throws KinesisClientLibIOException {
        List<Shard> shards = kinesisProxy.getShardList();
        if (shards == null) {
            throw new KinesisClientLibIOException("Stream is not in ACTIVE OR UPDATING state - will retry getting the shard list.");
        }
        return shards;
    }

    List<KinesisClientLease> determineNewLeasesToCreate(List<Shard> shards, List<KinesisClientLease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds) {
        HashMap<String, KinesisClientLease> shardIdToNewLeaseMap = new HashMap<String, KinesisClientLease>();
        Map<String, Shard> shardIdToShardMapOfAllKinesisShards = this.constructShardIdToShardMap(shards);
        HashSet<String> shardIdsOfCurrentLeases = new HashSet<String>();
        for (KinesisClientLease lease : currentLeases) {
            shardIdsOfCurrentLeases.add(lease.getLeaseKey());
            LOG.debug((Object)("Existing lease: " + lease));
        }
        List<Shard> openShards = this.getOpenShards(shards);
        HashMap<String, Boolean> memoizationContext = new HashMap<String, Boolean>();
        for (Shard shard : openShards) {
            String shardId = shard.getShardId();
            LOG.debug((Object)("Evaluating leases for open shard " + shardId + " and its ancestors."));
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                LOG.debug((Object)("Lease for shardId " + shardId + " already exists. Not creating a lease"));
                continue;
            }
            if (inconsistentShardIds.contains(shardId)) {
                LOG.info((Object)("shardId " + shardId + " is an inconsistent child.  Not creating a lease"));
                continue;
            }
            LOG.debug((Object)("Need to create a lease for shardId " + shardId));
            KinesisClientLease newLease = this.newKCLLease(shard);
            boolean isDescendant = this.checkIfDescendantAndAddNewLeasesForAncestors(shardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToNewLeaseMap, memoizationContext);
            if (isDescendant && !initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
                newLease.setCheckpoint(ExtendedSequenceNumber.TRIM_HORIZON);
            } else {
                newLease.setCheckpoint(this.convertToCheckpoint(initialPosition));
            }
            LOG.debug((Object)("Set checkpoint of " + newLease.getLeaseKey() + " to " + newLease.getCheckpoint()));
            shardIdToNewLeaseMap.put(shardId, newLease);
        }
        ArrayList<KinesisClientLease> newLeasesToCreate = new ArrayList<KinesisClientLease>();
        newLeasesToCreate.addAll(shardIdToNewLeaseMap.values());
        StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMapOfAllKinesisShards);
        Collections.sort(newLeasesToCreate, startingSequenceNumberComparator);
        return newLeasesToCreate;
    }

    List<KinesisClientLease> determineNewLeasesToCreate(List<Shard> shards, List<KinesisClientLease> currentLeases, InitialPositionInStreamExtended initialPosition) {
        HashSet<String> inconsistentShardIds = new HashSet<String>();
        return this.determineNewLeasesToCreate(shards, currentLeases, initialPosition, inconsistentShardIds);
    }

    boolean checkIfDescendantAndAddNewLeasesForAncestors(String shardId, InitialPositionInStreamExtended initialPosition, Set<String> shardIdsOfCurrentLeases, Map<String, Shard> shardIdToShardMapOfAllKinesisShards, Map<String, KinesisClientLease> shardIdToLeaseMapOfNewShards, Map<String, Boolean> memoizationContext) {
        Boolean previousValue = memoizationContext.get(shardId);
        if (previousValue != null) {
            return previousValue;
        }
        boolean isDescendant = false;
        HashSet<String> descendantParentShardIds = new HashSet<String>();
        if (shardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(shardId)) {
            if (shardIdsOfCurrentLeases.contains(shardId)) {
                isDescendant = true;
            } else {
                Shard shard = shardIdToShardMapOfAllKinesisShards.get(shardId);
                Set<String> parentShardIds = this.getParentShardIds(shard, shardIdToShardMapOfAllKinesisShards);
                for (String parentShardId : parentShardIds) {
                    if (this.checkIfDescendantAndAddNewLeasesForAncestors(parentShardId, initialPosition, shardIdsOfCurrentLeases, shardIdToShardMapOfAllKinesisShards, shardIdToLeaseMapOfNewShards, memoizationContext)) {
                        isDescendant = true;
                        descendantParentShardIds.add(parentShardId);
                        LOG.debug((Object)("Parent shard " + parentShardId + " is a descendant."));
                        continue;
                    }
                    LOG.debug((Object)("Parent shard " + parentShardId + " is NOT a descendant."));
                }
                if (isDescendant) {
                    for (String parentShardId : parentShardIds) {
                        if (shardIdsOfCurrentLeases.contains(parentShardId)) continue;
                        LOG.debug((Object)("Need to create a lease for shardId " + parentShardId));
                        KinesisClientLease lease = shardIdToLeaseMapOfNewShards.get(parentShardId);
                        if (lease == null) {
                            lease = this.newKCLLease(shardIdToShardMapOfAllKinesisShards.get(parentShardId));
                            shardIdToLeaseMapOfNewShards.put(parentShardId, lease);
                        }
                        if (descendantParentShardIds.contains(parentShardId) && !initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
                            lease.setCheckpoint(ExtendedSequenceNumber.TRIM_HORIZON);
                            continue;
                        }
                        lease.setCheckpoint(this.convertToCheckpoint(initialPosition));
                    }
                } else if (initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.TRIM_HORIZON) || initialPosition.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
                    isDescendant = true;
                }
            }
        }
        memoizationContext.put(shardId, isDescendant);
        return isDescendant;
    }

    Set<String> getParentShardIds(Shard shard, Map<String, Shard> shardIdToShardMapOfAllKinesisShards) {
        String adjacentParentShardId;
        HashSet<String> parentShardIds = new HashSet<String>(2);
        String parentShardId = shard.getParentShardId();
        if (parentShardId != null && shardIdToShardMapOfAllKinesisShards.containsKey(parentShardId)) {
            parentShardIds.add(parentShardId);
        }
        if ((adjacentParentShardId = shard.getAdjacentParentShardId()) != null && shardIdToShardMapOfAllKinesisShards.containsKey(adjacentParentShardId)) {
            parentShardIds.add(adjacentParentShardId);
        }
        return parentShardIds;
    }

    private void cleanupGarbageLeases(List<Shard> shards, List<KinesisClientLease> trackedLeases, IKinesisProxy kinesisProxy, ILeaseManager<KinesisClientLease> leaseManager) throws KinesisClientLibIOException, DependencyException, InvalidStateException, ProvisionedThroughputException {
        HashSet<String> kinesisShards = new HashSet<String>();
        for (Shard shard : shards) {
            kinesisShards.add(shard.getShardId());
        }
        ArrayList<KinesisClientLease> garbageLeases = new ArrayList<KinesisClientLease>();
        for (KinesisClientLease lease : trackedLeases) {
            if (!this.leaseCleanupValidator.isCandidateForCleanup(lease, kinesisShards)) continue;
            garbageLeases.add(lease);
        }
        if (!garbageLeases.isEmpty()) {
            LOG.info((Object)("Found " + garbageLeases.size() + " candidate leases for cleanup. Refreshing list of Kinesis shards to pick up recent/latest shards"));
            List<Shard> list = this.getShardList(kinesisProxy);
            HashSet<String> currentKinesisShardIds = new HashSet<String>();
            for (Shard shard : list) {
                currentKinesisShardIds.add(shard.getShardId());
            }
            for (KinesisClientLease lease : garbageLeases) {
                if (!this.leaseCleanupValidator.isCandidateForCleanup(lease, currentKinesisShardIds)) continue;
                LOG.info((Object)("Deleting lease for shard " + lease.getLeaseKey() + " as it is not present in Kinesis stream."));
                leaseManager.deleteLease(lease);
            }
        }
    }

    private synchronized void cleanupLeasesOfFinishedShards(Collection<KinesisClientLease> currentLeases, Map<String, Shard> shardIdToShardMap, Map<String, Set<String>> shardIdToChildShardIdsMap, List<KinesisClientLease> trackedLeases, ILeaseManager<KinesisClientLease> leaseManager) throws DependencyException, InvalidStateException, ProvisionedThroughputException, KinesisClientLibIOException {
        HashSet<String> shardIdsOfClosedShards = new HashSet<String>();
        ArrayList<KinesisClientLease> leasesOfClosedShards = new ArrayList<KinesisClientLease>();
        for (KinesisClientLease lease : currentLeases) {
            if (!lease.getCheckpoint().equals(ExtendedSequenceNumber.SHARD_END)) continue;
            shardIdsOfClosedShards.add(lease.getLeaseKey());
            leasesOfClosedShards.add(lease);
        }
        if (!leasesOfClosedShards.isEmpty()) {
            this.assertClosedShardsAreCoveredOrAbsent(shardIdToShardMap, shardIdToChildShardIdsMap, shardIdsOfClosedShards);
            StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMap);
            Collections.sort(leasesOfClosedShards, startingSequenceNumberComparator);
            Map<String, KinesisClientLease> trackedLeaseMap = this.constructShardIdToKCLLeaseMap(trackedLeases);
            for (KinesisClientLease leaseOfClosedShard : leasesOfClosedShards) {
                String closedShardId = leaseOfClosedShard.getLeaseKey();
                Set<String> childShardIds = shardIdToChildShardIdsMap.get(closedShardId);
                if (closedShardId == null || childShardIds == null || childShardIds.isEmpty()) continue;
                this.cleanupLeaseForClosedShard(closedShardId, childShardIds, trackedLeaseMap, leaseManager);
            }
        }
    }

    synchronized void cleanupLeaseForClosedShard(String closedShardId, Set<String> childShardIds, Map<String, KinesisClientLease> trackedLeases, ILeaseManager<KinesisClientLease> leaseManager) throws DependencyException, InvalidStateException, ProvisionedThroughputException {
        KinesisClientLease leaseForClosedShard = trackedLeases.get(closedShardId);
        ArrayList<KinesisClientLease> childShardLeases = new ArrayList<KinesisClientLease>();
        for (String childShardId : childShardIds) {
            KinesisClientLease childLease = trackedLeases.get(childShardId);
            if (childLease == null) continue;
            childShardLeases.add(childLease);
        }
        if (leaseForClosedShard != null && leaseForClosedShard.getCheckpoint().equals(ExtendedSequenceNumber.SHARD_END) && childShardLeases.size() == childShardIds.size()) {
            boolean okayToDelete = true;
            for (KinesisClientLease lease : childShardLeases) {
                if (!lease.getCheckpoint().equals(ExtendedSequenceNumber.TRIM_HORIZON)) continue;
                okayToDelete = false;
                break;
            }
            if (okayToDelete) {
                LOG.info((Object)("Deleting lease for shard " + leaseForClosedShard.getLeaseKey() + " as it has been completely processed and processing of child shards has begun."));
                leaseManager.deleteLease(leaseForClosedShard);
            }
        }
    }

    KinesisClientLease newKCLLease(Shard shard) {
        KinesisClientLease newLease = new KinesisClientLease();
        newLease.setLeaseKey(shard.getShardId());
        ArrayList<String> parentShardIds = new ArrayList<String>(2);
        if (shard.getParentShardId() != null) {
            parentShardIds.add(shard.getParentShardId());
        }
        if (shard.getAdjacentParentShardId() != null) {
            parentShardIds.add(shard.getAdjacentParentShardId());
        }
        newLease.setParentShardIds(parentShardIds);
        newLease.setOwnerSwitchesSinceCheckpoint(0L);
        return newLease;
    }

    Map<String, Shard> constructShardIdToShardMap(List<Shard> shards) {
        HashMap<String, Shard> shardIdToShardMap = new HashMap<String, Shard>();
        for (Shard shard : shards) {
            shardIdToShardMap.put(shard.getShardId(), shard);
        }
        return shardIdToShardMap;
    }

    List<Shard> getOpenShards(List<Shard> allShards) {
        ArrayList<Shard> openShards = new ArrayList<Shard>();
        for (Shard shard : allShards) {
            String endingSequenceNumber = shard.getSequenceNumberRange().getEndingSequenceNumber();
            if (endingSequenceNumber != null) continue;
            openShards.add(shard);
            LOG.debug((Object)("Found open shard: " + shard.getShardId()));
        }
        return openShards;
    }

    private ExtendedSequenceNumber convertToCheckpoint(InitialPositionInStreamExtended position) {
        ExtendedSequenceNumber checkpoint = null;
        if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.TRIM_HORIZON)) {
            checkpoint = ExtendedSequenceNumber.TRIM_HORIZON;
        } else if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.LATEST)) {
            checkpoint = ExtendedSequenceNumber.LATEST;
        } else if (position.getInitialPositionInStream().equals((Object)InitialPositionInStream.AT_TIMESTAMP)) {
            checkpoint = ExtendedSequenceNumber.AT_TIMESTAMP;
        }
        return checkpoint;
    }

    private static class StartingSequenceNumberAndShardIdBasedComparator
    implements Comparator<KinesisClientLease>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, Shard> shardIdToShardMap;

        public StartingSequenceNumberAndShardIdBasedComparator(Map<String, Shard> shardIdToShardMapOfAllKinesisShards) {
            this.shardIdToShardMap = shardIdToShardMapOfAllKinesisShards;
        }

        @Override
        public int compare(KinesisClientLease lease1, KinesisClientLease lease2) {
            int result = 0;
            String shardId1 = lease1.getLeaseKey();
            String shardId2 = lease2.getLeaseKey();
            Shard shard1 = this.shardIdToShardMap.get(shardId1);
            Shard shard2 = this.shardIdToShardMap.get(shardId2);
            if (shard1 != null && shard2 != null) {
                BigInteger sequenceNumber1 = new BigInteger(shard1.getSequenceNumberRange().getStartingSequenceNumber());
                BigInteger sequenceNumber2 = new BigInteger(shard2.getSequenceNumberRange().getStartingSequenceNumber());
                result = sequenceNumber1.compareTo(sequenceNumber2);
            }
            if (result == 0) {
                result = shardId1.compareTo(shardId2);
            }
            return result;
        }
    }
}

