/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.metrics.impl;

import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.amazonaws.services.kinesis.metrics.impl.EndingMetricsScope;
import java.util.HashMap;
import java.util.Map;

public abstract class AccumulatingMetricsScope<KeyType>
extends EndingMetricsScope {
    protected Map<KeyType, MetricDatum> data = new HashMap<KeyType, MetricDatum>();

    @Override
    public void addData(String name, double value, StandardUnit unit) {
        this.addData(this.getKey(name), name, value, unit);
    }

    protected abstract KeyType getKey(String var1);

    public void addData(KeyType key, String name, double value, StandardUnit unit) {
        super.addData(name, value, unit);
        MetricDatum datum = this.data.get(key);
        if (datum == null) {
            this.data.put(key, new MetricDatum().withMetricName(name).withUnit(unit).withStatisticValues(new StatisticSet().withMaximum(Double.valueOf(value)).withMinimum(Double.valueOf(value)).withSampleCount(Double.valueOf(1.0)).withSum(Double.valueOf(value))));
        } else {
            if (!datum.getUnit().equals(unit.name())) {
                throw new IllegalArgumentException("Cannot add to existing metric with different unit");
            }
            StatisticSet statistics = datum.getStatisticValues();
            statistics.setMaximum(Double.valueOf(Math.max(value, statistics.getMaximum())));
            statistics.setMinimum(Double.valueOf(Math.min(value, statistics.getMinimum())));
            statistics.setSampleCount(Double.valueOf(statistics.getSampleCount() + 1.0));
            statistics.setSum(Double.valueOf(statistics.getSum() + value));
        }
    }
}

