/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.proxies.util;

import com.amazonaws.services.kinesis.clientlibrary.proxies.KinesisLocalFileProxy;
import com.amazonaws.services.kinesis.model.HashKeyRange;
import com.amazonaws.services.kinesis.model.SequenceNumberRange;
import com.amazonaws.services.kinesis.model.Shard;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class KinesisLocalFileDataCreator {
    public static final String PARTITION_KEY_PREFIX = "PK_";
    private static final String FILE_NAME_SUFFIX = ".dat";
    private static final long RAND_SEED_VALUE = 1092387456L;
    private static final int NUM_BITS = 3;
    private static Random randomGenerator = new Random(1092387456L);
    private static final int PARTITION_KEY_LENGTH = 10;
    private static final int DATA_LENGTH = 40;

    private KinesisLocalFileDataCreator() {
    }

    public static File generateTempDataFile(int numShards, String shardIdPrefix, int numRecordsPerShard, BigInteger startingSequenceNumber, String fileNamePrefix) throws IOException {
        List<Shard> shardList = KinesisLocalFileDataCreator.createShardList(numShards, shardIdPrefix, startingSequenceNumber);
        return KinesisLocalFileDataCreator.generateTempDataFile(shardList, numRecordsPerShard, fileNamePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File generateTempDataFile(List<Shard> shardList, int numRecordsPerShard, String fileNamePrefix) throws IOException {
        File file = File.createTempFile(fileNamePrefix, FILE_NAME_SUFFIX);
        BufferedWriter fileWriter = new BufferedWriter(new FileWriter(file));
        ObjectMapper objectMapper = new ObjectMapper();
        String serializedShardList = objectMapper.writeValueAsString((Object)new KinesisLocalFileProxy.SerializedShardList(shardList));
        fileWriter.write(serializedShardList);
        fileWriter.newLine();
        try {
            BigInteger sequenceNumberIncrement = new BigInteger("0");
            for (int i = 0; i < numRecordsPerShard; ++i) {
                for (Shard shard : shardList) {
                    BigInteger sequenceNumber = new BigInteger(shard.getSequenceNumberRange().getStartingSequenceNumber()).add(sequenceNumberIncrement);
                    String endingSequenceNumber = shard.getSequenceNumberRange().getEndingSequenceNumber();
                    BigInteger maxSequenceNumber = KinesisLocalFileProxy.MAX_SEQUENCE_NUMBER;
                    if (endingSequenceNumber != null) {
                        maxSequenceNumber = new BigInteger(endingSequenceNumber);
                    }
                    if (maxSequenceNumber.compareTo(sequenceNumber) != 1) {
                        throw new IllegalArgumentException("Not enough space in shard");
                    }
                    String partitionKey = PARTITION_KEY_PREFIX + shard.getShardId() + KinesisLocalFileDataCreator.generateRandomString(10);
                    String data = KinesisLocalFileDataCreator.generateRandomString(40);
                    String line = shard.getShardId() + "," + sequenceNumber + "," + partitionKey + "," + data;
                    fileWriter.write(line);
                    fileWriter.newLine();
                    sequenceNumberIncrement = sequenceNumberIncrement.add(BigInteger.ONE);
                    sequenceNumberIncrement = sequenceNumberIncrement.add(new BigInteger(3, randomGenerator));
                }
            }
        }
        finally {
            fileWriter.close();
        }
        return file;
    }

    public static List<Shard> createShardList(int numShards, String shardIdPrefix, BigInteger startingSequenceNumber) {
        ArrayList<Shard> shards = new ArrayList<Shard>(numShards);
        SequenceNumberRange sequenceNumberRange = new SequenceNumberRange();
        sequenceNumberRange.setStartingSequenceNumber(startingSequenceNumber.toString());
        sequenceNumberRange.setEndingSequenceNumber(null);
        BigInteger perShardHashKeyRange = KinesisLocalFileProxy.MAX_HASHKEY_VALUE.divide(new BigInteger(Integer.toString(numShards)));
        BigInteger hashKeyRangeStart = new BigInteger("0");
        for (int i = 0; i < numShards; ++i) {
            Shard shard = new Shard();
            shard.setShardId(shardIdPrefix + i);
            shard.setSequenceNumberRange(sequenceNumberRange);
            BigInteger hashKeyRangeEnd = hashKeyRangeStart.add(perShardHashKeyRange);
            HashKeyRange hashKeyRange = new HashKeyRange();
            hashKeyRange.setStartingHashKey(hashKeyRangeStart.toString());
            hashKeyRange.setEndingHashKey(hashKeyRangeEnd.toString());
            shards.add(shard);
        }
        return shards;
    }

    private static String generateRandomString(int length) {
        StringBuffer str = new StringBuffer();
        int startingCharAsciiValue = 97;
        int numChars = 26;
        for (int i = 0; i < length; ++i) {
            str.append((char)(randomGenerator.nextInt(25) + 97));
        }
        return str.toString();
    }

    public static void main(String[] args) {
        int numShards = 1;
        String shardIdPrefix = "shardId";
        int numRecordsPerShard = 17;
        BigInteger startingSequenceNumber = new BigInteger("99");
        String fileNamePrefix = "kinesisFakeRecords";
        try {
            if (args.length != 0 && args.length != 5) {
                System.out.println("Unexpected number of arguments.");
                System.exit(0);
            }
            if (args.length == 5) {
                numShards = Integer.parseInt(args[0]);
                shardIdPrefix = args[1];
                numRecordsPerShard = Integer.parseInt(args[2]);
                startingSequenceNumber = new BigInteger(args[3]);
                fileNamePrefix = args[4];
            }
            File file = KinesisLocalFileDataCreator.generateTempDataFile(numShards, shardIdPrefix, numRecordsPerShard, startingSequenceNumber, fileNamePrefix);
            System.out.println("Created fake kinesis records in file: " + file.getAbsolutePath());
        }
        catch (Exception e) {
            System.out.println("Caught Exception: " + e);
        }
    }
}

