/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.proxies;

import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxyFactory;
import com.amazonaws.services.kinesis.clientlibrary.proxies.KinesisLocalFileProxy;
import com.amazonaws.services.kinesis.clientlibrary.proxies.util.KinesisLocalFileDataCreator;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;

public class KinesisLocalFileProxyFactory
implements IKinesisProxyFactory {
    private static final int DEFAULT_NUM_SHARDS = 3;
    private static final String DEFAULT_SHARD_ID_PREFIX = "ShardId-";
    private static final int DEFAULT_NUM_RECORDS_PER_SHARD = 10;
    private static final BigInteger DEFAULT_STARTING_SEQUENCE_NUMBER = BigInteger.ZERO;
    private static final String DEFAULT_TEST_PROXY_FILE = "defaultKinesisProxyLocalFile";
    private IKinesisProxy testKinesisProxy;

    public KinesisLocalFileProxyFactory(String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.exists()) {
            f = KinesisLocalFileDataCreator.generateTempDataFile(3, DEFAULT_SHARD_ID_PREFIX, 10, DEFAULT_STARTING_SEQUENCE_NUMBER, DEFAULT_TEST_PROXY_FILE);
        }
        this.testKinesisProxy = new KinesisLocalFileProxy(f.getAbsolutePath());
    }

    @Override
    public IKinesisProxy getProxy(String streamARN) {
        return this.testKinesisProxy;
    }
}

