/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.proxies;

import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.InvalidArgumentException;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.SequenceNumberRange;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KinesisLocalFileProxy
implements IKinesisProxy {
    private static final Log LOG = LogFactory.getLog(KinesisLocalFileProxy.class);
    private static final String ITERATOR_DELIMITER = ":";
    private static final int NUM_FIELDS_IN_FILE = LocalFileFields.values().length;
    private final Map<String, List<Record>> shardedDataRecords = new HashMap<String, List<Record>>();
    private List<Shard> shardList;
    private Set<String> closedShards = new HashSet<String>();
    private static final int EXPONENT = 128;
    public static final BigInteger MAX_HASHKEY_VALUE = new BigInteger("2").pow(128).subtract(BigInteger.ONE);
    public static final BigInteger MAX_SEQUENCE_NUMBER = new BigInteger("2").pow(128).subtract(BigInteger.ONE);

    public KinesisLocalFileProxy(String fileName) throws IOException {
        this.populateDataRecordsFromFile(fileName);
    }

    private void populateDataRecordsFromFile(String file) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        Charset charset = Charset.forName("UTF-8");
        CharsetEncoder encoder = charset.newEncoder();
        String str = in.readLine();
        if (str != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            SerializedShardList shards = (SerializedShardList)objectMapper.readValue(str, SerializedShardList.class);
            this.shardList = shards.getShardList();
        }
        if (this.shardList == null) {
            this.shardList = new ArrayList<Shard>();
        }
        for (Shard shard : this.shardList) {
            BigInteger endingSequenceNumber;
            SequenceNumberRange range = shard.getSequenceNumberRange();
            if (range != null && range.getEndingSequenceNumber() != null && (endingSequenceNumber = new BigInteger(range.getEndingSequenceNumber())).compareTo(MAX_SEQUENCE_NUMBER) != 0) {
                this.closedShards.add(shard.getShardId());
            }
            this.shardedDataRecords.put(shard.getShardId(), new ArrayList());
        }
        while ((str = in.readLine()) != null) {
            String[] strArr = str.split(",");
            if (strArr.length != NUM_FIELDS_IN_FILE) {
                throw new InvalidArgumentException("Unexpected input in file.Expected format (shardId, sequenceNumber, partitionKey, dataRecord)");
            }
            String shardId = strArr[LocalFileFields.SHARD_ID.getPosition()];
            Record record = new Record();
            record.setSequenceNumber(strArr[LocalFileFields.SEQUENCE_NUMBER.getPosition()]);
            record.setPartitionKey(strArr[LocalFileFields.PARTITION_KEY.getPosition()]);
            ByteBuffer byteBuffer = encoder.encode(CharBuffer.wrap(strArr[LocalFileFields.DATA.getPosition()]));
            record.setData(byteBuffer);
            List<Record> shardRecords = this.shardedDataRecords.get(shardId);
            if (shardRecords == null) {
                shardRecords = new ArrayList<Record>();
            }
            shardRecords.add(record);
            this.shardedDataRecords.put(shardId, shardRecords);
        }
        in.close();
    }

    @Override
    public DescribeStreamResult getStreamInfo(String startShardId) throws ResourceNotFoundException {
        return null;
    }

    @Override
    public Set<String> getAllShardIds() throws ResourceNotFoundException {
        HashSet<String> shardIds = new HashSet<String>();
        if (this.shardedDataRecords != null) {
            shardIds.addAll(this.shardedDataRecords.keySet());
        }
        return shardIds;
    }

    static String serializeIterator(String shardId, String sequenceNumber) {
        return String.format("%s%s%s", shardId, ITERATOR_DELIMITER, sequenceNumber);
    }

    static IteratorInfo deserializeIterator(String iterator) {
        String[] splits = iterator.split(ITERATOR_DELIMITER);
        return new IteratorInfo(splits[0], splits[1]);
    }

    @Override
    public String getIterator(String shardId, String iteratorEnum, String sequenceNumber) throws ResourceNotFoundException, InvalidArgumentException {
        List<Record> shardRecords = this.shardedDataRecords.get(shardId);
        if (shardRecords == null) {
            throw new ResourceNotFoundException(shardId + " does not exist");
        }
        if (shardRecords.isEmpty()) {
            return KinesisLocalFileProxy.serializeIterator(shardId, "1");
        }
        if (ShardIteratorType.LATEST.toString().equals(iteratorEnum)) {
            Record last = shardRecords.get(shardRecords.size() - 1);
            return KinesisLocalFileProxy.serializeIterator(shardId, last.getSequenceNumber());
        }
        if (ShardIteratorType.TRIM_HORIZON.toString().equals(iteratorEnum)) {
            return KinesisLocalFileProxy.serializeIterator(shardId, shardRecords.get(0).getSequenceNumber());
        }
        if (ShardIteratorType.AT_SEQUENCE_NUMBER.toString().equals(iteratorEnum)) {
            return KinesisLocalFileProxy.serializeIterator(shardId, sequenceNumber);
        }
        if (ShardIteratorType.AFTER_SEQUENCE_NUMBER.toString().equals(iteratorEnum)) {
            BigInteger num = new BigInteger(sequenceNumber);
            num = num.add(BigInteger.ONE);
            return KinesisLocalFileProxy.serializeIterator(shardId, num.toString());
        }
        throw new IllegalArgumentException("IteratorEnum value was invalid: " + iteratorEnum);
    }

    @Override
    public GetRecordsResult get(String serializedKinesisIterator, int maxRecords) throws ResourceNotFoundException, InvalidArgumentException, ExpiredIteratorException {
        IteratorInfo iterator = KinesisLocalFileProxy.deserializeIterator(serializedKinesisIterator);
        BigInteger startingPosition = new BigInteger(iterator.sequenceNumber);
        BigInteger lastRecordsSeqNo = BigInteger.ONE;
        ArrayList<Record> recordsToReturn = new ArrayList<Record>();
        List<Record> shardRecords = this.shardedDataRecords.get(iterator.shardId);
        if (shardRecords == null) {
            throw new ResourceNotFoundException(iterator.shardId + " does not exist");
        }
        boolean isHasMoreShards = false;
        if (shardRecords != null) {
            for (int i = 0; i < shardRecords.size(); ++i) {
                BigInteger recordSequenceNumber;
                Record record = shardRecords.get(i);
                lastRecordsSeqNo = recordSequenceNumber = new BigInteger(record.getSequenceNumber());
                if (recordSequenceNumber.compareTo(startingPosition) < 0) continue;
                int endIndex = Math.min(i + maxRecords, shardRecords.size());
                recordsToReturn.addAll(shardRecords.subList(i, endIndex));
                lastRecordsSeqNo = new BigInteger(shardRecords.get(endIndex - 1).getSequenceNumber());
                if (endIndex >= shardRecords.size()) break;
                isHasMoreShards = true;
                break;
            }
        }
        GetRecordsResult response = new GetRecordsResult();
        response.setRecords(recordsToReturn);
        if (isHasMoreShards || !this.closedShards.contains(iterator.shardId)) {
            response.setNextShardIterator(KinesisLocalFileProxy.serializeIterator(iterator.shardId, lastRecordsSeqNo.add(BigInteger.ONE).toString()));
            LOG.debug((Object)("Returning a non null iterator for shard " + iterator.shardId));
        } else {
            LOG.info((Object)("Returning null iterator for shard " + iterator.shardId));
        }
        return response;
    }

    @Override
    public PutRecordResult put(String exclusiveMinimumSequenceNumber, String explicitHashKey, String partitionKey, ByteBuffer data) throws ResourceNotFoundException, InvalidArgumentException {
        PutRecordResult output = new PutRecordResult();
        BigInteger startingPosition = BigInteger.ONE;
        if (exclusiveMinimumSequenceNumber != null) {
            startingPosition = new BigInteger(exclusiveMinimumSequenceNumber).add(BigInteger.ONE);
        }
        output.setSequenceNumber(startingPosition.toString());
        return output;
    }

    @Override
    public List<Shard> getShardList() throws ResourceNotFoundException {
        LinkedList<Shard> shards = new LinkedList<Shard>();
        shards.addAll(this.shardList);
        return shards;
    }

    public static class SerializedShardList {
        private List<Shard> shardList = new LinkedList<Shard>();

        public SerializedShardList() {
        }

        public SerializedShardList(List<Shard> shardList) {
            this.shardList.addAll(shardList);
        }

        public List<Shard> getShardList() {
            return this.shardList;
        }

        public void setShardList(List<Shard> shardList) {
            this.shardList = shardList;
        }
    }

    static class IteratorInfo {
        public String shardId;
        public String sequenceNumber;

        public IteratorInfo(String shardId, String sequenceNumber) {
            this.shardId = shardId;
            this.sequenceNumber = sequenceNumber;
        }
    }

    public static enum LocalFileFields {
        SHARD_ID(0),
        SEQUENCE_NUMBER(1),
        PARTITION_KEY(2),
        DATA(3);

        private final int position;

        private LocalFileFields(int position) {
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

