/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;

class StreamConfig {
    private final IKinesisProxy streamProxy;
    private final int maxRecords;
    private final long idleTimeInMilliseconds;
    private final boolean callProcessRecordsEvenForEmptyRecordList;
    private InitialPositionInStream initialPositionInStream;

    StreamConfig(IKinesisProxy proxy, int maxRecords, long idleTimeInMilliseconds, boolean callProcessRecordsEvenForEmptyRecordList) {
        this(proxy, maxRecords, idleTimeInMilliseconds, callProcessRecordsEvenForEmptyRecordList, InitialPositionInStream.LATEST);
    }

    StreamConfig(IKinesisProxy proxy, int maxRecords, long idleTimeInMilliseconds, boolean callProcessRecordsEvenForEmptyRecordList, InitialPositionInStream initialPositionInStream) {
        this.streamProxy = proxy;
        this.maxRecords = maxRecords;
        this.idleTimeInMilliseconds = idleTimeInMilliseconds;
        this.callProcessRecordsEvenForEmptyRecordList = callProcessRecordsEvenForEmptyRecordList;
        this.initialPositionInStream = initialPositionInStream;
    }

    IKinesisProxy getStreamProxy() {
        return this.streamProxy;
    }

    int getMaxRecords() {
        return this.maxRecords;
    }

    long getIdleTimeInMilliseconds() {
        return this.idleTimeInMilliseconds;
    }

    boolean shouldCallProcessRecordsEvenForEmptyRecordList() {
        return this.callProcessRecordsEvenForEmptyRecordList;
    }

    InitialPositionInStream getInitialPositionInStream() {
        return this.initialPositionInStream;
    }
}

