/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ShutdownException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RecordProcessorCheckpointer
implements IRecordProcessorCheckpointer {
    private static final Log LOG = LogFactory.getLog(RecordProcessorCheckpointer.class);
    private ICheckpoint checkpoint;
    private String sequenceNumber;
    private String lastCheckpointValue;
    private ShardInfo shardInfo;

    RecordProcessorCheckpointer(ShardInfo shardInfo, ICheckpoint checkpoint) {
        this.shardInfo = shardInfo;
        this.checkpoint = checkpoint;
    }

    @Override
    public synchronized void checkpoint() throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        this.advancePosition();
    }

    String getLastCheckpointValue() {
        return this.lastCheckpointValue;
    }

    synchronized String getSequenceNumber() {
        return this.sequenceNumber;
    }

    synchronized void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    void advancePosition() throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        try {
            this.checkpoint.setCheckpoint(this.shardInfo.getShardId(), this.sequenceNumber, this.shardInfo.getConcurrencyToken());
            this.lastCheckpointValue = this.sequenceNumber;
        }
        catch (ThrottlingException e) {
            throw e;
        }
        catch (ShutdownException e) {
            throw e;
        }
        catch (InvalidStateException e) {
            throw e;
        }
        catch (KinesisClientLibDependencyException e) {
            throw e;
        }
        catch (KinesisClientLibException e) {
            LOG.warn((Object)"Caught exception setting checkpoint.", (Throwable)e);
            throw new KinesisClientLibDependencyException("Caught exception while checkpointing", e);
        }
    }
}

