/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.client.dynamodbv2.DocumentPath;
import com.amazon.dax.client.dynamodbv2.PathElement;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

final class ItemBuilder {
    private Map<PathElement, ItemBuilder> mChildren;
    private AttributeValue mValue;

    public static ItemBuilder create() {
        return new ItemBuilder();
    }

    private ItemBuilder() {
    }

    public ItemBuilder with(DocumentPath path, AttributeValue value) {
        AttributeValue prev = this.at(path).putIfAbsent(value);
        if (prev != null) {
            throw new IllegalArgumentException("Duplicate projection values at path: " + path);
        }
        return this;
    }

    public Map<String, AttributeValue> toItem() {
        return this.toItem(null);
    }

    public Map<String, AttributeValue> toItem(Map<String, AttributeValue> item) {
        if (item == null) {
            item = new HashMap<String, AttributeValue>();
        }
        if (this.mChildren == null) {
            return item;
        }
        for (Map.Entry<PathElement, ItemBuilder> child : this.mChildren.entrySet()) {
            item.put(child.getKey().fieldName(), child.getValue().toAttribute());
        }
        return item;
    }

    public void reset() {
        if (this.mChildren != null) {
            this.mChildren.clear();
        }
    }

    private ItemBuilder at(DocumentPath path) {
        ItemBuilder d = this;
        for (PathElement el : path) {
            d = d.child(el);
        }
        return d;
    }

    private ItemBuilder child(PathElement loc) {
        ItemBuilder c;
        if (this.mChildren == null) {
            this.mChildren = new TreeMap<PathElement, ItemBuilder>();
        }
        if ((c = this.mChildren.get(loc)) == null) {
            c = new ItemBuilder();
            this.mChildren.put(loc, c);
        }
        return c;
    }

    private AttributeValue putIfAbsent(AttributeValue val) {
        AttributeValue prev = this.mValue;
        if (prev != null) {
            return prev;
        }
        this.mValue = val;
        return prev;
    }

    private AttributeValue toAttribute() {
        if (this.mChildren == null) {
            return this.mValue;
        }
        AttributeValue cont = null;
        for (Map.Entry<PathElement, ItemBuilder> child : this.mChildren.entrySet()) {
            PathElement path = child.getKey();
            cont = path.append(cont, child.getValue().toAttribute());
        }
        return cont;
    }
}

