/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.bits.disco.ServiceEndpoint;
import com.amazon.dax.client.TubePool;
import com.amazon.dax.client.cluster.Cluster;
import com.amazon.dax.client.dynamodbv2.AmazonDaxClient;
import com.amazon.dax.client.dynamodbv2.ClientConfig;
import com.amazon.dax.client.dynamodbv2.DaxClient;
import com.amazon.dax.client.dynamodbv2.DaxClientManufacturer;
import com.amazon.dax.client.dynamodbv2.ExceptionListener;
import com.amazon.dax.client.dynamodbv2.ReadRetryHandler;
import com.amazon.dax.client.dynamodbv2.RetryHandler;
import com.amazon.dax.client.dynamodbv2.WriteRetryHandler;
import com.amazon.dax.client.exceptions.DaxServiceException;
import com.amazon.dax.client.utils.Utils;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.services.dynamodbv2.AbstractAmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeLimitsResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.TransactGetItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactGetItemsResult;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.amazonaws.services.dynamodbv2.waiters.AmazonDynamoDBWaiters;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterDaxClient
extends AbstractAmazonDynamoDB
implements AmazonDaxClient {
    private static final Log LOG = LogFactory.getLog(ClusterDaxClient.class);
    private final Cluster mCluster;
    private final int mReadRetries;
    private final int mWriteRetries;
    private final long mMaxRetryDelayNS;
    private final ClientFactory mReadClientFactory;
    private final ClientFactory mWriteClientFactory;
    private final ClusterRetryHandler mReadOperationsRetryHandler;
    private final ClusterRetryHandler mWriteOperationsRetryHandler;

    public ClusterDaxClient(ClientConfig cfg) {
        this(cfg, new Cluster(cfg, new DaxClientManufacturer(){

            @Override
            public AmazonDaxClient createDaxClient(TubePool pool, String region, AWSCredentialsProvider creds, ExceptionListener el) throws IOException {
                return new DaxClient(pool, region, creds, el);
            }
        }));
    }

    ClusterDaxClient(ClientConfig cfg, Cluster cluster) {
        this.mCluster = cluster;
        this.mReadRetries = Math.max(0, cfg.getReadRetries());
        this.mWriteRetries = Math.max(0, cfg.getWriteRetries());
        this.mMaxRetryDelayNS = Math.max(0L, cfg.getMaxRetryDelay());
        this.mReadClientFactory = new ClientFactory(){

            @Override
            public AmazonDaxClient getClient(AmazonDaxClient previous) throws IOException {
                return ClusterDaxClient.this.mCluster.readClient(previous);
            }
        };
        this.mWriteClientFactory = new ClientFactory(){

            @Override
            public AmazonDaxClient getClient(AmazonDaxClient previous) throws IOException {
                return ClusterDaxClient.this.mCluster.leaderClient(previous);
            }
        };
        try {
            this.mCluster.startup();
        }
        catch (IOException e) {
            LOG.warn((Object)("exception starting up cluster client: " + e), (Throwable)e);
        }
        this.mReadOperationsRetryHandler = new ClusterReadRetryHandler();
        this.mWriteOperationsRetryHandler = new ClusterWriteRetryHandler();
    }

    public BatchGetItemResult batchGetItem(final BatchGetItemRequest arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call(AmazonDaxClient client) {
                return client.batchGetItem(arg0);
            }
        });
    }

    public BatchGetItemResult batchGetItem(final Map<String, KeysAndAttributes> arg0, final String arg1) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call(AmazonDaxClient client) {
                return client.batchGetItem(arg0, arg1);
            }
        });
    }

    public BatchGetItemResult batchGetItem(final Map<String, KeysAndAttributes> arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call(AmazonDaxClient client) {
                return client.batchGetItem(arg0);
            }
        });
    }

    public BatchWriteItemResult batchWriteItem(final BatchWriteItemRequest arg0) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult call(AmazonDaxClient client) {
                return client.batchWriteItem(arg0);
            }
        });
    }

    public BatchWriteItemResult batchWriteItem(final Map<String, List<WriteRequest>> arg0) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult call(AmazonDaxClient client) {
                return client.batchWriteItem(arg0);
            }
        });
    }

    public CreateTableResult createTable(final CreateTableRequest arg0) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<CreateTableResult>(){

            @Override
            public CreateTableResult call(AmazonDaxClient client) {
                return client.createTable(arg0);
            }
        });
    }

    public CreateTableResult createTable(final List<AttributeDefinition> arg0, final String arg1, final List<KeySchemaElement> arg2, final ProvisionedThroughput arg3) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<CreateTableResult>(){

            @Override
            public CreateTableResult call(AmazonDaxClient client) {
                return client.createTable(arg0, arg1, arg2, arg3);
            }
        });
    }

    @Override
    public List<AttributeDefinition> defineKeySchema(final String tableName) throws AmazonClientException {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<List<AttributeDefinition>>(){

            @Override
            public List<AttributeDefinition> call(AmazonDaxClient client) {
                return client.defineKeySchema(tableName);
            }
        });
    }

    @Override
    public Long defineAttributeListId(final List<String> attributeNames, final List<String> keyNames) throws AmazonClientException {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<Long>(){

            @Override
            public Long call(AmazonDaxClient client) {
                return client.defineAttributeListId(attributeNames, keyNames);
            }
        });
    }

    @Override
    public Long defineAttributeListId(final List<String> attributeNames) throws AmazonClientException {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<Long>(){

            @Override
            public Long call(AmazonDaxClient client) {
                return client.defineAttributeListId(attributeNames);
            }
        });
    }

    @Override
    public List<String> defineAttributeList(final Long attributeListId) throws AmazonClientException {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<List<String>>(){

            @Override
            public List<String> call(AmazonDaxClient client) {
                return client.defineAttributeList(attributeListId);
            }
        });
    }

    public DeleteItemResult deleteItem(final DeleteItemRequest arg0) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<DeleteItemResult>(){

            @Override
            public DeleteItemResult call(AmazonDaxClient client) {
                return client.deleteItem(arg0);
            }
        });
    }

    public DeleteItemResult deleteItem(final String arg0, final Map<String, AttributeValue> arg1, final String arg2) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<DeleteItemResult>(){

            @Override
            public DeleteItemResult call(AmazonDaxClient client) {
                return client.deleteItem(arg0, arg1, arg2);
            }
        });
    }

    public DeleteItemResult deleteItem(final String arg0, final Map<String, AttributeValue> arg1) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<DeleteItemResult>(){

            @Override
            public DeleteItemResult call(AmazonDaxClient client) {
                return client.deleteItem(arg0, arg1);
            }
        });
    }

    public DeleteTableResult deleteTable(final DeleteTableRequest arg0) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<DeleteTableResult>(){

            @Override
            public DeleteTableResult call(AmazonDaxClient client) {
                return client.deleteTable(arg0);
            }
        });
    }

    public DeleteTableResult deleteTable(final String arg0) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<DeleteTableResult>(){

            @Override
            public DeleteTableResult call(AmazonDaxClient client) {
                return client.deleteTable(arg0);
            }
        });
    }

    public DescribeLimitsResult describeLimits(final DescribeLimitsRequest describeLimitsRequest) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<DescribeLimitsResult>(){

            @Override
            public DescribeLimitsResult call(AmazonDaxClient client) {
                return client.describeLimits(describeLimitsRequest);
            }
        });
    }

    public DescribeTableResult describeTable(final DescribeTableRequest arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<DescribeTableResult>(){

            @Override
            public DescribeTableResult call(AmazonDaxClient client) {
                return client.describeTable(arg0);
            }
        });
    }

    public DescribeTableResult describeTable(final String arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<DescribeTableResult>(){

            @Override
            public DescribeTableResult call(AmazonDaxClient client) {
                return client.describeTable(arg0);
            }
        });
    }

    @Override
    public List<ServiceEndpoint> endpoints() throws AmazonClientException {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<List<ServiceEndpoint>>(){

            @Override
            public List<ServiceEndpoint> call(AmazonDaxClient client) {
                return client.endpoints();
            }
        });
    }

    @Override
    public List<Integer> services() throws AmazonClientException {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<List<Integer>>(){

            @Override
            public List<Integer> call(AmazonDaxClient client) {
                return client.services();
            }
        });
    }

    @Override
    public List<Integer> methods(final int serviceId) throws AmazonClientException {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<List<Integer>>(){

            @Override
            public List<Integer> call(AmazonDaxClient client) {
                return client.methods(serviceId);
            }
        });
    }

    public ResponseMetadata getCachedResponseMetadata(final AmazonWebServiceRequest arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<ResponseMetadata>(){

            @Override
            public ResponseMetadata call(AmazonDaxClient client) {
                return client.getCachedResponseMetadata(arg0);
            }
        });
    }

    public GetItemResult getItem(final GetItemRequest arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<GetItemResult>(){

            @Override
            public GetItemResult call(AmazonDaxClient client) {
                return client.getItem(arg0);
            }
        });
    }

    public GetItemResult getItem(final String arg0, final Map<String, AttributeValue> arg1, final Boolean arg2) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<GetItemResult>(){

            @Override
            public GetItemResult call(AmazonDaxClient client) {
                return client.getItem(arg0, arg1, arg2);
            }
        });
    }

    public GetItemResult getItem(final String arg0, final Map<String, AttributeValue> arg1) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<GetItemResult>(){

            @Override
            public GetItemResult call(AmazonDaxClient client) {
                return client.getItem(arg0, arg1);
            }
        });
    }

    public ListTablesResult listTables() {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<ListTablesResult>(){

            @Override
            public ListTablesResult call(AmazonDaxClient client) {
                return client.listTables();
            }
        });
    }

    public ListTablesResult listTables(final Integer arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<ListTablesResult>(){

            @Override
            public ListTablesResult call(AmazonDaxClient client) {
                return client.listTables(arg0);
            }
        });
    }

    public ListTablesResult listTables(final ListTablesRequest arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<ListTablesResult>(){

            @Override
            public ListTablesResult call(AmazonDaxClient client) {
                return client.listTables(arg0);
            }
        });
    }

    public ListTablesResult listTables(final String arg0, final Integer arg1) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<ListTablesResult>(){

            @Override
            public ListTablesResult call(AmazonDaxClient client) {
                return client.listTables(arg0, arg1);
            }
        });
    }

    public ListTablesResult listTables(final String arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<ListTablesResult>(){

            @Override
            public ListTablesResult call(AmazonDaxClient client) {
                return client.listTables(arg0);
            }
        });
    }

    public PutItemResult putItem(final PutItemRequest arg0) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<PutItemResult>(){

            @Override
            public PutItemResult call(AmazonDaxClient client) {
                return client.putItem(arg0);
            }
        });
    }

    public PutItemResult putItem(final String arg0, final Map<String, AttributeValue> arg1, final String arg2) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<PutItemResult>(){

            @Override
            public PutItemResult call(AmazonDaxClient client) {
                return client.putItem(arg0, arg1, arg2);
            }
        });
    }

    public PutItemResult putItem(final String arg0, final Map<String, AttributeValue> arg1) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<PutItemResult>(){

            @Override
            public PutItemResult call(AmazonDaxClient client) {
                return client.putItem(arg0, arg1);
            }
        });
    }

    public QueryResult query(final QueryRequest arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<QueryResult>(){

            @Override
            public QueryResult call(AmazonDaxClient client) {
                return client.query(arg0);
            }
        });
    }

    public ScanResult scan(final ScanRequest arg0) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<ScanResult>(){

            @Override
            public ScanResult call(AmazonDaxClient client) {
                return client.scan(arg0);
            }
        });
    }

    public ScanResult scan(final String arg0, final List<String> arg1, final Map<String, Condition> arg2) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<ScanResult>(){

            @Override
            public ScanResult call(AmazonDaxClient client) {
                return client.scan(arg0, arg1, arg2);
            }
        });
    }

    public ScanResult scan(final String arg0, final List<String> arg1) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<ScanResult>(){

            @Override
            public ScanResult call(AmazonDaxClient client) {
                return client.scan(arg0, arg1);
            }
        });
    }

    public ScanResult scan(final String arg0, final Map<String, Condition> arg1) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<ScanResult>(){

            @Override
            public ScanResult call(AmazonDaxClient client) {
                return client.scan(arg0, arg1);
            }
        });
    }

    public TransactGetItemsResult transactGetItems(final TransactGetItemsRequest request) {
        return this.makeReadRequestWithRetries(new BoundDaxOperation<TransactGetItemsResult>(){

            @Override
            public TransactGetItemsResult call(AmazonDaxClient client) {
                return client.transactGetItems(request);
            }
        });
    }

    public TransactWriteItemsResult transactWriteItems(final TransactWriteItemsRequest request) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<TransactWriteItemsResult>(){

            @Override
            public TransactWriteItemsResult call(AmazonDaxClient client) {
                return client.transactWriteItems(request);
            }
        });
    }

    public UpdateItemResult updateItem(final String arg0, final Map<String, AttributeValue> arg1, final Map<String, AttributeValueUpdate> arg2, final String arg3) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<UpdateItemResult>(){

            @Override
            public UpdateItemResult call(AmazonDaxClient client) {
                return client.updateItem(arg0, arg1, arg2, arg3);
            }
        });
    }

    public UpdateItemResult updateItem(final String arg0, final Map<String, AttributeValue> arg1, final Map<String, AttributeValueUpdate> arg2) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<UpdateItemResult>(){

            @Override
            public UpdateItemResult call(AmazonDaxClient client) {
                return client.updateItem(arg0, arg1, arg2);
            }
        });
    }

    public UpdateItemResult updateItem(final UpdateItemRequest arg0) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<UpdateItemResult>(){

            @Override
            public UpdateItemResult call(AmazonDaxClient client) {
                return client.updateItem(arg0);
            }
        });
    }

    public UpdateTableResult updateTable(final String arg0, final ProvisionedThroughput arg1) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<UpdateTableResult>(){

            @Override
            public UpdateTableResult call(AmazonDaxClient client) {
                return client.updateTable(arg0, arg1);
            }
        });
    }

    public UpdateTableResult updateTable(final UpdateTableRequest arg0) {
        return this.makeWriteRequestWithRetries(new BoundDaxOperation<UpdateTableResult>(){

            @Override
            public UpdateTableResult call(AmazonDaxClient client) {
                return client.updateTable(arg0);
            }
        });
    }

    public void setEndpoint(String arg0) {
        throw new UnsupportedOperationException();
    }

    public void setRegion(Region region) {
        try {
            this.mCluster.setRegion(region);
        }
        catch (IOException e) {
            throw new AmazonClientException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void setRegion(String region) {
        try {
            this.mCluster.setRegion(region);
        }
        catch (IOException e) {
            throw new AmazonClientException(e.getMessage(), (Throwable)e);
        }
    }

    public AmazonDynamoDBWaiters waiters() {
        throw new UnsupportedOperationException();
    }

    public void shutdown() {
        this.mCluster.close();
    }

    <R> R makeReadRequestWithRetries(BoundDaxOperation<R> operation) {
        return this.invoke(operation, this.mReadOperationsRetryHandler, this.mReadClientFactory, this.mReadRetries);
    }

    <R> R makeWriteRequestWithRetries(BoundDaxOperation<R> operation) {
        return this.invoke(operation, this.mWriteOperationsRetryHandler, this.mWriteClientFactory, this.mWriteRetries);
    }

    private <R> R invoke(BoundDaxOperation<R> operation, ClusterRetryHandler retryHandler, ClientFactory clientFactory, int retries) {
        AmazonDaxClient client = null;
        RuntimeException exception = null;
        long leaderSessionId = 0L;
        boolean waitForRecoveryBeforeRetrying = false;
        while (true) {
            Exception lastException;
            block6: {
                lastException = null;
                try {
                    waitForRecoveryBeforeRetrying = false;
                    client = clientFactory.getClient(client);
                    leaderSessionId = this.mCluster.getLeaderSessionId();
                    if (client != null) {
                        return operation.call(client);
                    }
                    waitForRecoveryBeforeRetrying = true;
                }
                catch (Exception e) {
                    lastException = e;
                    if (!retryHandler.isRetryable(e)) {
                        throw retryHandler.check(e, exception);
                    }
                    if (!retryHandler.waitForClusterRecoveryBeforeRetrying(e)) break block6;
                    waitForRecoveryBeforeRetrying = true;
                }
            }
            exception = retryHandler.check(lastException, exception);
            if (--retries < 0) break;
            if (waitForRecoveryBeforeRetrying) {
                this.mCluster.waitForRecovery(leaderSessionId, this.mMaxRetryDelayNS, TimeUnit.NANOSECONDS);
            }
            if (lastException != null && lastException instanceof ProvisionedThroughputExceededException) continue;
            LOG.info((Object)("Retrying request after exception: " + (lastException != null ? lastException.getMessage() : "no routes")));
        }
        throw retryHandler.check(exception, null);
    }

    private class ClusterWriteRetryHandler
    extends ClusterReadRetryHandler {
        private RetryHandler handler;

        public ClusterWriteRetryHandler() {
            this.handler = new WriteRetryHandler();
        }

        @Override
        public boolean waitForClusterRecoveryBeforeRetrying(Exception e) {
            if (super.waitForClusterRecoveryBeforeRetrying(e)) {
                return true;
            }
            return e instanceof AmazonClientException && e.getCause() != null && e.getCause() instanceof ConnectException;
        }

        @Override
        public boolean isRetryable(Exception e) {
            return this.handler.isRetryable(e);
        }

        @Override
        public RuntimeException check(Exception lastException, Exception prev) {
            if (lastException instanceof RuntimeException && !(lastException instanceof AmazonClientException)) {
                return (RuntimeException)lastException;
            }
            if (Utils.isWriteFailureAmbiguous(lastException)) {
                AmazonClientException ace = new AmazonClientException("Write operation failed without negative acknowledgement", (Throwable)lastException);
                if (prev != null) {
                    ace.addSuppressed((Throwable)prev);
                }
                return ace;
            }
            return super.check(lastException, prev);
        }
    }

    private class ClusterReadRetryHandler
    implements ClusterRetryHandler {
        private RetryHandler handler = new ReadRetryHandler();

        @Override
        public boolean isRetryable(Exception e) {
            return this.handler.isRetryable(e);
        }

        @Override
        public boolean waitForClusterRecoveryBeforeRetrying(Exception e) {
            if (e instanceof DaxServiceException || e instanceof AmazonClientException && e.getCause() != null && e.getCause() instanceof DaxServiceException) {
                DaxServiceException dse = e instanceof DaxServiceException ? (DaxServiceException)((Object)e) : (DaxServiceException)((Object)e.getCause());
                return dse.waitForClusterRecoveryBeforeRetry();
            }
            return false;
        }

        @Override
        public RuntimeException check(Exception lastException, Exception prev) {
            AmazonClientException ace = lastException != null ? (lastException instanceof AmazonClientException ? (AmazonClientException)((Object)lastException) : new AmazonClientException("Unable to call cluster endpoint: " + lastException.getMessage(), (Throwable)lastException)) : new AmazonClientException("No cluster endpoints available");
            if (prev != null && prev != ace) {
                ace.addSuppressed((Throwable)prev);
            }
            return ace;
        }
    }

    private static interface ClusterRetryHandler
    extends RetryHandler {
        public boolean waitForClusterRecoveryBeforeRetrying(Exception var1);

        public RuntimeException check(Exception var1, Exception var2);
    }

    static interface ClientFactory {
        public AmazonDaxClient getClient(AmazonDaxClient var1) throws IOException;
    }

    static interface BoundDaxOperation<R> {
        public R call(AmazonDaxClient var1);
    }
}

