/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.cbor.CborInputStream;
import com.amazon.cbor.Decoder;
import com.amazon.cbor.IntRef;
import com.amazon.cbor.NonInputStream;
import com.amazon.dax.bits.DaxCborInputStream;
import com.amazon.dax.bits.DaxDecoder;
import com.amazon.dax.bits.LexDecimal;
import com.amazon.dax.client.dynamodbv2.DaxResponseDecoder;
import com.amazon.dax.client.dynamodbv2.DocumentPath;
import com.amazon.dax.client.dynamodbv2.ItemBuilder;
import com.amazon.dax.client.dynamodbv2.SimpleCache;
import com.amazon.dax.client.exceptions.DecoderException;
import com.amazon.dax.client.exceptions.MalformedResultException;
import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AttributeValueDecoder {
    public static void decodeItems(CborInputStream input, List<AttributeDefinition> keys, SimpleCache<Long, List<String>> attrListIdCache, Map<Integer, DocumentPath> projOrdinals, List<Map<String, AttributeValue>> resultSet) throws IOException {
        int i;
        ArrayList<AttributeValue> anonItem;
        ArrayList<Long> attributeListIds;
        ArrayList<ArrayList<AttributeValue>> anonAttributeValues;
        int type = input.fieldType();
        if (type == 246) {
            input.consumeField();
            return;
        }
        if (projOrdinals != null && !projOrdinals.isEmpty()) {
            if (type == 159) {
                input.consumeField();
                while (input.fieldType() != 255) {
                    resultSet.add(AttributeValueDecoder.decodeProjection(input, projOrdinals, null));
                }
                input.consumeField();
            } else {
                int len = input.readArrayLength();
                for (int i2 = 0; i2 < len; ++i2) {
                    resultSet.add(AttributeValueDecoder.decodeProjection(input, projOrdinals, null));
                }
            }
            return;
        }
        CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
        if (type == 159) {
            input.consumeField();
            anonAttributeValues = new ArrayList<ArrayList<AttributeValue>>();
            attributeListIds = new ArrayList();
            while (input.fieldType() != 255) {
                anonItem = new ArrayList<AttributeValue>();
                anonAttributeValues.add(anonItem);
                resultSet.add(AttributeValueDecoder.decodeScanItem(input, wrapper, keys, attributeListIds, anonItem));
            }
            input.consumeField();
        } else {
            int len = input.readArrayLength();
            attributeListIds = new ArrayList<Long>(len);
            anonAttributeValues = new ArrayList(len);
            for (i = 0; i < len; ++i) {
                anonItem = new ArrayList();
                anonAttributeValues.add(anonItem);
                resultSet.add(AttributeValueDecoder.decodeScanItem(input, wrapper, keys, attributeListIds, anonItem));
            }
        }
        for (i = 0; i < attributeListIds.size(); ++i) {
            List<String> attrNames;
            try {
                attrNames = attrListIdCache.get((Long)attributeListIds.get(i));
            }
            catch (AmazonClientException e) {
                throw new DecoderException(e);
            }
            AttributeValueDecoder.deanonymizeAttributeValues(resultSet.get(i), attrNames, (List)anonAttributeValues.get(i));
        }
    }

    public static void decodeAnonymousItems(CborInputStream input, List<AttributeDefinition> keys, Map<Integer, DocumentPath> projOrdinals, List<Map<String, AttributeValue>> resultSet, List<List<AttributeValue>> anonAttributeValues, List<Long> attributeListIds) throws IOException {
        int type = input.fieldType();
        if (type == 246) {
            input.consumeField();
            return;
        }
        if (projOrdinals != null && !projOrdinals.isEmpty()) {
            if (type == 159) {
                input.consumeField();
                while (input.fieldType() != 255) {
                    resultSet.add(AttributeValueDecoder.decodeProjection(input, projOrdinals, null));
                }
                input.consumeField();
            } else {
                int len = input.readArrayLength();
                for (int i = 0; i < len; ++i) {
                    resultSet.add(AttributeValueDecoder.decodeProjection(input, projOrdinals, null));
                }
            }
            return;
        }
        CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
        if (type == 159) {
            input.consumeField();
            while (input.fieldType() != 255) {
                ArrayList<AttributeValue> anonItem = new ArrayList<AttributeValue>();
                anonAttributeValues.add(anonItem);
                resultSet.add(AttributeValueDecoder.decodeScanItem(input, wrapper, keys, attributeListIds, anonItem));
            }
            input.consumeField();
        } else {
            int len = input.readArrayLength();
            for (int i = 0; i < len; ++i) {
                ArrayList<AttributeValue> anonItem = new ArrayList<AttributeValue>();
                anonAttributeValues.add(anonItem);
                resultSet.add(AttributeValueDecoder.decodeScanItem(input, wrapper, keys, attributeListIds, anonItem));
            }
        }
    }

    public static Map<String, AttributeValue> decodeScanItem(CborInputStream input, CborInputStream wrapper, List<AttributeDefinition> keys, List<Long> attributeListIds, List<AttributeValue> anonymousValues) throws IOException {
        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
        int len = input.readArrayLength();
        if (len != 2) {
            throw new DecoderException("Item pair length is wrong: " + len);
        }
        AttributeValueDecoder.decodeKey(input, keys, item);
        input.beginStream();
        wrapper.init(input);
        attributeListIds.add(wrapper.readLong());
        AttributeValueDecoder.decodeAnonymousStreamedItem(wrapper, anonymousValues);
        input.endStream();
        return item;
    }

    public static Map<String, AttributeValue> decodeValue(CborInputStream input, SimpleCache<Long, List<String>> attrListIdCache, Map<Integer, DocumentPath> projOrdinals) throws IOException {
        int type = input.fieldType() & 0xE0;
        switch (type) {
            case 160: {
                return AttributeValueDecoder.decodeProjection(input, projOrdinals, null);
            }
            case 64: {
                CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
                input.beginStream();
                wrapper.init(input);
                Map<String, AttributeValue> item = AttributeValueDecoder.decodeStreamItem(wrapper, attrListIdCache, null);
                input.endStream();
                return item;
            }
            case 224: {
                if (input.fieldType() != 246) break;
                input.consumeField();
                return null;
            }
        }
        throw new DecoderException("Value must be map or array, given cbor type: " + type);
    }

    public static BatchWriteItemResult decodeBatchWrite(DaxCborInputStream input, Map<String, List<AttributeDefinition>> keysPerTable, SimpleCache<Long, List<String>> attrListIdCache) throws IOException {
        int itemCollectionMetricsMapLength;
        int numTables = input.readMapLength();
        CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
        List[] attributeListIds = new List[numTables];
        List[] anonymousItems = new List[numTables];
        List[] tableItems = new List[numTables];
        String[] tableNames = new String[numTables];
        for (int idx = 0; idx < numTables; ++idx) {
            ArrayList<HashMap<String, AttributeValue>> tableItem;
            ArrayList<List<AttributeValue>> anonymousItem;
            ArrayList<Long> attrListIds;
            String tableName = (String)input.readObject();
            List<AttributeDefinition> tableKeys = keysPerTable.get(tableName);
            int numItems = input.readArrayLength() / 2;
            tableNames[idx] = tableName;
            attributeListIds[idx] = attrListIds = new ArrayList<Long>(numItems);
            anonymousItems[idx] = anonymousItem = new ArrayList<List<AttributeValue>>(numItems);
            tableItems[idx] = tableItem = new ArrayList<HashMap<String, AttributeValue>>(numItems);
            while (numItems-- > 0) {
                HashMap<String, AttributeValue> attrs = new HashMap<String, AttributeValue>();
                AttributeValueDecoder.decodeKey(input, tableKeys, attrs);
                tableItem.add(attrs);
                if (input.tryReadNull()) {
                    attrListIds.add(null);
                    anonymousItem.add(null);
                    continue;
                }
                input.beginStream();
                wrapper.init(input);
                attrListIds.add(wrapper.readLong());
                anonymousItem.add(AttributeValueDecoder.decodeAnonymousStreamedItem(wrapper));
                input.endStream();
            }
        }
        int consumedCapacityArrayLen = input.readArrayLength();
        ArrayList<ConsumedCapacity> consumedCapacities = null;
        if (consumedCapacityArrayLen > 0) {
            consumedCapacities = new ArrayList<ConsumedCapacity>(consumedCapacityArrayLen);
            while (consumedCapacityArrayLen-- > 0) {
                consumedCapacities.add(DaxResponseDecoder.decodeConsumedCapacity(input));
            }
        }
        HashMap batchWriteItemCollectionMetrics = (itemCollectionMetricsMapLength = input.readMapLength()) == 0 ? null : new HashMap();
        for (int i = 0; i < itemCollectionMetricsMapLength; ++i) {
            String tableName = (String)input.readObject();
            List<AttributeDefinition> tableKeys = keysPerTable.get(tableName);
            int numberOfMetrics = input.readArrayLength();
            ArrayList<ItemCollectionMetrics> metricsList = new ArrayList<ItemCollectionMetrics>(numberOfMetrics);
            for (int j = 0; j < numberOfMetrics; ++j) {
                metricsList.add(DaxResponseDecoder.decodeItemCollectionMetrics(input, tableKeys));
            }
            batchWriteItemCollectionMetrics.put(tableName, metricsList);
        }
        HashMap unprocessedItemsByTable = new HashMap(numTables);
        for (int idx = 0; idx < numTables; ++idx) {
            String tableName = tableNames[idx];
            List attrListIds = attributeListIds[idx];
            List anonymousItem = anonymousItems[idx];
            List tableItem = tableItems[idx];
            int numItems = attrListIds.size();
            ArrayList<WriteRequest> writeRequests = new ArrayList<WriteRequest>(numItems);
            for (int i = 0; i < numItems; ++i) {
                Long attrListId = (Long)attrListIds.get(i);
                List attrValues = (List)anonymousItem.get(i);
                Map attrs = (Map)tableItem.get(i);
                if (null == attrListId || null == attrValues) {
                    writeRequests.add(new WriteRequest().withDeleteRequest(new DeleteRequest().withKey(attrs)));
                    continue;
                }
                List<String> attrNames = null;
                try {
                    attrNames = attrListIdCache.get((Long)attrListIds.get(i));
                }
                catch (AmazonClientException e) {
                    throw new DecoderException(e);
                }
                AttributeValueDecoder.deanonymizeAttributeValues(attrs, attrNames, (List)anonymousItem.get(i));
                writeRequests.add(new WriteRequest().withPutRequest(new PutRequest().withItem(attrs)));
            }
            unprocessedItemsByTable.put(tableName, writeRequests);
        }
        BatchWriteItemResult response = new BatchWriteItemResult().withUnprocessedItems(unprocessedItemsByTable).withConsumedCapacity(consumedCapacities);
        if (batchWriteItemCollectionMetrics != null) {
            response.withItemCollectionMetrics(batchWriteItemCollectionMetrics);
        }
        return response;
    }

    public static BatchGetItemResult decodeBatchGet(DaxCborInputStream input, Map<String, List<AttributeDefinition>> keysPerTable, SimpleCache<Long, List<String>> attrListIdCache, Map<String, Map<Integer, DocumentPath>> tableProjOrdinals) throws IOException {
        List<AttributeDefinition> tableKeys;
        HashMap<String, Object> item;
        ArrayList<List<AttributeValue>> anonymousItem;
        ArrayList<Long> attrListIds;
        List<Map<String, AttributeValue>> tableItems;
        int responseMapLen = input.readMapLength();
        HashMap responses = new HashMap(responseMapLen);
        String[] tableNames = new String[responseMapLen];
        List[] attributeListIds = new List[responseMapLen];
        List[] anonymousItems = new List[responseMapLen];
        CborInputStream wrapper = new CborInputStream(NonInputStream.THE, 1024);
        int anonIndex = 0;
        for (int i = 0; i < responseMapLen; ++i) {
            int numItems;
            String tableName = (String)input.readObject();
            Map<Integer, DocumentPath> projOrdinals = tableProjOrdinals.get(tableName);
            tableItems = new ArrayList();
            responses.put(tableName, tableItems);
            if (projOrdinals != null) {
                tableNames[anonIndex] = tableName;
                attributeListIds[anonIndex] = attrListIds = new ArrayList<Long>(numItems);
                anonymousItems[anonIndex] = anonymousItem = new ArrayList<List<AttributeValue>>(numItems);
                block8: for (numItems = input.readArrayLength(); numItems > 0; --numItems) {
                    int type = input.fieldType() & 0xE0;
                    switch (type) {
                        case 160: {
                            tableItems.add(AttributeValueDecoder.decodeProjection(input, projOrdinals, null));
                            attrListIds.add(-1L);
                            anonymousItem.add(null);
                            continue block8;
                        }
                        case 64: {
                            item = new HashMap();
                            tableItems.add(item);
                            input.beginStream();
                            wrapper.init(input);
                            attrListIds.add(wrapper.readLong());
                            anonymousItem.add(AttributeValueDecoder.decodeAnonymousStreamedItem(wrapper));
                            input.endStream();
                            continue block8;
                        }
                        case 224: {
                            if (input.fieldType() == 246) {
                                input.consumeField();
                                continue block8;
                            }
                        }
                        default: {
                            throw new DecoderException("Value must be map or array, given cbor type: " + type);
                        }
                    }
                }
                ++anonIndex;
                continue;
            }
            tableNames[anonIndex] = tableName;
            attributeListIds[anonIndex] = attrListIds = new ArrayList(numItems);
            anonymousItems[anonIndex] = anonymousItem = new ArrayList(numItems);
            tableKeys = keysPerTable.get(tableName);
            while (numItems > 0) {
                item = new HashMap();
                tableItems.add(item);
                AttributeValueDecoder.decodeKey(input, tableKeys, item);
                input.beginStream();
                wrapper.init(input);
                attrListIds.add(wrapper.readLong());
                anonymousItem.add(AttributeValueDecoder.decodeAnonymousStreamedItem(wrapper));
                input.endStream();
                numItems -= 2;
            }
            ++anonIndex;
        }
        int unprocessedKeysMapLen = input.readMapLength();
        HashMap<String, KeysAndAttributes> unprocessedKeys = null;
        if (unprocessedKeysMapLen > 0) {
            unprocessedKeys = new HashMap<String, KeysAndAttributes>(unprocessedKeysMapLen);
            while (unprocessedKeysMapLen-- > 0) {
                String tableName = (String)input.readObject();
                int keyCount = input.readArrayLength();
                if (keyCount == 0) continue;
                tableKeys = keysPerTable.get(tableName);
                tableItems = new ArrayList(keyCount);
                while (keyCount-- > 0) {
                    item = new HashMap<String, AttributeValue>();
                    AttributeValueDecoder.decodeKey(input, tableKeys, item);
                    tableItems.add(item);
                }
                unprocessedKeys.put(tableName, new KeysAndAttributes().withKeys(tableItems));
            }
        }
        int consumedCapacityArrayLen = input.readArrayLength();
        ArrayList<ConsumedCapacity> consumedCapacities = null;
        if (consumedCapacityArrayLen > 0) {
            consumedCapacities = new ArrayList<ConsumedCapacity>(consumedCapacityArrayLen);
            while (consumedCapacityArrayLen-- > 0) {
                consumedCapacities.add(DaxResponseDecoder.decodeConsumedCapacity(input));
            }
        }
        for (int t = 0; t < anonIndex; ++t) {
            tableItems = (List)responses.get(tableNames[t]);
            attrListIds = attributeListIds[t];
            anonymousItem = anonymousItems[t];
            for (int i = 0; i < tableItems.size(); ++i) {
                List<String> attrNames;
                List anonValues = (List)anonymousItem.get(i);
                long attrListId = (Long)attrListIds.get(i);
                if (anonValues == null) continue;
                try {
                    attrNames = attrListIdCache.get(attrListId);
                }
                catch (AmazonClientException e) {
                    throw new DecoderException(e);
                }
                AttributeValueDecoder.deanonymizeAttributeValues((Map)tableItems.get(i), attrNames, anonValues);
            }
        }
        return new BatchGetItemResult().withResponses(responses).withUnprocessedKeys(unprocessedKeys).withConsumedCapacity(consumedCapacities);
    }

    public static Map<String, AttributeValue> decodeItem(CborInputStream input, SimpleCache<Long, List<String>> attrListIdCache, Map<String, AttributeValue> item) throws IOException {
        int fieldType = input.fieldType();
        if (fieldType == 246) {
            input.consumeField();
            return item;
        }
        int len = input.readBytesLength();
        Long attrListId = input.readLong();
        List<AttributeValue> attrValues = AttributeValueDecoder.decodeAnonymousItem(input);
        List<String> attrNames = null;
        try {
            attrNames = attrListIdCache.get(attrListId);
        }
        catch (AmazonClientException e) {
            throw new DecoderException(e);
        }
        return AttributeValueDecoder.deanonymizeAttributeValues(item, attrNames, attrValues);
    }

    public static Map<String, AttributeValue> deanonymizeAttributeValues(Map<String, AttributeValue> item, List<String> attributeNames, List<AttributeValue> attributeValues) throws IOException {
        if (item == null) {
            item = new HashMap<String, AttributeValue>();
        }
        if (attributeNames.size() != attributeValues.size()) {
            throw new MalformedResultException("Invalid AttributeList for item, must have same number of keys as values");
        }
        for (int i = 0; i < attributeNames.size(); ++i) {
            item.put(attributeNames.get(i), attributeValues.get(i));
        }
        return item;
    }

    public static Map<String, AttributeValue> decodeStreamItem(CborInputStream input, SimpleCache<Long, List<String>> attrListIdCache, Map<String, AttributeValue> item) throws IOException {
        int fieldType = input.fieldType();
        if (fieldType == 246) {
            input.consumeField();
            return item;
        }
        Long attrListId = input.readLong();
        List<AttributeValue> attrValues = AttributeValueDecoder.decodeAnonymousStreamedItem(input);
        List<String> attrNames = null;
        try {
            attrNames = attrListIdCache.get(attrListId);
        }
        catch (AmazonClientException e) {
            throw new DecoderException(e);
        }
        return AttributeValueDecoder.deanonymizeAttributeValues(item, attrNames, attrValues);
    }

    private static List<AttributeValue> decodeAnonymousItem(CborInputStream input) throws IOException {
        ArrayList<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
        while (input.hasMore() || input.available() > 0) {
            AttributeValue av = new AttributeValue();
            AttributeValueDecoder.unpackAttributeValue(input, av);
            attributeValues.add(av);
        }
        return attributeValues;
    }

    private static List<AttributeValue> decodeAnonymousStreamedItem(CborInputStream input, List<AttributeValue> anonymousValues) throws IOException {
        if (anonymousValues == null) {
            anonymousValues = new ArrayList<AttributeValue>();
        }
        while (input.fieldType() != -1) {
            AttributeValue av = new AttributeValue();
            AttributeValueDecoder.unpackAttributeValue(input, av);
            anonymousValues.add(av);
        }
        return anonymousValues;
    }

    private static List<AttributeValue> decodeAnonymousStreamedItem(CborInputStream input) throws IOException {
        return AttributeValueDecoder.decodeAnonymousStreamedItem(input, null);
    }

    public static Map<String, AttributeValue> decodeProjection(CborInputStream input, Map<Integer, DocumentPath> projOrdinals) throws IOException {
        return AttributeValueDecoder.decodeProjection(input, projOrdinals, null);
    }

    public static Map<String, AttributeValue> decodeProjection(CborInputStream input, Map<Integer, DocumentPath> projOrdinals, Map<String, AttributeValue> item) throws IOException {
        if (projOrdinals == null) {
            throw new DecoderException("Projection Ordinals must not be null on projected value");
        }
        ItemBuilder builder = ItemBuilder.create();
        if (input.fieldType() == 191) {
            input.consumeField();
            while (input.fieldType() != 255) {
                AttributeValueDecoder.decodeProjectionElement(input, projOrdinals, builder);
            }
            input.consumeField();
        } else {
            int len = input.readMapLength();
            for (int i = 0; i < len; ++i) {
                AttributeValueDecoder.decodeProjectionElement(input, projOrdinals, builder);
            }
        }
        return builder.toItem(item);
    }

    private static ItemBuilder decodeProjectionElement(CborInputStream input, Map<Integer, DocumentPath> projOrdinals, ItemBuilder builder) throws IOException {
        int ord = input.readInt();
        DocumentPath path = projOrdinals.get(ord);
        if (path == null) {
            throw new DecoderException("Unknown projection ordinal: " + ord);
        }
        AttributeValue av = new AttributeValue();
        AttributeValueDecoder.unpackAttributeValue(input, av);
        return builder.with(path, av);
    }

    public static void decodeCompoundKey(CborInputStream input, Map<String, AttributeValue> attrs) throws IOException {
        if (input.fieldType() == 246) {
            input.consumeField();
            return;
        }
        input.beginStream();
        CborInputStream wrapper = new CborInputStream(input, 1024);
        if (wrapper.fieldType() != 191) {
            throw new DecoderException("Unknown compound key");
        }
        wrapper.consumeField();
        while (wrapper.fieldType() != 255) {
            byte[] name = wrapper.readStringAsBytes();
            AttributeValue av = new AttributeValue();
            AttributeValueDecoder.unpackAttributeValue(wrapper, av);
            attrs.put(Decoder.decodeUtf8(name), av);
        }
        wrapper.consumeField();
        input.endStream();
    }

    public static void decodeNamedItem(CborInputStream input, List<AttributeDefinition> keys, Map<String, AttributeValue> item) throws IOException {
        AttributeDefinition hashKeyAttributeDefinition = keys.get(0);
        AttributeValue value = new AttributeValue();
        AttributeValueDecoder.unpackAttributeValue(input, value);
        item.put(hashKeyAttributeDefinition.getAttributeName(), value);
    }

    public static void decodeKey(CborInputStream input, List<AttributeDefinition> keys, Map<String, AttributeValue> item) throws IOException {
        byte[] key = (byte[])input.readObject();
        if (key == null) {
            return;
        }
        IntRef ref = new IntRef();
        AttributeDefinition ad = keys.get(0);
        if (keys.size() == 1) {
            switch (ad.getAttributeType()) {
                case "S": {
                    item.put(ad.getAttributeName(), new AttributeValue().withS(Decoder.decodeUtf8(key, 0, key.length)));
                    break;
                }
                case "N": {
                    item.put(ad.getAttributeName(), new AttributeValue().withN(DaxDecoder.decodeAnyCborNumber(key, ref).toString()));
                    break;
                }
                case "B": {
                    item.put(ad.getAttributeName(), new AttributeValue().withB(ByteBuffer.wrap(key)));
                    break;
                }
                default: {
                    throw new DecoderException("Key must be S, B or N, instead key is: " + ad);
                }
            }
        } else {
            switch (ad.getAttributeType()) {
                case "S": {
                    item.put(ad.getAttributeName(), new AttributeValue().withS(new String(Decoder.decodeCborStringAsBytes(key, ref))));
                    break;
                }
                case "N": {
                    item.put(ad.getAttributeName(), new AttributeValue().withN(DaxDecoder.decodeAnyCborNumber(key, ref).toString()));
                    break;
                }
                case "B": {
                    item.put(ad.getAttributeName(), new AttributeValue().withB(ByteBuffer.wrap(Decoder.decodeCborBytes(key, ref))));
                    break;
                }
                default: {
                    throw new DecoderException("Key must be S, B or N, instead key is: " + ad);
                }
            }
            ad = keys.get(1);
            switch (ad.getAttributeType()) {
                case "S": {
                    item.put(ad.getAttributeName(), new AttributeValue().withS(Decoder.decodeUtf8(key, ref.value, key.length - ref.value)));
                    break;
                }
                case "N": {
                    BigDecimal[] bdRef = new BigDecimal[1];
                    LexDecimal.decode(key, ref.value, bdRef);
                    item.put(ad.getAttributeName(), new AttributeValue().withN(bdRef[0].toString()));
                    break;
                }
                case "B": {
                    item.put(ad.getAttributeName(), new AttributeValue().withB(ByteBuffer.wrap(key, ref.value, key.length - ref.value)));
                    break;
                }
                default: {
                    throw new DecoderException("Key must be S, B or N, instead key is: " + ad);
                }
            }
        }
    }

    public static Map<String, AttributeValue> decodeItemAttributeProjection(CborInputStream input, SimpleCache<Long, List<String>> attrListIdCache, Map<String, AttributeValue> item) throws IOException {
        int fieldType = input.fieldType();
        if (item == null) {
            item = new HashMap<String, AttributeValue>();
        }
        if (fieldType == 246) {
            input.consumeField();
            return item;
        }
        int len = input.readBytesLength();
        Long attrListId = input.readLong();
        List<String> attrNames = null;
        try {
            attrNames = attrListIdCache.get(attrListId);
        }
        catch (AmazonClientException e) {
            throw new DecoderException(e);
        }
        input.fieldType();
        input.consumeField();
        while (input.fieldType() != 255) {
            int ordinal = input.readInt();
            AttributeValue av = new AttributeValue();
            AttributeValueDecoder.unpackAttributeValue(input, av);
            item.put(attrNames.get(ordinal), av);
        }
        input.consumeField();
        return item;
    }

    private static void unpackAttributeValue(CborInputStream input, AttributeValue value) throws IOException {
        int fieldType = input.fieldType() & 0xFF;
        block18: while (true) {
            switch (fieldType >> 5) {
                case 2: {
                    value.setB(ByteBuffer.wrap((byte[])input.readObject()));
                    return;
                }
                case 3: {
                    value.setS((String)input.readObject());
                    return;
                }
                case 4: {
                    int size = input.readArrayLength();
                    ArrayList<AttributeValue> avList = new ArrayList<AttributeValue>(size);
                    for (int i = 0; i < size; ++i) {
                        AttributeValue av = new AttributeValue();
                        AttributeValueDecoder.unpackAttributeValue(input, av);
                        avList.add(av);
                    }
                    value.setL(avList);
                    return;
                }
                case 5: {
                    int size = input.readMapLength();
                    LinkedHashMap<String, AttributeValue> avMap = new LinkedHashMap<String, AttributeValue>(size);
                    for (int i = 0; i < size; ++i) {
                        Object name = input.readObject();
                        AttributeValue av = new AttributeValue();
                        AttributeValueDecoder.unpackAttributeValue(input, av);
                        if (name == null) {
                            avMap.put(null, av);
                            continue;
                        }
                        avMap.put(name.toString(), av);
                    }
                    value.setM(avMap);
                    return;
                }
                case 7: {
                    switch (fieldType & 0x1F) {
                        case 21: {
                            value.setBOOL(Boolean.valueOf(true));
                            break;
                        }
                        case 20: {
                            value.setBOOL(Boolean.valueOf(false));
                            break;
                        }
                        case 22: {
                            value.setNULL(Boolean.valueOf(true));
                            break;
                        }
                        default: {
                            break block18;
                        }
                    }
                    input.consumeField();
                    return;
                }
                case 0: 
                case 1: {
                    value.setN(input.readObject().toString());
                    return;
                }
                case 6: {
                    long tag = input.getFieldValue();
                    if (tag < 3321L || tag > 3323L) break block18;
                    input.consumeField();
                    fieldType = input.fieldType() & 0xE0;
                    if (fieldType == 128) {
                        switch ((int)tag) {
                            default: {
                                AttributeValueDecoder.unpackStringSet(input, value);
                                return;
                            }
                            case 3322: {
                                AttributeValueDecoder.unpackNumberSet(input, value);
                                return;
                            }
                            case 3323: 
                        }
                        AttributeValueDecoder.unpackBinarySet(input, value);
                        return;
                    }
                }
                default: {
                    fieldType = input.fieldType();
                    continue block18;
                }
            }
            break;
        }
        AttributeValueDecoder.setObject(value, input.readObject());
    }

    private static void unpackStringSet(CborInputStream input, AttributeValue value) throws IOException {
        int size = input.readArrayLength();
        ArrayList<String> set = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            int fieldType = input.fieldType() & 0xE0;
            if (fieldType != 96) {
                ArrayList<AttributeValue> avList = new ArrayList<AttributeValue>(size);
                for (int j = 0; j < i; ++j) {
                    avList.add(new AttributeValue().withS((String)set.get(i)));
                }
                while (i < size) {
                    AttributeValue av = new AttributeValue();
                    AttributeValueDecoder.unpackAttributeValue(input, av);
                    avList.add(av);
                    ++i;
                }
                value.setL(avList);
                return;
            }
            set.add((String)input.readObject());
        }
        value.setSS(set);
    }

    private static void unpackNumberSet(CborInputStream input, AttributeValue value) throws IOException {
        int size = input.readArrayLength();
        ArrayList<String> set = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Object obj = input.readObject();
            if (!(obj instanceof Number)) {
                ArrayList<AttributeValue> avList = new ArrayList<AttributeValue>(size);
                for (int j = 0; j < i; ++j) {
                    avList.add(new AttributeValue().withN((String)set.get(i)));
                }
                AttributeValue av = new AttributeValue();
                AttributeValueDecoder.setObject(av, obj);
                avList.add(av);
                ++i;
                while (i < size) {
                    av = new AttributeValue();
                    AttributeValueDecoder.unpackAttributeValue(input, av);
                    avList.add(av);
                    ++i;
                }
                value.setL(avList);
                return;
            }
            set.add(obj.toString());
        }
        value.setNS(set);
    }

    private static void unpackBinarySet(CborInputStream input, AttributeValue value) throws IOException {
        int size = input.readArrayLength();
        ArrayList<ByteBuffer> set = new ArrayList<ByteBuffer>(size);
        for (int i = 0; i < size; ++i) {
            int fieldType = input.fieldType() & 0xE0;
            if (fieldType != 64) {
                ArrayList<AttributeValue> avList = new ArrayList<AttributeValue>(size);
                for (int j = 0; j < i; ++j) {
                    avList.add(new AttributeValue().withB((ByteBuffer)set.get(i)));
                }
                while (i < size) {
                    AttributeValue av = new AttributeValue();
                    AttributeValueDecoder.unpackAttributeValue(input, av);
                    avList.add(av);
                    ++i;
                }
                value.setL(avList);
                return;
            }
            set.add(ByteBuffer.wrap((byte[])input.readObject()));
        }
        value.setBS(set);
    }

    private static void setObject(AttributeValue value, Object obj) {
        if (obj == null) {
            value.setNULL(Boolean.valueOf(true));
        } else if (obj instanceof Number) {
            value.setN(obj.toString());
        } else if (obj instanceof String) {
            value.setS(obj.toString());
        } else if (obj instanceof byte[]) {
            value.setB(ByteBuffer.wrap((byte[])obj));
        } else {
            throw new DecoderException("Unknown object type: " + obj + ", " + obj.getClass());
        }
    }
}

