/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client.dynamodbv2;

import com.amazon.dax.client.dynamodbv2.ClientConfig;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AmazonDaxClientBuilderAbstract<Builder extends AmazonDaxClientBuilderAbstract<Builder>> {
    protected static final Log LOG = LogFactory.getLog(AmazonDaxClientBuilderAbstract.class);
    protected static final AwsRegionProvider DEFAULT_REGION_PROVIDER = new DefaultAwsRegionProviderChain();
    protected final AwsRegionProvider mRegionProvider;
    protected Region mRegion;
    protected AWSCredentialsProvider mCredentials;
    protected ClientConfig mClientConfig;
    protected String[] mHosts;

    protected AmazonDaxClientBuilderAbstract() {
        this(DEFAULT_REGION_PROVIDER);
    }

    protected AmazonDaxClientBuilderAbstract(AwsRegionProvider regionProvider) {
        this.mRegionProvider = regionProvider;
    }

    public abstract AmazonDynamoDB build();

    protected void resolveEndpoint(ClientConfig config) {
        if (this.mHosts != null) {
            config.withEndpoints(this.mHosts);
        }
    }

    protected void resolveCredentials(ClientConfig config) {
        if (this.mCredentials != null) {
            config.withCredentialsProvider(this.mCredentials);
        }
    }

    protected void resolveRegion(ClientConfig config) {
        if (this.mRegion != null) {
            config.withRegion(this.mRegion);
        } else if (config.getRegion() == null) {
            String regionName = null;
            try {
                regionName = this.mRegionProvider.getRegion();
            }
            catch (SdkClientException e) {
                LOG.error((Object)"Region not set by builder or regionProvider.");
            }
            config.withRegion(regionName);
        }
    }

    public final AWSCredentialsProvider getCredentials() {
        return this.mCredentials;
    }

    public final void setCredentials(AWSCredentialsProvider credentialsProvider) {
        this.mCredentials = credentialsProvider;
    }

    public final Builder withCredentials(AWSCredentialsProvider credentialsProvider) {
        this.setCredentials(credentialsProvider);
        return (Builder)this;
    }

    public final String getRegion() {
        return this.mRegion == null ? null : this.mRegion.getName();
    }

    public final void setRegion(String region) {
        this.withRegion(region);
    }

    public final Builder withRegion(Regions region) {
        return this.withRegion(region.getName());
    }

    public final Builder withRegion(String regionName) {
        Region region = RegionUtils.getRegion((String)regionName);
        if (region == null) {
            throw new SdkClientException("Invalid region with name " + regionName);
        }
        return this.withRegion(region);
    }

    private Builder withRegion(Region region) {
        this.mRegion = region;
        return (Builder)this;
    }

    public final ClientConfig getClientConfiguration() {
        return this.mClientConfig;
    }

    public final void setClientConfiguration(ClientConfig config) {
        this.mClientConfig = config;
    }

    public final Builder withClientConfiguration(ClientConfig config) {
        this.setClientConfiguration(config);
        return (Builder)this;
    }

    public final String[] getEndpoint() {
        return this.mHosts;
    }

    public final void setEndpointConfiguration(String ... hosts) {
        this.withEndpointConfiguration(hosts);
    }

    public final Builder withEndpointConfiguration(String ... hosts) {
        this.mHosts = hosts;
        return (Builder)this;
    }
}

