/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client;

import com.amazon.dax.bits.LazyClock;
import com.amazon.dax.client.ClientTube;
import com.amazon.dax.client.Connector;
import com.amazon.dax.client.SessionVersion;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;

public class DaxConnector
implements Closeable {
    private final Connector mConnector;
    private final int mTimeout;
    private final Semaphore mBound;
    private final String mUserAgent;
    private final int mConnectTimeoutMs;
    private final LazyClock mClock;
    private final long mTubeTtlMs;
    private final long mTubeTtlJitterMs;

    DaxConnector(Connector connector, int timeoutMs, int maxPending, LazyClock clock, long tubeTtlMs) {
        this(connector, timeoutMs, maxPending, "", clock, tubeTtlMs);
    }

    public DaxConnector(Connector connector, int timeoutMs, int maxPending, String userAgent) {
        this(connector, timeoutMs, maxPending, userAgent, -1);
    }

    public DaxConnector(Connector connector, int timeoutMs, int maxPending, String userAgent, LazyClock clock, long tubeTtlMs) {
        this(connector, timeoutMs, maxPending, userAgent, -1, clock, tubeTtlMs);
    }

    public DaxConnector(Connector connector, int timeoutMs, int maxPending, String userAgent, int connectTimeoutMs) {
        this(connector, timeoutMs, maxPending, userAgent, connectTimeoutMs, LazyClock.instance(), Long.MAX_VALUE);
    }

    public DaxConnector(Connector connector, int timeoutMs, int maxPending, String userAgent, int connectTimeoutMs, LazyClock clock, long tubeTtlMs) {
        this.mConnector = connector;
        this.mTimeout = timeoutMs;
        this.mBound = new Semaphore(maxPending);
        this.mUserAgent = userAgent;
        this.mConnectTimeoutMs = connectTimeoutMs;
        this.mClock = clock != null ? clock : LazyClock.instance();
        this.mTubeTtlMs = tubeTtlMs;
        this.mTubeTtlJitterMs = DaxConnector.calculateTubeExpiryJitterMillis(tubeTtlMs);
    }

    @Override
    public void close() {
    }

    public Future<?> connect(SocketAddress sa, SessionVersion version, Connector.Listener<ClientTube> lt) {
        return this.connect(sa, -1, version, lt);
    }

    public Future<?> connect(SocketAddress sa, int timeoutMs, final SessionVersion version, final Connector.Listener<ClientTube> lt) {
        int timeout;
        Future<?> job = null;
        int n = timeout = timeoutMs <= 0 ? this.mConnectTimeoutMs : timeoutMs;
        if (this.mBound.tryAcquire()) {
            job = this.mConnector.connect(sa, timeout, new Connector.Listener<Socket>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handle(Socket sock, Throwable e) {
                    try {
                        if (e != null) {
                            lt.handle(null, e);
                            return;
                        }
                        ClientTube tube = null;
                        try {
                            tube = DaxConnector.this.newTube(sock, version);
                        }
                        catch (Throwable t) {
                            Connector.silentClose(sock);
                            lt.handle(null, Connector.check(t));
                            DaxConnector.this.mBound.release();
                            return;
                        }
                        lt.handle(tube, null);
                    }
                    finally {
                        DaxConnector.this.mBound.release();
                    }
                }
            });
            if (job == null) {
                this.mBound.release();
            }
            return job;
        }
        return null;
    }

    private ClientTube newTube(Socket sock, SessionVersion version) throws IOException {
        sock.setTcpNoDelay(true);
        sock.setSoTimeout(this.mTimeout);
        sock.setKeepAlive(true);
        return new ClientTube(sock, version, this.mUserAgent, this.calculateTubeExpiryMillis(this.mTubeTtlMs));
    }

    private long calculateTubeExpiryMillis(long tubeTTLMs) {
        if (tubeTTLMs == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.mClock.getCurrentTime() + ThreadLocalRandom.current().nextLong(this.mTubeTtlJitterMs) + tubeTTLMs;
    }

    private static long calculateTubeExpiryJitterMillis(long tubeTtlMs) {
        return (long)Math.max(5000.0, 0.1 * (double)tubeTtlMs);
    }
}

