/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Connector
implements Closeable {
    private static final ThreadFactory FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r);
            th.setName("DaxConnector-" + th.getId());
            th.setDaemon(true);
            return th;
        }
    };
    private final ExecutorService mExecutor = Executors.newCachedThreadPool(FACTORY);
    private final int mConnectTimeout;

    public Connector(int timeoutMs) {
        this(timeoutMs, TimeUnit.SECONDS.toNanos(1L));
    }

    public Connector(int timeoutMs, long threadKeepAliveNs) {
        if (this.mExecutor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.mExecutor;
            tpe.allowCoreThreadTimeOut(true);
            tpe.setKeepAliveTime(threadKeepAliveNs, TimeUnit.NANOSECONDS);
        }
        this.mConnectTimeout = timeoutMs;
    }

    @Override
    public void close() {
        this.close(false);
    }

    public void close(boolean graceful) {
        this.mExecutor.shutdown();
        if (graceful) {
            try {
                while (!this.mExecutor.isShutdown()) {
                    this.mExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException ie) {
                this.mExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    public Future<?> connect(SocketAddress sa, Listener<Socket> lt) {
        return this.connect(sa, this.mConnectTimeout, lt);
    }

    public Future<?> connect(SocketAddress sa, int timeoutMs, Listener<Socket> lt) {
        ConnectTask ct = new ConnectTask(sa, timeoutMs, lt);
        this.mExecutor.execute(ct);
        return ct;
    }

    static void silentClose(Closeable s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static IOException check(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof IOException) {
            return (IOException)t;
        }
        IOException e = new IOException("connector i/o exception: " + t);
        e.initCause(t);
        return e;
    }

    private class ConnectTask
    extends BackgroundJob<Socket> {
        private final SocketAddress mAddr;
        private final Listener<Socket> mLt;
        private final int mTimeoutMs;

        ConnectTask(SocketAddress addr, int timeoutMs, Listener<Socket> lt) {
            this.mAddr = addr;
            this.mLt = lt;
            this.mTimeoutMs = timeoutMs <= 0 ? Connector.this.mConnectTimeout : timeoutMs;
        }

        @Override
        public Socket compute() throws Exception {
            Socket socket = new Socket();
            try {
                socket.connect(this.mAddr, this.mTimeoutMs >> 2);
            }
            catch (Throwable t) {
                Connector.silentClose(socket);
                socket = new Socket();
                try {
                    socket.connect(this.mAddr, this.mTimeoutMs);
                }
                catch (Throwable t2) {
                    Connector.silentClose(socket);
                    t2.addSuppressed(t);
                    throw Connector.check(t2);
                }
            }
            return socket;
        }

        @Override
        public void complete(Socket val, Throwable t) {
            this.mLt.handle(val, Connector.check(t));
        }
    }

    private static abstract class BackgroundJob<T>
    implements Runnable,
    Future<T> {
        private final FutureTask<T> mComputation = new Compute();

        private BackgroundJob() {
        }

        @Override
        public final boolean isCancelled() {
            return false;
        }

        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public final boolean isDone() {
            return this.mComputation.isDone();
        }

        @Override
        public final T get() throws InterruptedException, ExecutionException {
            return this.mComputation.get();
        }

        @Override
        public final T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.mComputation.get(timeout, unit);
        }

        @Override
        public final void run() {
            this.mComputation.run();
        }

        public abstract T compute() throws Exception;

        public abstract void complete(T var1, Throwable var2);

        private class Compute
        extends FutureTask<T> {
            Compute() {
                super(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return BackgroundJob.this.compute();
                    }
                });
            }

            @Override
            protected void done() {
                Object val = null;
                Throwable e = null;
                try {
                    val = this.get();
                }
                catch (ExecutionException ee) {
                    e = ee.getCause();
                }
                catch (Throwable t) {
                    e = t;
                }
                BackgroundJob.this.complete(val, e);
            }
        }
    }

    public static interface Listener<T> {
        public void handle(T var1, Throwable var2);
    }
}

