/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits;

import com.amazon.cbor.Decoder;
import com.amazon.cbor.IntRef;
import com.amazon.cbor.Utils;
import com.amazon.dax.bits.BinSet;
import com.amazon.dax.bits.NumSet;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Equality {
    private Equality() {
    }

    public static boolean cborEquals(byte[] lhs, int lhsOffset, byte[] rhs, int rhsOffset) {
        return Equality.cborEquals(lhs, new IntRef(lhsOffset), rhs, new IntRef(rhsOffset));
    }

    public static boolean cborEquals(byte[] src, IntRef srcOffsetRef, byte[] rhs, IntRef rhsOffsetRef) {
        if (src == null || rhs == null) {
            if (src != null && !Equality.isNull(src, srcOffsetRef.value)) {
                return false;
            }
            return rhs == null || Equality.isNull(rhs, rhsOffsetRef.value);
        }
        int srcOffset = srcOffsetRef.value;
        block27: while (true) {
            int prev = srcOffset;
            int type = src[srcOffset++] & 0xFF;
            long value = 0L;
            switch (type & 0x1F) {
                default: {
                    value = type & 0x1F;
                    break;
                }
                case 27: {
                    value = ((long)src[srcOffset++] & 0xFFL) << 56 | ((long)src[srcOffset++] & 0xFFL) << 48 | ((long)src[srcOffset++] & 0xFFL) << 40 | ((long)src[srcOffset++] & 0xFFL) << 32;
                }
                case 26: {
                    value |= ((long)src[srcOffset++] & 0xFFL) << 24 | ((long)src[srcOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    value |= ((long)src[srcOffset++] & 0xFFL) << 8;
                }
                case 24: {
                    value |= (long)src[srcOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: {
                    throw new IllegalStateException("illegal type: " + type);
                }
                case 31: {
                    return false;
                }
            }
            srcOffsetRef.value = srcOffset;
            switch (type >> 5) {
                case 1: {
                    value ^= 0xFFFFFFFFFFFFFFFFL;
                }
                case 0: {
                    return Equality.cborIntEquals(type & 0xE0, value, rhs, rhsOffsetRef);
                }
                case 2: 
                case 3: {
                    return Equality.cborBytesEquals(src, srcOffsetRef, type & 0xE0, value, rhs, rhsOffsetRef);
                }
                case 4: {
                    return Equality.cborArrayEquals(src, srcOffsetRef, value, rhs, rhsOffsetRef);
                }
                case 5: {
                    return Equality.cborMapEquals(src, srcOffsetRef, value, rhs, rhsOffsetRef);
                }
                case 7: {
                    double da;
                    switch (type & 0x1F) {
                        default: {
                            return Equality.cborSimpleEquals(value, rhs, rhsOffsetRef);
                        }
                        case 25: {
                            da = Decoder.float16to32((int)value);
                            break;
                        }
                        case 26: {
                            da = Float.intBitsToFloat((int)value);
                            break;
                        }
                        case 27: {
                            da = Double.longBitsToDouble(value);
                        }
                    }
                    if (Decoder.compareCborDouble(rhs, rhsOffsetRef.value, da, 1) == 0) {
                        rhsOffsetRef.value = Decoder.skipCborItem(rhs, rhsOffsetRef.value);
                        return true;
                    }
                    return false;
                }
                case 6: {
                    long tag = value;
                    int itag = (int)tag;
                    if ((long)itag != tag) continue block27;
                    switch (itag) {
                        case 2: 
                        case 3: {
                            BigInteger bi = new BigInteger(Decoder.decodeCborBytes((int)value, src, srcOffsetRef));
                            if (Decoder.compareCborBigDecimal(rhs, rhsOffsetRef.value, new BigDecimal(bi), 1) == 0) {
                                rhsOffsetRef.value = Decoder.skipCborItem(rhs, rhsOffsetRef.value);
                                return true;
                            }
                            return false;
                        }
                        case 4: 
                        case 5: {
                            BigDecimal bd = Decoder.decodeCborBigDecimal((int)value, src, srcOffsetRef);
                            if (Decoder.compareCborBigDecimal(rhs, rhsOffsetRef.value, bd, 1) == 0) {
                                rhsOffsetRef.value = Decoder.skipCborItem(rhs, rhsOffsetRef.value);
                                return true;
                            }
                            return false;
                        }
                        case 3321: 
                        case 3322: 
                        case 3323: {
                            return Equality.cborSetEquals(src, srcOffsetRef, itag, rhs, rhsOffsetRef);
                        }
                    }
                    continue block27;
                }
            }
        }
    }

    private static boolean cborSimpleEquals(long v, byte[] rhs, IntRef rhsOffsetRef) {
        long value;
        int rhsOffset = rhsOffsetRef.value;
        do {
            int type = rhs[rhsOffset++] & 0xFF;
            value = 0L;
            switch (type & 0x1F) {
                default: {
                    value = type & 0x1F;
                    break;
                }
                case 27: {
                    value = ((long)rhs[rhsOffset++] & 0xFFL) << 56 | ((long)rhs[rhsOffset++] & 0xFFL) << 48 | ((long)rhs[rhsOffset++] & 0xFFL) << 40 | ((long)rhs[rhsOffset++] & 0xFFL) << 32;
                }
                case 26: {
                    value |= ((long)rhs[rhsOffset++] & 0xFFL) << 24 | ((long)rhs[rhsOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    value |= ((long)rhs[rhsOffset++] & 0xFFL) << 8;
                }
                case 24: {
                    value |= (long)rhs[rhsOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: {
                    throw new IllegalStateException("illegal type: " + type);
                }
                case 31: {
                    return false;
                }
            }
            rhsOffsetRef.value = rhsOffset;
            switch (type >> 5) {
                default: {
                    return false;
                }
                case 7: {
                    return v == value;
                }
                case 6: 
            }
        } while (!Equality.knownTag(value));
        return false;
    }

    private static boolean cborIntEquals(int majorType, long v, byte[] rhs, IntRef rhsOffsetRef) {
        BigInteger bi = null;
        if (majorType == 0 && v < 0L) {
            bi = BigInteger.valueOf(v ^ Long.MIN_VALUE).setBit(63);
        } else if (majorType == 32 && v >= 0L) {
            bi = BigInteger.valueOf(-1L).shiftLeft(64).or(BigInteger.valueOf(v));
        }
        if (bi != null) {
            if (Decoder.compareCborBigDecimal(rhs, rhsOffsetRef.value, new BigDecimal(bi), 1) == 0) {
                rhsOffsetRef.value = Decoder.skipCborItem(rhs, rhsOffsetRef.value);
                return true;
            }
        } else if (Decoder.compareCborLong(rhs, rhsOffsetRef.value, v, v + 1L) == v) {
            rhsOffsetRef.value = Decoder.skipCborItem(rhs, rhsOffsetRef.value);
            return true;
        }
        return false;
    }

    private static boolean cborSetEquals(byte[] src, IntRef srcOffsetRef, int setType, byte[] rhs, IntRef rhsOffsetRef) {
        long value;
        long len = Decoder.decodeAnyCborLong(src, srcOffsetRef);
        int rhsOffset = rhsOffsetRef.value;
        block15: while (true) {
            int type = rhs[rhsOffset++] & 0xFF;
            value = 0L;
            switch (type & 0x1F) {
                default: {
                    value = type & 0x1F;
                    break;
                }
                case 27: {
                    value = ((long)rhs[rhsOffset++] & 0xFFL) << 56 | ((long)rhs[rhsOffset++] & 0xFFL) << 48 | ((long)rhs[rhsOffset++] & 0xFFL) << 40 | ((long)rhs[rhsOffset++] & 0xFFL) << 32;
                }
                case 26: {
                    value |= ((long)rhs[rhsOffset++] & 0xFFL) << 24 | ((long)rhs[rhsOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    value |= ((long)rhs[rhsOffset++] & 0xFFL) << 8;
                }
                case 24: {
                    value |= (long)rhs[rhsOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: {
                    throw new IllegalStateException("illegal type: " + type);
                }
                case 31: {
                    value = -1L;
                }
            }
            rhsOffsetRef.value = rhsOffset;
            switch (type >> 5) {
                default: {
                    return false;
                }
                case 6: 
            }
            long tag = value;
            int itag = (int)tag;
            if ((long)itag != tag) continue;
            switch (itag) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return false;
                }
                case 3321: 
                case 3322: 
                case 3323: {
                    if (itag != setType) {
                        return false;
                    }
                    value = Decoder.decodeAnyCborLong(rhs, rhsOffsetRef);
                    break block15;
                }
                default: {
                    continue block15;
                }
            }
            break;
        }
        if (len != value) {
            return false;
        }
        int curLeft = srcOffsetRef.value;
        int curRight = rhsOffsetRef.value;
        while (len > 0L && Equality.cborEquals(src, srcOffsetRef, rhs, rhsOffsetRef)) {
            curLeft = srcOffsetRef.value;
            curRight = rhsOffsetRef.value;
            --len;
        }
        if (len == 0L) {
            return true;
        }
        if (len == 1L) {
            return false;
        }
        srcOffsetRef.value = curLeft;
        rhsOffsetRef.value = curRight;
        if (setType == 3323 || setType == 3321) {
            BinSet bs = BinSet.build(setType == 3323 ? 64 : 96, src, srcOffsetRef, (int)len);
            while (len > 0L) {
                if (!bs.contains(rhs, rhsOffsetRef)) {
                    return false;
                }
                --len;
            }
            return true;
        }
        NumSet ns = new NumSet((int)len);
        for (long i = len; i > 0L; --i) {
            if (ns.add(src, srcOffsetRef) >= 0) continue;
            throw new IllegalArgumentException("duplicate set members");
        }
        while (len > 0L) {
            if (!ns.contains(rhs, rhsOffsetRef)) {
                return false;
            }
            --len;
        }
        return true;
    }

    private static boolean cborBytesEquals(byte[] src, IntRef srcOffsetRef, int majorType, long len, byte[] rhs, IntRef rhsOffsetRef) {
        long value;
        block14: {
            int rhsOffset = rhsOffsetRef.value;
            block11: while (true) {
                int type = rhs[rhsOffset++] & 0xFF;
                value = 0L;
                switch (type & 0x1F) {
                    default: {
                        value = type & 0x1F;
                        break;
                    }
                    case 27: {
                        value = ((long)rhs[rhsOffset++] & 0xFFL) << 56 | ((long)rhs[rhsOffset++] & 0xFFL) << 48 | ((long)rhs[rhsOffset++] & 0xFFL) << 40 | ((long)rhs[rhsOffset++] & 0xFFL) << 32;
                    }
                    case 26: {
                        value |= ((long)rhs[rhsOffset++] & 0xFFL) << 24 | ((long)rhs[rhsOffset++] & 0xFFL) << 16;
                    }
                    case 25: {
                        value |= ((long)rhs[rhsOffset++] & 0xFFL) << 8;
                    }
                    case 24: {
                        value |= (long)rhs[rhsOffset++] & 0xFFL;
                        break;
                    }
                    case 28: 
                    case 29: 
                    case 30: {
                        throw new IllegalStateException("illegal type: " + type);
                    }
                    case 31: {
                        value = -1L;
                    }
                }
                rhsOffsetRef.value = rhsOffset;
                if (majorType == (type & 0xE0)) break block14;
                switch (type >> 5) {
                    case 6: {
                        if (!Equality.knownTag(value)) continue block11;
                        return false;
                    }
                }
                break;
            }
            return false;
        }
        if (len != value) {
            return false;
        }
        int ilen = (int)len;
        int res = Utils.compareUnsigned(src, srcOffsetRef.value, ilen, rhs, rhsOffsetRef.value, ilen);
        if (res == 0) {
            srcOffsetRef.value += ilen;
            rhsOffsetRef.value += ilen;
            return true;
        }
        return false;
    }

    private static boolean cborMapEquals(byte[] src, IntRef srcOffsetRef, long len, byte[] rhs, IntRef rhsOffsetRef) {
        long value;
        int rhsOffset = rhsOffsetRef.value;
        block12: while (true) {
            int type = rhs[rhsOffset++] & 0xFF;
            value = 0L;
            switch (type & 0x1F) {
                default: {
                    value = type & 0x1F;
                    break;
                }
                case 27: {
                    value = ((long)rhs[rhsOffset++] & 0xFFL) << 56 | ((long)rhs[rhsOffset++] & 0xFFL) << 48 | ((long)rhs[rhsOffset++] & 0xFFL) << 40 | ((long)rhs[rhsOffset++] & 0xFFL) << 32;
                }
                case 26: {
                    value |= ((long)rhs[rhsOffset++] & 0xFFL) << 24 | ((long)rhs[rhsOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    value |= ((long)rhs[rhsOffset++] & 0xFFL) << 8;
                }
                case 24: {
                    value |= (long)rhs[rhsOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: {
                    throw new IllegalStateException("illegal type: " + type);
                }
                case 31: {
                    value = -1L;
                }
            }
            rhsOffsetRef.value = rhsOffset;
            switch (type >> 5) {
                default: {
                    return false;
                }
                case 5: {
                    break block12;
                }
                case 6: {
                    if (!Equality.knownTag(value)) continue block12;
                    return false;
                }
            }
            break;
        }
        if (value != len) {
            return false;
        }
        int curLeft = srcOffsetRef.value;
        int curRight = rhsOffsetRef.value;
        while (len > 0L && Equality.cborEquals(src, srcOffsetRef, rhs, rhsOffsetRef) && Equality.cborEquals(src, srcOffsetRef, rhs, rhsOffsetRef)) {
            curLeft = srcOffsetRef.value;
            curRight = rhsOffsetRef.value;
            --len;
        }
        if (len == 0L) {
            return true;
        }
        if (len == 1L) {
            return false;
        }
        srcOffsetRef.value = curLeft;
        rhsOffsetRef.value = curRight;
        FieldIndex fi = FieldIndex.build(src, srcOffsetRef, (int)len);
        for (int i = (int)len; i > 0; --i) {
            if (fi.remove(rhs, rhsOffsetRef)) continue;
            return false;
        }
        return true;
    }

    private static boolean cborArrayEquals(byte[] src, IntRef srcOffsetRef, long len, byte[] rhs, IntRef rhsOffsetRef) {
        int rhsOffset = rhsOffsetRef.value;
        long value = -1L;
        block12: while (true) {
            int type = rhs[rhsOffset++] & 0xFF;
            switch (type & 0x1F) {
                default: {
                    value = type & 0x1F;
                    break;
                }
                case 27: {
                    value = ((long)rhs[rhsOffset++] & 0xFFL) << 56 | ((long)rhs[rhsOffset++] & 0xFFL) << 48 | ((long)rhs[rhsOffset++] & 0xFFL) << 40 | ((long)rhs[rhsOffset++] & 0xFFL) << 32;
                }
                case 26: {
                    value |= ((long)rhs[rhsOffset++] & 0xFFL) << 24 | ((long)rhs[rhsOffset++] & 0xFFL) << 16;
                }
                case 25: {
                    value |= ((long)rhs[rhsOffset++] & 0xFFL) << 8;
                }
                case 24: {
                    value |= (long)rhs[rhsOffset++] & 0xFFL;
                    break;
                }
                case 28: 
                case 29: 
                case 30: {
                    throw new IllegalStateException("illegal type: " + type);
                }
                case 31: {
                    value = -1L;
                }
            }
            rhsOffsetRef.value = rhsOffset;
            switch (type >> 5) {
                default: {
                    return false;
                }
                case 4: {
                    break block12;
                }
                case 6: {
                    if (!Equality.knownTag(value)) continue block12;
                    return false;
                }
            }
            break;
        }
        if (value != len) {
            return false;
        }
        while (len > 0L) {
            if (!Equality.cborEquals(src, srcOffsetRef, rhs, rhsOffsetRef)) {
                return false;
            }
            --len;
        }
        return true;
    }

    private static boolean isNull(byte[] src, int srcOffset) {
        block4: while (true) {
            int b = src[srcOffset++] & 0xFF;
            switch (b >> 5) {
                case 6: {
                    srcOffset = Decoder.nextCborType(b, srcOffset);
                    continue block4;
                }
                case 7: {
                    return (b & 0xFF) == 246;
                }
            }
            break;
        }
        return false;
    }

    private static boolean knownTag(long tag) {
        int itag = (int)tag;
        if ((long)itag == tag) {
            switch (itag) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 3321: 
                case 3322: 
                case 3323: {
                    return true;
                }
            }
        }
        return false;
    }

    private static final class FieldIndex {
        private static final int NO_KEY = 0;
        private static final int TOMBSTONE = -1;
        private final byte[] mSrc;
        private int[] mPos;
        private int[] mCounts;
        private int[] mHashes;
        private int mSize;
        private IntRef mRef;

        private FieldIndex(byte[] src, int sizeHint) {
            if (sizeHint < 4) {
                sizeHint = 4;
            }
            this.mSrc = src;
            int len = Integer.highestOneBit(sizeHint) << 2;
            this.mPos = new int[len];
            this.mHashes = new int[len >> 1];
        }

        private static int hash(byte[] src, int offset, int len) {
            if (src == null) {
                return 0;
            }
            int h = 1;
            for (int i = offset; i < offset + len; ++i) {
                h = 31 * h + src[i];
            }
            return h;
        }

        private static int keyPos(int[] fields, int idx) {
            return fields[idx << 1];
        }

        private static int valPos(int[] fields, int idx) {
            return fields[(idx << 1) + 1];
        }

        private static boolean keyEq(byte[] src1, int offset1, int len1, byte[] src2, int offset2, int len2) {
            if (len1 != len2) {
                return false;
            }
            return Utils.compareUnsigned(src1, offset1, len1, src2, offset2, len2) == 0;
        }

        private void addDuplicate(int idx, int count) {
            if (this.mCounts == null) {
                this.mCounts = new int[this.mPos.length >> 1];
            }
            int n = idx;
            this.mCounts[n] = this.mCounts[n] + count;
        }

        public boolean remove(byte[] src, IntRef srcOffsetRef) {
            int keyStart = srcOffsetRef.value;
            int valStart = Decoder.skipCborItem(src, keyStart);
            int[] fields = this.mPos;
            int sz = fields.length >> 1;
            int hc = FieldIndex.hash(src, keyStart, valStart - keyStart);
            int idx = hc & sz - 1;
            int tries = 0;
            int pos;
            while ((pos = FieldIndex.keyPos(fields, idx)) != 0) {
                if (pos > 0) {
                    int valPos = FieldIndex.valPos(fields, idx);
                    if (this.mHashes[idx] == hc && FieldIndex.keyEq(this.mSrc, --pos, valPos - pos, src, keyStart, valStart - keyStart)) {
                        if (this.mRef == null) {
                            this.mRef = new IntRef();
                        }
                        this.mRef.value = valPos;
                        srcOffsetRef.value = valStart;
                        if (Equality.cborEquals(this.mSrc, this.mRef, src, srcOffsetRef)) {
                            if (this.mCounts != null && this.mCounts[idx] > 0) {
                                int n = idx;
                                this.mCounts[n] = this.mCounts[n] - 1;
                                return true;
                            }
                            fields[idx << 1] = -1;
                            return true;
                        }
                    }
                }
                if (++tries >= FieldIndex.probeLimit(sz)) {
                    return false;
                }
                idx = idx + 1 & sz - 1;
            }
            return false;
        }

        private void insert(int keyPos, int valStart, int hc, int dups) {
            int[] fields = this.mPos;
            int sz = fields.length >> 1;
            int[] hashes = this.mHashes;
            int tries = 0;
            int idx = hc & sz - 1;
            while (true) {
                int keyStart;
                if ((keyStart = FieldIndex.keyPos(fields, idx)) == 0) {
                    fields[idx << 1] = keyPos;
                    fields[(idx << 1) + 1] = valStart;
                    hashes[idx] = hc;
                    if (dups > 0) {
                        this.addDuplicate(idx, dups);
                    }
                    this.mSize += dups + 1;
                    return;
                }
                if (++tries >= FieldIndex.probeLimit(sz)) {
                    this.resize();
                    this.insert(keyPos, valStart, hc, dups);
                    return;
                }
                idx = idx + 1 & sz - 1;
            }
        }

        private void resize() {
            int oldSz = this.mPos.length >> 1;
            int newSz = oldSz << 1;
            FieldIndex fi = new FieldIndex(this.mSrc, newSz);
            int[] fields = this.mPos;
            int[] counts = this.mCounts;
            int[] hashes = this.mHashes;
            int active = this.mSize;
            for (int idx = 0; idx < oldSz && active > 0; ++idx) {
                int keyp = FieldIndex.keyPos(this.mPos, idx);
                if (keyp <= 0) continue;
                int valStart = FieldIndex.valPos(fields, idx);
                int hc = hashes[idx];
                int dups = counts != null ? counts[idx] : 0;
                fi.insert(keyp, valStart, hc, dups);
                active -= dups + 1;
            }
            this.mPos = fi.mPos;
            this.mHashes = fi.mHashes;
            this.mCounts = fi.mCounts;
        }

        private boolean add(IntRef srcOffsetRef) {
            byte[] src = this.mSrc;
            int startPos = srcOffsetRef.value;
            int endPos = Decoder.skipCborItem(src, startPos);
            int valEnd = Decoder.skipCborItem(src, endPos);
            int keyLen = endPos - startPos;
            int[] fields = this.mPos;
            int sz = fields.length >> 1;
            int hc = FieldIndex.hash(src, startPos, keyLen);
            srcOffsetRef.value = valEnd;
            int idx = hc & sz - 1;
            int tries = 0;
            while (true) {
                int keyStart;
                if ((keyStart = FieldIndex.keyPos(fields, idx)) == 0) {
                    fields[idx << 1] = startPos + 1;
                    fields[(idx << 1) + 1] = endPos;
                    this.mHashes[idx] = hc;
                    ++this.mSize;
                    return true;
                }
                int valPos = FieldIndex.valPos(fields, idx);
                if (this.mHashes[idx] == hc && FieldIndex.keyEq(src, --keyStart, valPos - keyStart, src, startPos, keyLen) && Equality.cborEquals(this.mSrc, valPos, src, endPos)) {
                    ++this.mSize;
                    this.addDuplicate(idx, 1);
                    return true;
                }
                if (++tries >= FieldIndex.probeLimit(sz)) {
                    this.resize();
                    srcOffsetRef.value = startPos;
                    return this.add(srcOffsetRef);
                }
                idx = idx + 1 & sz - 1;
            }
        }

        private static int probeLimit(int len) {
            return 10 + (len >> 2);
        }

        public static FieldIndex build(byte[] src, IntRef srcOffsetRef, int numElements) {
            if (src == null) {
                return null;
            }
            FieldIndex fi = new FieldIndex(src, numElements);
            while (numElements > 0) {
                fi.add(srcOffsetRef);
                --numElements;
            }
            return fi;
        }
    }
}

