/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.dax.bits;

import com.amazon.cbor.CborOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;

public class DaxCborOutputStream
extends CborOutputStream {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    DaxCborOutputStream() {
        this(new ByteArrayOutputStream());
    }

    public DaxCborOutputStream(OutputStream output) {
        this(output, 8192);
    }

    public DaxCborOutputStream(OutputStream output, int buffSize) {
        super(output, buffSize);
    }

    public void writeStringSetHeader(int numElems) throws IOException {
        this.writeType(192, 3321L);
        this.writeArrayHeader(numElems);
    }

    public void writeStringSet(Collection<String> stringSet) throws IOException {
        this.writeStringSetHeader(stringSet.size());
        for (String s : stringSet) {
            this.writeString(s);
        }
    }

    public void writeBinarySetHeader(int numElems) throws IOException {
        this.writeType(192, 3323L);
        this.writeArrayHeader(numElems);
    }

    public void writeBytesSet(Collection<byte[]> bytes) throws IOException {
        this.writeBinarySetHeader(bytes.size());
        for (byte[] b : bytes) {
            this.writeBytes(b);
        }
    }

    public void writeBinarySet(Collection<ByteBuffer> byteBuffers) throws IOException {
        this.writeBinarySetHeader(byteBuffers.size());
        for (ByteBuffer b : byteBuffers) {
            this.writeBinary(b);
        }
    }

    public void writeNumberSetHeader(int numElems) throws IOException {
        this.writeType(192, 3322L);
        this.writeArrayHeader(numElems);
    }

    public void writeNumberSet(Collection<String> numbers) throws IOException {
        this.writeNumberSetHeader(numbers.size());
        for (String number : numbers) {
            this.writeNumber(number);
        }
    }
}

