/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.exceptions;

public enum LocalDBClientExceptionMessage {
    BAD_TABLE_NAME("Invalid table/index name.  Table/index names must be between 3 and 255 characters long, and may contain only the characters a-z, A-Z, 0-9, '_', '-', and '.'"),
    INVALID_ARN_FORMAT("Valid ARN format is 'arn:<awsPartition>:<vendor>:<region>:<subscriber>:resourceType/resourceName', where Resource name must have length less than or equal to 255, Resource name must have length greater than or equal to 3, Resource name must satisfyregular expression pattern: [a-zA-Z0-9_.-]+"),
    NO_KEY_SCHEMA("No defined key schema.  A key schema containing at least a hash key must be defined for all tables"),
    NO_ATTRIBUTE_SCHEMA("No Attribute Schema Defined"),
    UNSPECIFIED_KEY_TYPE("One or more keys is not specified as being hash or range."),
    INVALID_KEY_SCHEMA_ELEMENT("Key schema element is invalid."),
    NO_HASH_KEY("No Hash Key specified in schema.  All Dynamo DB tables must have exactly one hash key"),
    NON_SPECIFIED_HASH_KEY("Hash Key not specified in Attribute Definitions.  Type unknown."),
    NON_SPECIFIED_RANGE_KEY("Range Key not specified in Attribute Definitions.  Type unknown."),
    NON_SPECIFIED_LSI_RANGE_KEY("Local Secondary Index range key not specified in Attribute Definitions.Type unknown."),
    NON_SPECIFIED_GSI_HASH_KEY("Global Secondary Index hash key not specified in Attribute Definitions.Type unknown."),
    NON_SPECIFIED_GSI_RANGE_KEY("Global Secondary Index range key not specified in Attribute Definitions.Type unknown."),
    KEY_SCHEMA_TOO_BIG("Key Schema too big.  Key Schema must at most consist of the hash and range key of a table"),
    INCORRECT_KEY_SCHEMA_ORDER("Invalid key order. Hash Key must be specified first in key schema, Range Key must be specifed second"),
    IDENTICALLY_NAMED_KEYS("Two keys can not have the same name"),
    TOO_MANY_HASH_KEYS("Too many hash keys specified.  All Dynamo DB tables must have exactly one hash key"),
    TOO_MANY_ATTRIBUTES("The number of attributes in key schema must match the number of attributes defined in attribute definitions."),
    INVALID_DATATYPE("Invalid attribute value type"),
    NO_DATATYPE("Invalid Attribute value. Must contain exactly one of the supported datatypes."),
    DOUBLE_DATATYPE("Attribute has two datatypes.  Only one datatype (and piece of data) allowed per attribute"),
    FALSE_NULL_DATATYPE("Value for null type attributes must be true"),
    EMPTY_KEY_ATTRIBUTE_VALUE_STRING("One or more parameter values are not valid. The AttributeValue for a key attribute cannot contain an empty string value."),
    EMPTY_KEY_ATTRIBUTE_VALUE_BINARY("One or more parameter values are not valid. The AttributeValue for a key attribute cannot contain an empty binary value."),
    INDEX_EMPTY_STR_KEY_VALUE_UNSUPPORTED("One or more parameter values are not valid. A value specified for a secondary index key is not supported. The AttributeValue for a key attribute cannot contain an empty string value."),
    INDEX_EMPTY_BINARY_KEY_VALUE_UNSUPPORTED("One or more parameter values are not valid. A value specified for a secondary index key is not supported. The AttributeValue for a key attribute cannot contain an empty binary value."),
    UPD_EXPR_INDEX_EMPTY_STRING_KEY_VALUE_UNSUPPORTED("One or more parameter values are not valid. The update expression attempted to update a secondary index key to a value that is not supported. The AttributeValue for a key attribute cannot contain an empty string value."),
    UPD_EXPR_INDEX_EMPTY_BINARY_KEY_VALUE_UNSUPPORTED("One or more parameter values are not valid. The update expression attempted to update a secondary index key to a value that is not supported. The AttributeValue for a key attribute cannot contain an empty binary value."),
    INVALID_PUT_NULL("Item to put in PutItem cannot be null"),
    NO_SPECIFED_KEY_VALUE("One of the required keys was not given a value"),
    INCONSISTENT_TYPES("Type mismatch for attribute to update"),
    INCONSISTENT_PRIMARY_KEY_TYPES("One or more parameter values were invalid: Type mismatch for key"),
    INCONSISTENT_INDEX_KEY_TYPES("One or more parameter values were invalid: Type mismatch for Index Key"),
    INCONSISTENT_CONDITION_PARAMETER("One or more parameter values were invalid: Condition parameter type does not match schema type"),
    MISSING_KEY("Cannot have null key for GetItem, DeleteItem, or UpdateItem"),
    INCONSISTENT_GET_CONDITION_SIZE("The number of conditions on the keys is invalid"),
    BAD_GET_CONDITION("Get Condition for key not in key list"),
    NO_LSI_ALLOWED("Local Secondary indices are not allowed on hash tables, only hash and range tables"),
    INVALID_LSI("Local Secondary indices must have the same hash key as the main table"),
    INVALID_LSI_NO_RANGE("Local secondary indices must have a range key"),
    INVALID_INDEX_NO_PROJECTION("Indexes must have a projection specified"),
    SAME_NAME_LSI("Two local secondary indices have the same name"),
    SAME_NAME_GSI("Two global secondary indices have the same name"),
    SAME_NAME_LSI_GSI("Local Secondary Indices AND Global Secondary Indices must have different names"),
    INVALID_THROUGHPUT_NULL("No provisioned throughput specified for the table"),
    INVALID_THROUGHPUT_GSI_NULL("No provisioned throughput specified for the global secondary index"),
    IDENTICAL_ATTRIBUTE_NAMES("Cannot have two attributes with the same name"),
    INVALID_ATTRIBUTE_TO_GET("Specified attribute does not exist in the index projection"),
    INVALID_QUERY_NON_EXISTENT_INDEX("Specified index is not part of table"),
    SECONDARY_INDEXES_NOT_FOUND("The table does not have the specified index: %s"),
    INVALID_QUERY_NO_CONDITIONS("Key Conditions on query must not be null"),
    INVALID_QUERY_EXCESS_CONDITIONS("There are too many conditions in this query"),
    INVALID_QUERY_NON_MATCHING_RANGE("Range Condition does not match range key"),
    INVALID_QUERY_NO_HASH("All queries must have a condition on the hash key, and it must be of type EQ"),
    INVALID_QUERY_KEY_NOT_SPECIFIED("Must specify an expected value and comparison type for the all keys being queried"),
    INVALID_EXCLUSIVE_START("The provided starting key is invalid"),
    EMPTY_HASH_EXCLUSIVE_START("The query can return at most one row and cannot be restarted."),
    INVALID_RETURN_VALUES_TYPE("Return values set to invalid value"),
    NON_NUMERIC_VALUE("A value provided cannot be converted into a number"),
    SEGMENT_NOT_SET("If total segments is specified, a particular segment must also be specified for this request"),
    INVALID_EXCLUSIVE_START_KEY_FOR_SCAN("Exclusive start key must lie within the segment"),
    TOTAL_SEGMENTS_NOT_SET("If segment is specified, total segment must also be specified"),
    INVALID_LIMIT_VALUE("Limit must be greater than or equal to 1"),
    INVALID_LIMIT_TOO_BIG("Limit in ListTables must be <= 100"),
    INVALID_EXCLUSIVE_START_SIZE("Exclusive Start Key must have same size as table's key schema"),
    NOT_SAME_SCAN("To use the setNumPerSegment method, you must use a scan from the same table with the same segment values"),
    TABLE_ALREADY_EXISTS("Cannot create preexisting table"),
    DELETE_PROTECTION_ENABLED("Resource cannot be deleted as it is currently protected against deletion. Disable deletion protection first."),
    EMPTY_NUMBER_SET("An number set  may not be empty"),
    EMPTY_BINARY_SET("Binary sets should not be empty"),
    EMPTY_STRING_SET("An string set  may not be empty"),
    LSI_NOT_IN_TABLE("The specified index is not in the table"),
    INVALID_SET_DUPLICATES("Input collection contains duplicates"),
    TOO_MANY_LSI("Cannot have more than 5 local secondary indexes per table"),
    TOO_MANY_GSI_VALIDATION_EXCEPTION("GlobalSecondaryIndex count exceeds the per-table limit"),
    TOO_MANY_GSI_LIMIT_EXCEEDED_EXCEPTION("Number of global secondary indexes exceeds per-table limit"),
    EMPTY_LSI_LIST("LSI list is empty/invalid"),
    EMPTY_GSI_LIST("GSI list is empty/invalid"),
    CONSISTENT_GSI_QUERY("Consistent read cannot be true when querying a GSI"),
    CONSISTENT_GSI_SCAN("Consistent read cannot be true when scanning a GSI"),
    NULL_GSI_UPDATE("Global secondary index update is null"),
    NULL_GSI_UPDATE_ACTION("Update global secondary index action is null"),
    INVALID_GSI_NAME("Invalid global secondary index name"),
    INVALID_GSI_UPDATE_ACTION("Invalid global secondary index update action"),
    INVALID_PROJECTION_TYPE("Projection type must be INCLUDE, ALL, or KEYS_ONLY"),
    NO_PROJECTED_ATTRS("If Projection type INCLUDE is specified, some non-key attributes to include in the projection must be specified as well"),
    TOO_MANY_PROJECTED("No more than 20 attributes per table can be projected into Local Secondary Indices"),
    ATTRIBUTE_NAME_TOO_LONG("Names of key attributes and attributes projected into an index must be between 1 and 255 characters, inclusive"),
    INVALID_PROJECTED_ATTRS("No attributes should be specified to be projected unless projection type is INCLUDE"),
    INVALID_THROUGHPUT_VALUES("Table read and write throughput must be at least 1, and cannot be null"),
    INVALID_MAX_READ_REQUEST_UNITS("Requested MaxReadRequestUnits for OnDemandThroughput for table is outside of valid range"),
    INVALID_MAX_WRITE_REQUEST_UNITS("Requested MaxWriteRequestUnits for OnDemandThroughput for table is outside of valid range"),
    INVALID_THROUGHPUT_VALUES_GSI("Global Secondary Index's read and write throughput must be at least 1, and cannot be null"),
    INVALID_MAX_READ_REQUEST_UNITS_GSI("One or more parameter values were invalid: Requested MaxReadRequestUnits for OnDemandThroughput for index : %s is outside of valid range"),
    INVALID_MAX_WRITE_REQUEST_UNITS_GSI("One or more parameter values were invalid: Requested MaxWriteRequestUnits for OnDemandThroughput for index : %s is outside of valid range"),
    TABLE_DOES_NOT_EXIST("Cannot do operations on a non-existent table"),
    INVALID_COMPARISON("Comparison type does not exist in DynamoDB"),
    INVALID_COMPARISON_QUERY("Comparison type not valid for query"),
    INVALID_EXPECTED_TRUE("Exists set to true but no value given"),
    INVALID_EXPECTED_FALSE("Cannot expect an attribute to both not exist and have a value"),
    ATTRIBUTES_EMPTY("AttributesToGet cannot be empty"),
    INVALID_SELECT("Select must be ALL_ATTRIBUTES, ALL_PROJECTED_ATTRIBUTES, COUNT, or SPECIFIC_ATTRIBUTES"),
    INVALID_SELECT_ATTRIBUTES("AttributesToGet may only be set if Select is SPECIFIC_ATTRIBUTES"),
    INVALID_SELECT_NO_ATTRIBUTES("If Select is set to SPECIFIC_ATTRIBUTES, AttributesToGet cannot be null"),
    INVALID_SELECT_INDEX("ALL_PROJECTED_ATTRIBUTES can be used only when Querying using an IndexName"),
    INVALID_COMPARISON_DATATYPE_BEGINS("Comparison Operator BEGINS can only be used withBinary or String values, not Numbers or Sets"),
    INVALID_COMPARISON_BETWEEN("Comparison Operator BETWEEN requires two pivots"),
    INVALID_BETWEEN_PIVOTS("First value in BETWEEN comparison must be less than or equal to second value"),
    INVALID_NUMBER_OF_ARGUMENTS("Invalid number of argument(s) for the %s ComparisonOperator"),
    INVALID_COMPARISON_NOT_BETWEEN_IN("Only Comparison Operators BETWEEN and IN take more than one pivot"),
    INVALID_COMPARISON_NULL("Comparison Operators NULL and NOT_NULL do not take pivots"),
    CONDITIONAL_CHECK_FAILED("The conditional request failed"),
    INVALID_ACTION_TYPE("Member must satisfy enum value set: [ADD, DELETE, PUT]"),
    INVALID_ACTION_NO_VALUE("Only DELETE may specify no attribute value"),
    INVALID_ACTION_DELETE("DELETE only valid for no attribute value, or a set value"),
    INVALID_ACTION_ADD("ADD must specify an attribute value of type number or set"),
    INVALID_UPDATE_INDEX_KEY("Updates on index keys must be of the same data type as the key attribute"),
    INVALID_ATTRIBUTE_TYPE("Member must satisfy enum value set: [B, N, S]"),
    NUMBER_OVERFLOW("Number overflow. Attempting to store a number with magnitude larger than supported range"),
    NUMBER_UNDERFLOW("Number underflow. Attempting to store a number with magnitude smaller than supported range"),
    NON_SCALAR_TYPE_COMPARISON("Compare can only be called on sortable scalar types"),
    INVALID_TYPE_COMPARISON("Compare cannot be called for different types"),
    EMPTY_EXPRESSION("The expression can not be empty"),
    EXPRESSION_SIZE_EXCEEDED("Expression size has exceeded the maximum allowed size"),
    BETWEEN_LBOUND_BIGGER_THAN_UBOUND("The BETWEEN operator requires upper bound to be greater than or equal to lower bound"),
    BETWEEN_REQUIRES_SAME_DATA_TYPES("The BETWEEN operator requires same data type for lower and upper bounds"),
    DOC_PATH_PARAMETER_MISSING("An expression attribute name used in the document path is not defined"),
    LITERAL_PARAMETER_MISSING("An expression attribute value used in expression is not defined"),
    ITEM_CONTAINS_NULL_ATTRVALUE("The supplied Item contains a null AttributeValue"),
    QUERY_FILTER_CONTAINS_PRIMARY_KEY_ATTRIBUTES("QueryFilter can only contain non-primary key attributes: Primary key attribute: %s"),
    QUERY_FILTER_EXPRESSION_CONTAINS_PRIMARY_KEY_ATTRIBUTES("Filter Expression can only contain non-primary key attributes: Primary key attribute: %s"),
    NUMBER_TOO_PRECISE("DynamoDB only supports precision up to 38 digits"),
    INVALID_COMPARISON_SETS("Set types may not be used for scan filters or query comparisons"),
    INVALID_COMPARISON_IN_DATATYPES("AttributeValueList of ComparisonType IN must have all values of the same datatype"),
    INVALID_COMPARISON_NO_DATA("AttributeValueList must be non-null and have at least one member for all comparison types except NULL and NOT_NULL"),
    INVALID_EXCLUSIVE_START_QUERY("ExclusiveStartKey must fit the query conditions"),
    INVALID_START_KEY_RANGE("The provided starting key does not match the range key predicate"),
    TOO_MANY_REQUESTED_ITEMS("BatchGetItem cannot fetch more than 100 items"),
    DUPLICATE_ITEM_KEY("Provided list of item keys contains duplicates"),
    TOO_MUCH_THROUGHPUT("Cannot increase provisioned throughput to more than twice current value"),
    SAME_THROUGHPUT("The requested throughput value equals the current value"),
    TOO_MUCH_THROUGHPUT_TABLE("Cannot increase provisioned throughput to more than 40,000 units per table"),
    TOO_MUCH_THROUGHPUT_GSI("Cannot increase provisioned throughput to more than 40,000 units per global secondary index"),
    TOO_MUCH_THROUGHPUT_ACCOUNT("Cannot increase provisioned throughput to more than 80,000 units per account"),
    MISSING_ITEM("Cannot put a null item"),
    BATCH_GET_NULL_REQUESTS("BatchGetItem must have some requests set"),
    BATCH_GET_NULL_REQUEST_ENTRY("BatchGetItem cannot have a null request in its requests set"),
    BATCH_GET_TOO_MANY_REQUESTED_ITEMS("BatchGetItem cannot fetch more than 100 items"),
    BATCH_WRITE_NULL_REQUESTS("BatchWriteItem cannot have a null or no requests set"),
    BATCH_WRITE_NULL_REQUEST_ENTRY("BatchWriteItem cannot have a null or empty list of requests in its requests set"),
    BATCH_WRITE_NULL_INDIVIDUAL_REQUEST("BatchWriteItem cannot have a null request in any part of its requests set"),
    BATCH_WRITE_TOO_MANY_REQUESTS("BatchWriteItem cannot write more than 25 items"),
    BATCH_WRITE_TWO_IN_ONE("Each request in a BatchWriteItem must be Put or Delete, not both"),
    BATCH_WRITE_NO_REQUEST_TYPE("Each request in a BatchWriteItem must be Put or Delete"),
    BATCH_WRITE_SAME_ITEM("Provided list of item keys contains duplicates"),
    BATCH_WRITE_TOO_BIG("BatchWriteItem cannot have a request size of more than 1 MB"),
    ITEM_UPD_TOO_LARGE("Item size to update has exceeded the maximum allowed size"),
    ITEM_TOO_BIG("Item size has exceeded the maximum allowed size"),
    KEY_VALUE_TOO_BIG("Hash primary key values must be under 2048 bytes, and range primary key values must be under 1024 bytes"),
    NO_ATTRIBUTE_NAME("Attribute name must be specified."),
    EMPTY_TABLE_NAME("Value null at 'tableName' failed to satisfy constraint: Member must not be null"),
    EMPTY_ATTRIBUTE_NAME("Empty attribute name"),
    NO_KEYS("Keys must be specified in the request items"),
    NOTHING_TO_UPDATE("Nothing to update"),
    STALE_DATABASE("New release of DynamoDB Local cannot be used with your old database. Either delete the database or change your AWS credentials."),
    INVALID_QUERY_FILTER_ON_LSI("One or more parameter values were invalid: Secondary index %s does not project one or more filter attributes: [%s]"),
    INVALID_PARAMETER_VALUE("One or more parameter values were invalid: %s"),
    COND_OP_WITHOUT_FILTER_OR_EXPECTED("ConditionalOperator cannot be used without Filter or Expected"),
    COND_OP_WITH_ONE_ELEMENT("ConditionalOperator can only be used when Filter or Expected has two or more elements"),
    TIME_OUT_WHILE_ACQUIRING_LOCK("This action timed out because it too long waiting for a lock. This request will succeed in actual DynamoDB API"),
    INTERRUPTED_EXCEPTION_WHILE_ACQUIRING_LOCK("Interrupted while trying to acquire lock"),
    TAGGING_NOT_SUPPORTED("Tagging is not currently supported in DynamoDB Local."),
    CANNOT_UPDATE_ATTRIBUTE("Cannot update attribute "),
    TRANSACT_GET_NULL_REQUESTS("Value null at 'transactItems' failed to satisfy constraint: Member must not be null"),
    TRANSACT_DUPLICATE_KEY("Transaction request cannot include multiple operations on one item"),
    TRANSACT_TOO_MANY_REQUESTS("Member must have length less than or equal to 100"),
    TRANSACT_WRITE_NULL_REQUESTS("Value null at 'transactItems' failed to satisfy constraint: Member must not be null"),
    TRANSACT_WRITE_EMPTY_REQUESTS("Member must have length greater than or equal to 1"),
    TRANSACT_UPDATE_NULL_UPDATE_EXPRESSION("UpdateExpression is required for Update operations in TransactWriteItems"),
    TRANSACT_CHECK_NULL_CONDITION_EXPRESSION("ConditionExpression is required for ConditionCheck operations in TransactWriteItems"),
    TRANSACT_REQUEST_PAYLOAD_TOO_LARGE("Transaction payload size cannot exceed 4MB. Payload Size: "),
    TRANSACT_RESPONSE_PAYLOAD_TOO_LARGE("Payload in response is too large."),
    TRANSACT_WRITE_NO_OPERATIONS("Invalid Request: TransactWriteRequest should contain Delete or Put or Update request"),
    TRANSACT_WRITE_MULTIPLE_OPERATIONS("TransactItems can only contain one of Check, Put, Update or Delete"),
    TRANSACT_IDEMPOTENT_MISMATCH("Specified idempotent token was used with different request parameters within the idempotency window"),
    TRANSACT_IDEMPOTENT_TOKEN_TOO_LARGE("Member must have length less than or equal to 36"),
    MEMBER_NULL("Member must not be null"),
    INTERRUPTED_EXCEPTION_DURING_BACKGROUND_JOB("Interrupted while executing background job"),
    MAX_GSI_CREATE_ACTIONS("Subscriber limit exceeded: Only 1 online index can be created simultaneously per table"),
    MAX_GSI_DELETE_ACTIONS("Subscriber limit exceeded: Only 1 online index can be deleted simultaneously per table"),
    INFLIGHT_INDEX_LIMIT_EXCEEDED_EXCEPTION("Subscriber limit exceeded: Only 1 online index can be created or deleted simultaneously per table"),
    ONLY_ONE_GSI_UPDATE_PER_REQUEST_FOR_AN_INDEX("Only one global secondary index update per index is allowed simultaneously."),
    CANNOT_DELETE_LSI_VIA_DELETE_GSI_API("Cannot delete an index that is not a GlobalSecondaryIndex"),
    CANNOT_CREATE_GSI_WITH_SAME_NAME_AS_ANOTHER_INDEX("Attempting to create an index which already exists"),
    INDEX_IS_BEING_CREATED("Attempt to change a resource which is still in use: Index is being created."),
    INDEX_IS_BEING_CREATED_BUT_NOT_BACKFILLING("Attempt to change a resource which is still in use: Index is being created but not backfilling."),
    INDEX_IS_BEING_DELETED("Attempt to change a resource which is still in use: Index is being deleted."),
    INDEX_IS_BEING_UPDATED("Attempt to change a resource which is still in use: Index is being updated."),
    INVALID_ATTRIBUTE_REDEFINITION("invalid attribute, SchemaElement redefined should be of same type as previously defined"),
    REQUESTED_RESOURCE_NOT_FOUND("Requested resource not found"),
    SUBSCRIBER_WIDE_CONTROL_PLANE_OPERATIONS_LIMIT_REACHED("Subscriber limit exceeded: Only 10 tables can be created, updated, or deleted simultaneously"),
    SUBSCRIBER_WIDE_MAX_INFLIGHT_CREATE_ONLINE_GSI_LIMIT_REACHED("Subscriber limit exceeded: Only 5 tables with online indexes can be created simultaneously"),
    CANT_UPDATE_TABLE_WHEN_INDEX_IS_CREATING_BACKFILLING_FALSE("Can't update table while indexes are in CREATING, isBackfilling=false status. Table: %s Index: %s"),
    CANT_UPDATE_TABLE_WHEN_INDEX_IS_DELETING("Can't update table while indexes are in DELETING status. Table: %s Index: %s"),
    STREAM_SPECIFICATION_EMPTY("StreamEnabled must be specified with Stream Specification"),
    MISSING_STREAM_ARN("streamArn cannot be empty or null."),
    MISSING_SHARD_ID("The parameter 'ShardId' is required but was not present in the request"),
    INVALID_STREAM_ARN("Invalid StreamArn"),
    INVALID_STREAM_ID("Invalid StreamId"),
    INVALID_STREAM_VIEW_TYPE("Invalid StreamViewType"),
    INVALID_SHARD_ITERATOR("Invalid ShardIterator"),
    INVALID_STREAM_SEQUENCE_NUMBER("Invalid SequenceNumber"),
    STREAM_SEQUENCE_NUMBER_NOT_ALLOWED("SequenceNumber should not be passed for this iterator type"),
    SEQUENCE_NUMBER_CANNOT_BE_NULL("SequenceNumber cannot be null"),
    INVALID_STREAM_REQUEST("Table has no stream to disable"),
    INVALID_ENABLE_STREAM_REQUEST("Table already has an enabled stream"),
    SIMULTANEOUS_PT_AND_STREAM_SPEC_UPDATE_TABLE("Cannot change IOPS and Streams at the same time."),
    SHARD_NOT_FOUND("Shard does not exist"),
    STREAM_NOT_FOUND("Stream does not exist"),
    ROLLOVER_INTERRUPTED_ERROR_MESSAGE("Shard Rollover task was interrupted."),
    ROLLOVER_EXECUTION_EXCEPTION_MESSAGE("Shard Rollover could not complete."),
    NULL_TIME_TO_LIVE_SPECIFICATION("TimeToLiveSpecification cannot be null"),
    NULL_ENABLE_FLAG_IN_TIME_TO_LIVE_SPECIFICATION("AttributeName cannot be null when time to live is being enabled"),
    NULL_TIME_TO_LIVE_ATTRIBUTE_NAME("AttributeName cannot be null when time to live is being enabled"),
    INVALID_TIME_TO_LIVE_ATTRIBUTE_NAME("AttributeName must be null when time to live is being disabled"),
    TABLE_NOT_ACTIVE_FOR_CONFIGURE_TIME_TO_LIVE("Time to live cannot be configured when table is in CREATING or DELETING state"),
    TIME_TO_LIVE_MODIFIED_MULTIPLE_TIMES_WITHIN_FIXED_INTERVAL("Time to live has been modified multiple times within a fixed interval"),
    TIME_TO_LIVE_ALREADY_ENABLED("TimeToLive is already enabled"),
    TIME_TO_LIVE_ALREADY_DISABLED("TimeToLive is already disabled"),
    TIME_TO_LIVE_CONFLICTING_ATTRIBUTE_NAME("TimeToLive is active on a different AttributeName"),
    INVALID_DILATE_TIME_MESSAGE("Invalid dilation amount, must be greater than 0."),
    BACKUP_OPERATION_NOT_SUPPORTED("Backup operations are currently not supported in DynamoDB Local."),
    CONTINUOUS_BACKUP_OPERATION_NOT_SUPPORTED("Continuous backup operations are currently not supported in DynamoDB Local."),
    RECOVERY_OPERATION_NOT_SUPPORTED("Recovery operations are currently not supported in DynamoDB Local."),
    GLOBAL_TABLE_OPERATION_NOT_SUPPORTED("Global table operations are currently not supported in DynamoDB Local."),
    CONTRIBUTOR_INSIGHTS_OPERATION_NOT_SUPPORTED("Contributor insights operations are currently not supported in DynamoDB Local."),
    ENDPOINT_OPERATION_NOT_SUPPORTED("Endpoint operations are not supported in LocalDynamoDB"),
    REGION_OPERATION_NOT_SUPPORTED("Region operations are not supported in LocalDynamoDB"),
    EXPORT_OPERATION_NOT_SUPPORTED("Export operations are not supported in LocalDynamoDB"),
    KINESIS_STREAMING_OPERATION_NOT_SUPPORTED("Kinesis streaming operations are not supported in LocalDynamoDB"),
    TABLE_REPLICA_AUTO_SCALING_OPERATION_NOT_SUPPORTED("Table replica auto scaling operations are not supported in LocalDynamoDB");

    private final String message;

    private LocalDBClientExceptionMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }
}

