/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.manualtest;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import com.amazonaws.services.dynamodbv2.model.BatchExecuteStatementRequest;
import com.amazonaws.services.dynamodbv2.model.BatchExecuteStatementResult;
import com.amazonaws.services.dynamodbv2.model.BatchStatementResponse;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.OnDemandThroughput;
import com.amazonaws.services.dynamodbv2.model.ReturnValuesOnConditionCheckFailure;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;

public class BatchExecuteStatement {
    public static void sdkV2Test(DynamoDbClient ddbClient) {
        String tableName = "GameScores";
        BatchExecuteStatement.createTableV2(ddbClient, tableName);
        HashMap<String, AttributeValue> item1 = new HashMap<String, AttributeValue>();
        item1.put("UserId", AttributeValue.fromS((String)"user1"));
        item1.put("GameTitle", AttributeValue.fromS((String)"Game1"));
        item1.put("Score", AttributeValue.fromS((String)"500"));
        PutItemRequest putItemRequest = (PutItemRequest)PutItemRequest.builder().tableName(tableName).item(item1).build();
        ddbClient.putItem(putItemRequest);
        HashMap<String, AttributeValue> item2 = new HashMap<String, AttributeValue>();
        item2.put("UserId", AttributeValue.fromS((String)"user2"));
        item2.put("GameTitle", AttributeValue.fromS((String)"Game2"));
        item2.put("Score", AttributeValue.fromS((String)"400"));
        PutItemRequest putItemRequest1 = (PutItemRequest)PutItemRequest.builder().tableName(tableName).item(item2).build();
        ddbClient.putItem(putItemRequest1);
        AttributeValue att1 = (AttributeValue)AttributeValue.builder().s("500").build();
        AttributeValue att2 = (AttributeValue)AttributeValue.builder().s("user2").build();
        AttributeValue att3 = (AttributeValue)AttributeValue.builder().s("Game2").build();
        AttributeValue att4 = (AttributeValue)AttributeValue.builder().s("400").build();
        ArrayList<AttributeValue> parametersRec1 = new ArrayList<AttributeValue>();
        parametersRec1.add(att1);
        parametersRec1.add(att2);
        parametersRec1.add(att3);
        parametersRec1.add(att4);
        BatchStatementRequest batchStatementRequest = (BatchStatementRequest)BatchStatementRequest.builder().statement("UPDATE " + tableName + " SET Score = ? WHERE UserId = ? AND GameTitle = ? AND Sample = ?").returnValuesOnConditionCheckFailure(String.valueOf(ReturnValuesOnConditionCheckFailure.ALL_OLD)).parameters(parametersRec1).build();
        try {
            BatchExecuteStatementResponse response = ddbClient.batchExecuteStatement((software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest)software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest.builder().statements(new BatchStatementRequest[]{batchStatementRequest}).build());
            System.out.println(response.toString());
        }
        catch (DynamoDbException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static void createTableV2(DynamoDbClient ddbClient, String tableName) {
        if (!ddbClient.listTables().tableNames().contains(tableName)) {
            software.amazon.awssdk.services.dynamodb.model.CreateTableRequest createTableRequest = (software.amazon.awssdk.services.dynamodb.model.CreateTableRequest)software.amazon.awssdk.services.dynamodb.model.CreateTableRequest.builder().tableName(tableName).billingMode(software.amazon.awssdk.services.dynamodb.model.BillingMode.PAY_PER_REQUEST).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("UserId").keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName("GameTitle").keyType(KeyType.RANGE).build()}).attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("UserId").attributeType(ScalarAttributeType.S).build(), (AttributeDefinition)AttributeDefinition.builder().attributeName("GameTitle").attributeType(ScalarAttributeType.S).build()}).onDemandThroughput((software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput)software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput.builder().maxWriteRequestUnits(Long.valueOf(10L)).maxReadRequestUnits(Long.valueOf(10L)).build()).build();
            try {
                CreateTableResponse createTableResponse = ddbClient.createTable(createTableRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        UpdateTableRequest updateTableRequest = (UpdateTableRequest)UpdateTableRequest.builder().tableName(tableName).onDemandThroughput((software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput)software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput.builder().maxReadRequestUnits(Long.valueOf(20L)).maxWriteRequestUnits(Long.valueOf(20L)).build()).build();
        ddbClient.updateTable(updateTableRequest);
        DescribeTableRequest describeTableRequest = (DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build();
        DescribeTableResponse describeTable = ddbClient.describeTable(describeTableRequest);
        System.out.println("Describe Table v2: " + describeTable.toString());
    }

    public static void sdkV1Test(AmazonDynamoDB client) {
        String tableName = "GameScores";
        BatchExecuteStatement.createTableV1(client, tableName);
        BatchExecuteStatement.putItemsV1(client, tableName);
    }

    private static void batchExecuteStatementV1(AmazonDynamoDB client, String tableName) {
        ArrayList<com.amazonaws.services.dynamodbv2.model.BatchStatementRequest> requests = new ArrayList<com.amazonaws.services.dynamodbv2.model.BatchStatementRequest>();
        ArrayList<String> attributes1 = new ArrayList<String>();
        attributes1.add("500");
        attributes1.add("user2");
        attributes1.add("Game2");
        attributes1.add("400");
        ArrayList<com.amazonaws.services.dynamodbv2.model.AttributeValue> params1 = new ArrayList<com.amazonaws.services.dynamodbv2.model.AttributeValue>();
        for (String attribute : attributes1) {
            params1.add(new com.amazonaws.services.dynamodbv2.model.AttributeValue(attribute));
        }
        ArrayList<String> attributes2 = new ArrayList<String>();
        attributes2.add("500");
        attributes2.add("user1");
        attributes2.add("Game1");
        attributes2.add("400");
        ArrayList<com.amazonaws.services.dynamodbv2.model.AttributeValue> params2 = new ArrayList<com.amazonaws.services.dynamodbv2.model.AttributeValue>();
        for (String attribute : attributes2) {
            params2.add(new com.amazonaws.services.dynamodbv2.model.AttributeValue(attribute));
        }
        requests.add(new com.amazonaws.services.dynamodbv2.model.BatchStatementRequest().withStatement("UPDATE " + tableName + " SET Score = ? WHERE UserId = ? AND GameTitle = ? AND Sample = ?").withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD).withParameters(params1));
        requests.add(new com.amazonaws.services.dynamodbv2.model.BatchStatementRequest().withStatement("UPDATE " + tableName + " SET Score = ? WHERE UserId = ? AND GameTitle = ? AND Sample = ?").withParameters(params2));
        BatchExecuteStatementResult response = client.batchExecuteStatement(new BatchExecuteStatementRequest().withStatements(requests));
        Map failedItem = ((BatchStatementResponse)response.getResponses().get(0)).getItem();
        System.out.println(response);
    }

    public static void putItemsV1(AmazonDynamoDB client, String tableName) {
        HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> item = new HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>();
        item.put("UserId", new com.amazonaws.services.dynamodbv2.model.AttributeValue("user1"));
        item.put("GameTitle", new com.amazonaws.services.dynamodbv2.model.AttributeValue("Game1"));
        item.put("Score", new com.amazonaws.services.dynamodbv2.model.AttributeValue("200"));
        client.putItem(tableName, item);
        item.put("UserId", new com.amazonaws.services.dynamodbv2.model.AttributeValue("user2"));
        item.put("GameTitle", new com.amazonaws.services.dynamodbv2.model.AttributeValue("Game2"));
        item.put("Score", new com.amazonaws.services.dynamodbv2.model.AttributeValue("400"));
        client.putItem(tableName, item);
    }

    public static void createTableV1(AmazonDynamoDB client, String tableName) {
        if (!client.listTables().getTableNames().contains(tableName)) {
            CreateTableRequest request = new CreateTableRequest().withTableName(tableName).withKeySchema(new com.amazonaws.services.dynamodbv2.model.KeySchemaElement[]{new com.amazonaws.services.dynamodbv2.model.KeySchemaElement().withAttributeName("UserId").withKeyType(com.amazonaws.services.dynamodbv2.model.KeyType.HASH), new com.amazonaws.services.dynamodbv2.model.KeySchemaElement().withAttributeName("GameTitle").withKeyType(com.amazonaws.services.dynamodbv2.model.KeyType.RANGE)}).withAttributeDefinitions(new com.amazonaws.services.dynamodbv2.model.AttributeDefinition[]{new com.amazonaws.services.dynamodbv2.model.AttributeDefinition().withAttributeName("UserId").withAttributeType("S"), new com.amazonaws.services.dynamodbv2.model.AttributeDefinition().withAttributeName("GameTitle").withAttributeType("S")}).withBillingMode(BillingMode.PAY_PER_REQUEST).withOnDemandThroughput(new OnDemandThroughput().withMaxReadRequestUnits(Long.valueOf(0L)).withMaxWriteRequestUnits(Long.valueOf(0L)));
            try {
                CreateTableResult createTableRequest = client.createTable(request);
                com.amazonaws.services.dynamodbv2.model.DescribeTableRequest request1 = new com.amazonaws.services.dynamodbv2.model.DescribeTableRequest().withTableName(tableName);
                DescribeTableResult describeTableRequest = client.describeTable(request1);
                System.out.println("Describe Table:" + describeTableRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args2) throws Exception {
        try {
            String tableName = "GameScoresPPR";
            DynamoDbClient clientv2Prod = (DynamoDbClient)DynamoDbClient.builder().build();
            BatchExecuteStatement.createTableV2(clientv2Prod, tableName);
            DynamoDbClient clientv2Embedded = DynamoDBEmbedded.create().dynamoDbClient();
            BatchExecuteStatement.createTableV2(clientv2Embedded, tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void scanTablev1(String tableName, AmazonDynamoDB clientv1Prod) {
        ScanRequest scanRequest1 = new ScanRequest().withTableName(tableName);
        ScanResult scanResult1 = clientv1Prod.scan(scanRequest1);
        System.out.println(scanResult1.toString());
    }
}

