/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl;

import com.amazon.ion.Decimal;
import com.amazon.ion.IntegerSize;
import com.amazon.ion.IonBufferConfiguration;
import com.amazon.ion.IonCatalog;
import com.amazon.ion.IonException;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonStruct;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.ReadOnlyValueException;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.SymbolToken;
import com.amazon.ion.Timestamp;
import com.amazon.ion.UnknownSymbolException;
import com.amazon.ion.ValueFactory;
import com.amazon.ion.impl.ImportLocation;
import com.amazon.ion.impl.IonReaderLookaheadBuffer;
import com.amazon.ion.impl.IonTypeID;
import com.amazon.ion.impl.LocalSymbolTableImports;
import com.amazon.ion.impl.ResizingPipedInputStream;
import com.amazon.ion.impl.SharedSymbolTable;
import com.amazon.ion.impl.SubstituteSymbolTable;
import com.amazon.ion.impl.SymbolTableAsStruct;
import com.amazon.ion.impl.SymbolTableReader;
import com.amazon.ion.impl.SymbolTableStructCache;
import com.amazon.ion.impl._Private_IncrementalReader;
import com.amazon.ion.impl._Private_IonConstants;
import com.amazon.ion.impl._Private_ReaderWriter;
import com.amazon.ion.impl._Private_RecyclingStack;
import com.amazon.ion.impl._Private_ScalarConversions;
import com.amazon.ion.impl._Private_SymbolToken;
import com.amazon.ion.impl._Private_Utils;
import com.amazon.ion.impl.bin.IntList;
import com.amazon.ion.impl.bin.utf8.Utf8StringDecoder;
import com.amazon.ion.impl.bin.utf8.Utf8StringDecoderPool;
import com.amazon.ion.system.IonReaderBuilder;
import com.amazon.ion.system.SimpleCatalog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class IonReaderBinaryIncremental
implements IonReader,
_Private_ReaderWriter,
_Private_IncrementalReader {
    private static final IonBufferConfiguration STANDARD_BUFFER_CONFIGURATION = IonBufferConfiguration.Builder.standard().build();
    private static final _Private_RecyclingStack.ElementFactory<ContainerInfo> CONTAINER_INFO_FACTORY = new _Private_RecyclingStack.ElementFactory<ContainerInfo>(){

        @Override
        public ContainerInfo newElement() {
            return new ContainerInfo();
        }
    };
    private static final IonBufferConfiguration[] FIXED_SIZE_CONFIGURATIONS;
    private static final int IVM_FINAL_BYTE = 234;
    private static final int HIGHEST_BIT_BITMASK = 128;
    private static final int LOWER_SEVEN_BITS_BITMASK = 127;
    private static final int LOWER_SIX_BITS_BITMASK = 63;
    private static final int VALUE_BITS_PER_UINT_BYTE = 8;
    private static final int VALUE_BITS_PER_VARUINT_BYTE = 7;
    private static final IonCatalog EMPTY_CATALOG;
    private static final int CONTAINER_STACK_INITIAL_CAPACITY = 8;
    private static final int ANNOTATIONS_LIST_INITIAL_CAPACITY = 8;
    private static final int SYMBOLS_LIST_INITIAL_CAPACITY = 128;
    private static final int VAR_INT_NEGATIVE_ZERO = 192;
    private static final int INT_SIZE_IN_BYTES = 4;
    private static final int LONG_SIZE_IN_BYTES = 8;
    private static final int MOST_SIGNIFICANT_BYTE_OF_MIN_LONG = 128;
    private static final int MOST_SIGNIFICANT_BYTE_OF_MAX_LONG = 127;
    private static final int VAR_INT_SIGN_BITMASK = 64;
    private static final int FLOAT_32_BYTE_LENGTH = 4;
    private static final LocalSymbolTableImports ION_1_0_IMPORTS;
    private final InputStream inputStream;
    private final IonReaderLookaheadBuffer lookahead;
    private final ResizingPipedInputStream buffer;
    private final _Private_ScalarConversions.ValueVariant scalarConverter;
    private final _Private_RecyclingStack<ContainerInfo> containerStack;
    private final Utf8StringDecoder utf8Decoder = (Utf8StringDecoder)Utf8StringDecoderPool.getInstance().getOrCreate();
    private final IntList annotationSids;
    private final boolean isAnnotationIteratorReuseEnabled;
    private final AnnotationIterator annotationIterator;
    private final List<String> symbols;
    private final IonCatalog catalog;
    private LocalSymbolTableImports imports = ION_1_0_IMPORTS;
    private List<SymbolToken> symbolTokensById = null;
    private SymbolTable cachedReadOnlySymbolTable = null;
    private SymbolTable symbolTableLastTransferred = null;
    private int fieldNameSid = -1;
    private int majorVersion = 1;
    private int minorVersion = 0;
    private int lobBytesRead = 0;
    private IonType valueType = null;
    private IonTypeID valueTypeID = null;
    private boolean hasAnnotations = false;
    private boolean completeValueBuffered = false;
    private int valueStartPosition = -1;
    private int valueEndPosition = -1;
    private int annotationStartPosition = -1;
    private int annotationEndPosition = -1;
    private int peekIndex = -1;
    private final byte[][] scratchForSize = new byte[][]{new byte[0], new byte[1], new byte[2], new byte[3], new byte[4], new byte[5], new byte[6], new byte[7], new byte[8], new byte[9], new byte[10], new byte[11], new byte[12]};
    private static final Iterator<String> EMPTY_ITERATOR;

    private static int logBase2(int value) {
        return 32 - Integer.numberOfLeadingZeros(value == 0 ? 0 : value - 1);
    }

    IonReaderBinaryIncremental(IonReaderBuilder builder, InputStream inputStream) {
        this.inputStream = inputStream;
        IonCatalog ionCatalog = this.catalog = builder.getCatalog() == null ? EMPTY_CATALOG : builder.getCatalog();
        if (builder.isAnnotationIteratorReuseEnabled()) {
            this.isAnnotationIteratorReuseEnabled = true;
            this.annotationIterator = new AnnotationIterator();
        } else {
            this.isAnnotationIteratorReuseEnabled = false;
            this.annotationIterator = null;
        }
        IonBufferConfiguration configuration = builder.getBufferConfiguration();
        if (configuration == null) {
            configuration = STANDARD_BUFFER_CONFIGURATION;
            if (inputStream instanceof ByteArrayInputStream) {
                int fixedBufferSize;
                try {
                    fixedBufferSize = inputStream.available();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                if (configuration.getInitialBufferSize() > fixedBufferSize) {
                    configuration = FIXED_SIZE_CONFIGURATIONS[IonReaderBinaryIncremental.logBase2(fixedBufferSize)];
                }
            }
        }
        this.lookahead = new IonReaderLookaheadBuffer(configuration, inputStream);
        this.buffer = (ResizingPipedInputStream)this.lookahead.getPipe();
        this.containerStack = new _Private_RecyclingStack<ContainerInfo>(8, CONTAINER_INFO_FACTORY);
        this.annotationSids = new IntList(8);
        this.symbols = new ArrayList<String>(128);
        this.scalarConverter = new _Private_ScalarConversions.ValueVariant();
        this.resetImports();
    }

    private SymbolTable getSystemSymbolTable() {
        return SharedSymbolTable.getSystemSymbolTable(this.majorVersion);
    }

    private void requireSupportedIonVersion() {
        if (this.majorVersion != 1 || this.minorVersion != 0) {
            throw new IonException(String.format("Unsupported Ion version: %d.%d", this.majorVersion, this.minorVersion));
        }
    }

    private void resetSymbolTable() {
        this.symbols.clear();
        this.cachedReadOnlySymbolTable = null;
        if (this.symbolTokensById != null) {
            this.symbolTokensById.clear();
        }
    }

    private void resetAnnotations() {
        this.hasAnnotations = false;
        if (this.isAnnotationIteratorReuseEnabled) {
            this.annotationIterator.invalidate();
        }
    }

    private void resetImports() {
        this.imports = ION_1_0_IMPORTS;
    }

    private SymbolTable createImport(String name, int version, int maxId) {
        SymbolTable shared = this.catalog.getTable(name, version);
        if (shared == null) {
            return new SubstituteSymbolTable(name, version, maxId);
        }
        if (shared.getMaxId() != maxId || shared.getVersion() != version) {
            return new SubstituteSymbolTable(shared, version, maxId);
        }
        return shared;
    }

    private String getSymbolString(int sid, LocalSymbolTableImports importedSymbols, List<String> localSymbols) {
        if (sid <= importedSymbols.getMaxId()) {
            return importedSymbols.findKnownSymbol(sid);
        }
        return localSymbols.get(sid - (importedSymbols.getMaxId() + 1));
    }

    private int maxSymbolId() {
        return this.symbols.size() + this.imports.getMaxId();
    }

    private String getSymbol(int sid) {
        if (sid > this.maxSymbolId()) {
            throw new IonException("Symbol ID exceeds the max ID of the symbol table.");
        }
        return this.getSymbolString(sid, this.imports, this.symbols);
    }

    private SymbolToken getSymbolToken(int sid) {
        int symbolTableSize = this.maxSymbolId() + 1;
        if (this.symbolTokensById == null) {
            this.symbolTokensById = new ArrayList<SymbolToken>(symbolTableSize);
        }
        if (this.symbolTokensById.size() < symbolTableSize) {
            for (int i = this.symbolTokensById.size(); i < symbolTableSize; ++i) {
                this.symbolTokensById.add(null);
            }
        }
        if (sid >= symbolTableSize) {
            throw new IonException("Symbol ID exceeds the max ID of the symbol table.");
        }
        SymbolToken token = this.symbolTokensById.get(sid);
        if (token == null) {
            String text = this.getSymbolString(sid, this.imports, this.symbols);
            ImportLocation importLocation = null;
            if (text == null) {
                if (sid > 0 && sid <= this.imports.getMaxId()) {
                    importLocation = this.imports.getImportLocation(sid);
                } else {
                    sid = 0;
                }
            }
            token = new SymbolTokenImpl(text, sid, importLocation);
            this.symbolTokensById.set(sid, token);
        }
        return token;
    }

    private void readSymbolTable(IonReaderLookaheadBuffer.Marker marker) {
        this.peekIndex = marker.startIndex;
        boolean isAppend = false;
        boolean hasSeenImports = false;
        boolean hasSeenSymbols = false;
        int symbolsPosition = -1;
        int symbolsEndPosition = -1;
        while (this.peekIndex < marker.endIndex) {
            this.fieldNameSid = this.readVarUInt();
            IonTypeID typeID = this.readTypeId();
            this.calculateEndPosition(typeID);
            int currentValueEndPosition = this.valueEndPosition;
            if (this.fieldNameSid == 6) {
                if (hasSeenImports) {
                    throw new IonException("Symbol table contained multiple imports fields.");
                }
                if (typeID.type == IonType.SYMBOL) {
                    isAppend = this.readUInt(this.peekIndex, currentValueEndPosition) == 3L;
                    this.peekIndex = currentValueEndPosition;
                } else if (typeID.type == IonType.LIST) {
                    this.resetImports();
                    ArrayList<SymbolTable> newImports = new ArrayList<SymbolTable>(3);
                    newImports.add(this.getSystemSymbolTable());
                    this.stepIn();
                    IonType type = this.next();
                    while (type != null) {
                        String name = null;
                        int version = -1;
                        int maxId = -1;
                        if (type == IonType.STRUCT) {
                            this.stepIn();
                            type = this.next();
                            while (type != null) {
                                int fieldSid = this.getFieldId();
                                if (fieldSid == 4) {
                                    if (type == IonType.STRING) {
                                        name = this.stringValue();
                                    }
                                } else if (fieldSid == 5) {
                                    if (type == IonType.INT) {
                                        version = this.intValue();
                                    }
                                } else if (fieldSid == 8 && type == IonType.INT) {
                                    maxId = this.intValue();
                                }
                                type = this.next();
                            }
                            this.stepOut();
                        }
                        newImports.add(this.createImport(name, version, maxId));
                        type = this.next();
                    }
                    this.stepOut();
                    this.imports = new LocalSymbolTableImports(newImports);
                }
                if (!isAppend) {
                    this.resetSymbolTable();
                }
                hasSeenImports = true;
            } else if (this.fieldNameSid == 7) {
                if (hasSeenSymbols) {
                    throw new IonException("Symbol table contained multiple symbols fields.");
                }
                if (typeID.type == IonType.LIST) {
                    symbolsPosition = this.peekIndex;
                    symbolsEndPosition = currentValueEndPosition;
                }
                hasSeenSymbols = true;
            }
            this.peekIndex = currentValueEndPosition;
        }
        if (this.peekIndex > marker.endIndex) {
            throw new IonException("Malformed symbol table. Child values exceeded the length declared in the header.");
        }
        if (!hasSeenImports) {
            this.resetSymbolTable();
            this.resetImports();
        }
        if (symbolsPosition > -1) {
            this.peekIndex = symbolsPosition;
            this.valueType = IonType.LIST;
            this.valueEndPosition = symbolsEndPosition;
            this.stepIn();
            while (this.next() != null) {
                if (this.valueType != IonType.STRING) {
                    this.symbols.add(null);
                    continue;
                }
                this.symbols.add(this.stringValue());
            }
            this.stepOut();
            this.peekIndex = this.valueEndPosition;
        }
    }

    private void nextAtTopLevel() {
        if (this.completeValueBuffered) {
            this.buffer.seekTo(this.valueEndPosition);
            this.completeValueBuffered = false;
        }
        try {
            this.lookahead.fillInput();
        }
        catch (Exception e) {
            throw new IonException(e);
        }
        if (this.lookahead.moreDataRequired()) {
            this.valueType = null;
            this.valueTypeID = null;
            return;
        }
        this.completeValueBuffered = true;
        if (this.lookahead.getIvmIndex() > -1) {
            this.peekIndex = this.lookahead.getIvmIndex();
            this.majorVersion = this.buffer.peek(this.peekIndex++);
            this.minorVersion = this.buffer.peek(this.peekIndex++);
            if (this.buffer.peek(this.peekIndex++) != 234) {
                throw new IonException("Invalid Ion version marker.");
            }
            this.requireSupportedIonVersion();
            this.resetSymbolTable();
            this.resetImports();
            this.lookahead.resetIvmIndex();
        } else if (this.peekIndex < 0) {
            throw new IonException("Binary Ion must start with an Ion version marker.");
        }
        List<IonReaderLookaheadBuffer.Marker> symbolTableMarkers = this.lookahead.getSymbolTableMarkers();
        if (!symbolTableMarkers.isEmpty()) {
            this.cachedReadOnlySymbolTable = null;
            for (IonReaderLookaheadBuffer.Marker symbolTableMarker : symbolTableMarkers) {
                this.readSymbolTable(symbolTableMarker);
            }
            this.lookahead.resetSymbolTableMarkers();
        }
        this.peekIndex = this.lookahead.getValueStart();
        this.hasAnnotations = this.lookahead.hasAnnotations();
        if (this.hasAnnotations) {
            if (this.peekIndex >= this.lookahead.getValueEnd()) {
                throw new IonException("Annotation wrappers without values are invalid.");
            }
            this.annotationSids.clear();
            IonReaderLookaheadBuffer.Marker annotationSidsMarker = this.lookahead.getAnnotationSidsMarker();
            this.annotationStartPosition = annotationSidsMarker.startIndex;
            this.peekIndex = this.annotationEndPosition = annotationSidsMarker.endIndex;
            this.valueTypeID = IonTypeID.TYPE_IDS[this.buffer.peek(this.peekIndex++)];
            int wrappedValueLength = this.valueTypeID.length;
            if (this.valueTypeID.variableLength) {
                wrappedValueLength = this.readVarUInt();
            }
            this.valueType = this.valueTypeID.type;
            if (this.valueType == IonTypeID.ION_TYPE_ANNOTATION_WRAPPER) {
                throw new IonException("Nested annotations are invalid.");
            }
            if (this.peekIndex + wrappedValueLength != this.lookahead.getValueEnd()) {
                throw new IonException("Mismatched annotation wrapper length.");
            }
        } else {
            this.valueTypeID = this.lookahead.getValueTid();
            this.valueType = this.valueTypeID.type;
        }
        this.valueStartPosition = this.peekIndex;
        this.valueEndPosition = this.lookahead.getValueEnd();
        this.lookahead.resetNopPadIndex();
    }

    private IonTypeID readTypeId() {
        this.valueTypeID = IonTypeID.TYPE_IDS[this.buffer.peek(this.peekIndex++)];
        if (!this.valueTypeID.isValid) {
            throw new IonException("Invalid type ID.");
        }
        this.valueType = this.valueTypeID.type;
        return this.valueTypeID;
    }

    private void calculateEndPosition(IonTypeID typeID) {
        this.valueEndPosition = typeID.variableLength ? this.readVarUInt() + this.peekIndex : typeID.length + this.peekIndex;
    }

    @Override
    public boolean hasNext() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private void endContainer() {
        this.valueType = null;
        this.valueTypeID = null;
        this.annotationStartPosition = -1;
        this.annotationEndPosition = -1;
        this.hasAnnotations = false;
    }

    private void nextBelowTopLevel() {
        if (this.peekIndex < this.valueEndPosition) {
            this.peekIndex = this.valueEndPosition;
        }
        if (this.peekIndex >= this.containerStack.peek().endPosition) {
            this.endContainer();
        } else {
            if (this.containerStack.peek().type == IonType.STRUCT) {
                this.fieldNameSid = this.readVarUInt();
            }
            IonTypeID typeID = this.readTypeId();
            while (typeID.isNopPad) {
                this.calculateEndPosition(typeID);
                this.peekIndex = this.valueEndPosition;
                if (this.peekIndex >= this.containerStack.peek().endPosition) {
                    this.endContainer();
                    return;
                }
                if (this.containerStack.peek().type == IonType.STRUCT) {
                    this.fieldNameSid = this.readVarUInt();
                }
                typeID = this.readTypeId();
            }
            this.calculateEndPosition(typeID);
            if (this.valueType == IonTypeID.ION_TYPE_ANNOTATION_WRAPPER) {
                this.hasAnnotations = true;
                this.annotationSids.clear();
                int annotationsLength = this.readVarUInt();
                this.annotationStartPosition = this.peekIndex;
                this.peekIndex = this.annotationEndPosition = this.annotationStartPosition + annotationsLength;
                typeID = this.readTypeId();
                if (typeID.isNopPad) {
                    throw new IonException("Invalid annotation wrapper: NOP pad may not occur inside an annotation wrapper.");
                }
                if (this.valueType == IonTypeID.ION_TYPE_ANNOTATION_WRAPPER) {
                    throw new IonException("Nested annotations are invalid.");
                }
                long annotationWrapperEndPosition = this.valueEndPosition;
                this.calculateEndPosition(typeID);
                if (annotationWrapperEndPosition != (long)this.valueEndPosition) {
                    throw new IonException("Invalid annotation wrapper: end of the wrapper did not match end of the value.");
                }
            } else {
                this.annotationStartPosition = -1;
                this.annotationEndPosition = -1;
                this.hasAnnotations = false;
                if (this.valueEndPosition > this.containerStack.peek().endPosition) {
                    throw new IonException("Value overflowed its container.");
                }
            }
            if (!this.valueTypeID.isValid) {
                throw new IonException("Invalid type ID.");
            }
            this.valueStartPosition = this.peekIndex;
        }
    }

    @Override
    public IonType next() {
        this.fieldNameSid = -1;
        this.lobBytesRead = 0;
        this.valueStartPosition = -1;
        this.resetAnnotations();
        if (this.containerStack.isEmpty()) {
            this.nextAtTopLevel();
        } else {
            this.nextBelowTopLevel();
        }
        if (this.valueType == IonType.STRUCT && this.valueTypeID.lowerNibble == 1 && this.valueStartPosition == this.valueEndPosition) {
            throw new IonException("Ordered struct must not be empty.");
        }
        return this.valueType;
    }

    @Override
    public void stepIn() {
        if (!IonType.isContainer(this.valueType)) {
            throw new IonException("Must be positioned on a container to step in.");
        }
        ContainerInfo containerInfo = this.containerStack.push();
        containerInfo.type = this.valueType;
        containerInfo.endPosition = this.valueEndPosition;
        this.valueType = null;
        this.valueTypeID = null;
        this.valueEndPosition = -1;
        this.fieldNameSid = -1;
        this.valueStartPosition = -1;
    }

    @Override
    public void stepOut() {
        if (this.containerStack.isEmpty()) {
            throw new IllegalStateException("Cannot step out at top level.");
        }
        ContainerInfo containerInfo = this.containerStack.pop();
        this.valueEndPosition = containerInfo.endPosition;
        this.valueType = null;
        this.valueTypeID = null;
        this.fieldNameSid = -1;
        this.valueStartPosition = -1;
    }

    @Override
    public int getDepth() {
        return this.containerStack.size();
    }

    @Override
    public SymbolTable getSymbolTable() {
        if (this.cachedReadOnlySymbolTable == null) {
            this.cachedReadOnlySymbolTable = this.symbols.size() == 0 && this.imports == ION_1_0_IMPORTS ? this.imports.getSystemSymbolTable() : new LocalSymbolTableSnapshot();
        }
        return this.cachedReadOnlySymbolTable;
    }

    @Override
    public SymbolTable pop_passed_symbol_table() {
        SymbolTable currentSymbolTable = this.getSymbolTable();
        if (currentSymbolTable == this.symbolTableLastTransferred) {
            return null;
        }
        this.symbolTableLastTransferred = currentSymbolTable;
        return this.symbolTableLastTransferred;
    }

    @Override
    public IonType getType() {
        return this.valueType;
    }

    @Override
    public IntegerSize getIntegerSize() {
        if (this.valueType != IonType.INT || this.isNullValue()) {
            return null;
        }
        if (this.valueTypeID.length < 4) {
            return IntegerSize.INT;
        }
        if (this.valueTypeID.length < 8) {
            return IntegerSize.LONG;
        }
        if (this.valueTypeID.length == 8) {
            if (this.valueTypeID.isNegativeInt) {
                int firstByte = this.buffer.peek(this.valueStartPosition);
                if (firstByte < 128) {
                    return IntegerSize.LONG;
                }
                if (firstByte > 128) {
                    return IntegerSize.BIG_INTEGER;
                }
                for (int i = this.valueStartPosition + 1; i < this.valueEndPosition; ++i) {
                    if (0 == this.buffer.peek(i)) continue;
                    return IntegerSize.BIG_INTEGER;
                }
            } else if (this.buffer.peek(this.valueStartPosition) > 127) {
                return IntegerSize.BIG_INTEGER;
            }
            return IntegerSize.LONG;
        }
        return IntegerSize.BIG_INTEGER;
    }

    private void requireType(IonType required) {
        if (required != this.valueType) {
            throw new IllegalStateException(String.format("Invalid type. Required %s but found %s.", new Object[]{required, this.valueType}));
        }
    }

    private int readVarUInt() {
        int currentByte = 0;
        int result = 0;
        while ((currentByte & 0x80) == 0) {
            currentByte = this.buffer.peek(this.peekIndex++);
            result = result << 7 | currentByte & 0x7F;
        }
        return result;
    }

    private long readUInt(int startIndex, int limit2) {
        long result = 0L;
        for (int i = startIndex; i < limit2; ++i) {
            result = result << 8 | (long)this.buffer.peek(i);
        }
        return result;
    }

    private long readUInt() {
        return this.readUInt(this.valueStartPosition, this.valueEndPosition);
    }

    private int readVarInt(int firstByte) {
        int currentByte = firstByte;
        int sign = (currentByte & 0x40) == 0 ? 1 : -1;
        int result = currentByte & 0x3F;
        while ((currentByte & 0x80) == 0) {
            currentByte = this.buffer.peek(this.peekIndex++);
            result = result << 7 | currentByte & 0x7F;
        }
        return result * sign;
    }

    private int readVarInt() {
        return this.readVarInt(this.buffer.peek(this.peekIndex++));
    }

    private byte[] copyBytesToScratch(int startIndex, int length) {
        byte[] bytes = null;
        if (length < this.scratchForSize.length) {
            bytes = this.scratchForSize[length];
        }
        if (bytes == null) {
            bytes = new byte[length];
        }
        this.buffer.copyBytes(startIndex, bytes, 0, bytes.length);
        return bytes;
    }

    private BigInteger readUIntAsBigInteger(boolean isNegative) {
        int length = this.valueEndPosition - this.valueStartPosition;
        byte[] magnitude = this.copyBytesToScratch(this.valueStartPosition, length);
        int signum = isNegative ? -1 : 1;
        return new BigInteger(signum, magnitude);
    }

    private int getAndClearSignBit(byte[] intBytes) {
        int signum;
        boolean isNegative = (intBytes[0] & 0x80) != 0;
        int n = signum = isNegative ? -1 : 1;
        if (isNegative) {
            intBytes[0] = (byte)(intBytes[0] & 0x7F);
        }
        return signum;
    }

    private BigInteger readIntAsBigInteger(int limit2) {
        BigInteger value;
        int length = limit2 - this.peekIndex;
        if (length > 0) {
            byte[] bytes = this.copyBytesToScratch(this.peekIndex, length);
            value = new BigInteger(this.getAndClearSignBit(bytes), bytes);
        } else {
            value = BigInteger.ZERO;
        }
        return value;
    }

    @Override
    public long longValue() {
        long value;
        if (this.valueType == IonType.INT) {
            if (this.valueTypeID.length == 0) {
                return 0L;
            }
            value = this.readUInt();
            if (this.valueTypeID.isNegativeInt) {
                if (value == 0L) {
                    throw new IonException("Int zero may not be negative.");
                }
                value *= -1L;
            }
        } else if (this.valueType == IonType.FLOAT) {
            this.scalarConverter.addValue(this.doubleValue());
            this.scalarConverter.setAuthoritativeType(7);
            this.scalarConverter.cast(this.scalarConverter.get_conversion_fnid(4));
            value = this.scalarConverter.getLong();
            this.scalarConverter.clear();
        } else if (this.valueType == IonType.DECIMAL) {
            this.scalarConverter.addValue(this.decimalValue());
            this.scalarConverter.setAuthoritativeType(6);
            this.scalarConverter.cast(this.scalarConverter.get_conversion_fnid(4));
            value = this.scalarConverter.getLong();
            this.scalarConverter.clear();
        } else {
            throw new IllegalStateException("longValue() may only be called on values of type int, float, or decimal.");
        }
        return value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        BigInteger value;
        if (this.valueType == IonType.INT) {
            if (this.isNullValue()) {
                return null;
            }
            if (this.valueTypeID.length == 0) {
                return BigInteger.ZERO;
            }
            value = this.readUIntAsBigInteger(this.valueTypeID.isNegativeInt);
            if (this.valueTypeID.isNegativeInt && value.signum() == 0) {
                throw new IonException("Int zero may not be negative.");
            }
        } else if (this.valueType == IonType.FLOAT) {
            if (this.isNullValue()) {
                value = null;
            } else {
                this.scalarConverter.addValue(this.doubleValue());
                this.scalarConverter.setAuthoritativeType(7);
                this.scalarConverter.cast(this.scalarConverter.get_conversion_fnid(5));
                value = this.scalarConverter.getBigInteger();
                this.scalarConverter.clear();
            }
        } else {
            throw new IllegalStateException("bigIntegerValue() may only be called on values of type int or float.");
        }
        return value;
    }

    @Override
    public Date dateValue() {
        Timestamp timestamp = this.timestampValue();
        if (timestamp == null) {
            return null;
        }
        return timestamp.dateValue();
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public double doubleValue() {
        double value;
        if (this.valueType == IonType.FLOAT) {
            int length = this.valueEndPosition - this.valueStartPosition;
            if (length == 0) {
                return 0.0;
            }
            ByteBuffer bytes = this.buffer.getByteBuffer(this.valueStartPosition, this.valueEndPosition);
            value = length == 4 ? (double)bytes.getFloat() : bytes.getDouble();
        } else if (this.valueType == IonType.DECIMAL) {
            this.scalarConverter.addValue(this.decimalValue());
            this.scalarConverter.setAuthoritativeType(6);
            this.scalarConverter.cast(this.scalarConverter.get_conversion_fnid(7));
            value = this.scalarConverter.getDouble();
            this.scalarConverter.clear();
        } else {
            throw new IllegalStateException("doubleValue() may only be called on values of type float or decimal.");
        }
        return value;
    }

    private String readString(int valueStart, int valueEnd) {
        ByteBuffer utf8InputBuffer = this.buffer.getByteBuffer(valueStart, valueEnd);
        int numberOfBytes = valueEnd - valueStart;
        return this.utf8Decoder.decode(utf8InputBuffer, numberOfBytes);
    }

    @Override
    public String stringValue() {
        String value;
        if (this.valueType == IonType.STRING) {
            if (this.isNullValue()) {
                return null;
            }
            value = this.readString(this.valueStartPosition, this.valueEndPosition);
        } else if (this.valueType == IonType.SYMBOL) {
            if (this.isNullValue()) {
                return null;
            }
            int sid = (int)this.readUInt();
            value = this.getSymbol(sid);
            if (value == null) {
                throw new UnknownSymbolException(sid);
            }
        } else {
            throw new IllegalStateException("Invalid type requested.");
        }
        return value;
    }

    @Override
    public SymbolToken symbolValue() {
        this.requireType(IonType.SYMBOL);
        if (this.isNullValue()) {
            return null;
        }
        int sid = (int)this.readUInt();
        return this.getSymbolToken(sid);
    }

    @Override
    public int byteSize() {
        if (!IonType.isLob(this.valueType) && !this.isNullValue()) {
            throw new IonException("Reader must be positioned on a blob or clob.");
        }
        return this.valueEndPosition - this.valueStartPosition;
    }

    @Override
    public byte[] newBytes() {
        byte[] bytes = new byte[this.byteSize()];
        this.buffer.copyBytes(this.valueStartPosition, bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public int getBytes(byte[] bytes, int offset, int len) {
        int length = Math.min(len, this.byteSize() - this.lobBytesRead);
        this.buffer.copyBytes(this.valueStartPosition + this.lobBytesRead, bytes, offset, length);
        this.lobBytesRead += length;
        return length;
    }

    private BigDecimal readBigDecimal() {
        BigDecimal value;
        int length = this.valueEndPosition - this.peekIndex;
        if (length == 0) {
            return BigDecimal.ZERO;
        }
        int scale = -this.readVarInt();
        if (length < 8) {
            long coefficient = 0L;
            int sign = 1;
            if (this.peekIndex < this.valueEndPosition) {
                int firstByte;
                sign = ((firstByte = this.buffer.peek(this.peekIndex++)) & 0x80) == 0 ? 1 : -1;
                coefficient = firstByte & 0x7F;
            }
            while (this.peekIndex < this.valueEndPosition) {
                coefficient = coefficient << 8 | (long)this.buffer.peek(this.peekIndex++);
            }
            value = BigDecimal.valueOf(coefficient * (long)sign, scale);
        } else {
            value = new BigDecimal(this.readIntAsBigInteger(this.valueEndPosition), scale);
        }
        return value;
    }

    private Decimal readDecimal() {
        BigInteger coefficient;
        int length = this.valueEndPosition - this.peekIndex;
        if (length == 0) {
            return Decimal.ZERO;
        }
        int scale = -this.readVarInt();
        length = this.valueEndPosition - this.peekIndex;
        if (length > 0) {
            byte[] bits = this.copyBytesToScratch(this.peekIndex, length);
            int signum = this.getAndClearSignBit(bits);
            coefficient = new BigInteger(signum, bits);
            if (coefficient.signum() == 0 && signum < 0) {
                return Decimal.negativeZero(scale);
            }
        } else {
            coefficient = BigInteger.ZERO;
        }
        return Decimal.valueOf(coefficient, scale);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        this.requireType(IonType.DECIMAL);
        if (this.isNullValue()) {
            return null;
        }
        this.peekIndex = this.valueStartPosition;
        return this.readBigDecimal();
    }

    @Override
    public Decimal decimalValue() {
        this.requireType(IonType.DECIMAL);
        if (this.isNullValue()) {
            return null;
        }
        this.peekIndex = this.valueStartPosition;
        return this.readDecimal();
    }

    @Override
    public Timestamp timestampValue() {
        this.requireType(IonType.TIMESTAMP);
        if (this.isNullValue()) {
            return null;
        }
        this.peekIndex = this.valueStartPosition;
        int firstByte = this.buffer.peek(this.peekIndex++);
        Integer offset = null;
        if (firstByte != 192) {
            offset = this.readVarInt(firstByte);
        }
        int year2 = this.readVarUInt();
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        BigDecimal fractionalSecond = null;
        Timestamp.Precision precision = Timestamp.Precision.YEAR;
        if (this.peekIndex < this.valueEndPosition) {
            month = this.readVarUInt();
            precision = Timestamp.Precision.MONTH;
            if (this.peekIndex < this.valueEndPosition) {
                day = this.readVarUInt();
                precision = Timestamp.Precision.DAY;
                if (this.peekIndex < this.valueEndPosition) {
                    hour = this.readVarUInt();
                    if (this.peekIndex >= this.valueEndPosition) {
                        throw new IonException("Timestamps may not specify hour without specifying minute.");
                    }
                    minute = this.readVarUInt();
                    precision = Timestamp.Precision.MINUTE;
                    if (this.peekIndex < this.valueEndPosition) {
                        second = this.readVarUInt();
                        precision = Timestamp.Precision.SECOND;
                        if (this.peekIndex < this.valueEndPosition && ((fractionalSecond = this.readBigDecimal()).signum() < 0 || fractionalSecond.compareTo(BigDecimal.ONE) >= 0)) {
                            throw new IonException("The fractional seconds value in a timestamp must be greaterthan or equal to zero and less than one.");
                        }
                    }
                }
            }
        }
        try {
            return Timestamp.createFromUtcFields(precision, year2, month, day, hour, minute, second, fractionalSecond, offset);
        }
        catch (IllegalArgumentException e) {
            throw new IonException("Illegal timestamp encoding. ", e);
        }
    }

    private IntList getAnnotationSids() {
        if (this.annotationSids.isEmpty()) {
            int savedPeekIndex = this.peekIndex;
            this.peekIndex = this.annotationStartPosition;
            while (this.peekIndex < this.annotationEndPosition) {
                this.annotationSids.add(this.readVarUInt());
            }
            this.peekIndex = savedPeekIndex;
        }
        return this.annotationSids;
    }

    @Override
    public String[] getTypeAnnotations() {
        if (this.hasAnnotations) {
            IntList annotationSids = this.getAnnotationSids();
            String[] annotationArray = new String[annotationSids.size()];
            for (int i = 0; i < annotationArray.length; ++i) {
                String symbol = this.getSymbol(annotationSids.get(i));
                if (symbol == null) {
                    throw new UnknownSymbolException(annotationSids.get(i));
                }
                annotationArray[i] = symbol;
            }
            return annotationArray;
        }
        return _Private_Utils.EMPTY_STRING_ARRAY;
    }

    @Override
    public SymbolToken[] getTypeAnnotationSymbols() {
        if (this.hasAnnotations) {
            IntList annotationSids = this.getAnnotationSids();
            SymbolToken[] annotationArray = new SymbolToken[annotationSids.size()];
            for (int i = 0; i < annotationArray.length; ++i) {
                annotationArray[i] = this.getSymbolToken(annotationSids.get(i));
            }
            return annotationArray;
        }
        return SymbolToken.EMPTY_ARRAY;
    }

    @Override
    public Iterator<String> iterateTypeAnnotations() {
        if (this.hasAnnotations) {
            if (this.isAnnotationIteratorReuseEnabled) {
                this.annotationIterator.ready();
                return this.annotationIterator;
            }
            return new SingleUseAnnotationIterator();
        }
        return EMPTY_ITERATOR;
    }

    @Override
    public int getFieldId() {
        return this.fieldNameSid;
    }

    @Override
    public String getFieldName() {
        if (this.fieldNameSid < 0) {
            return null;
        }
        String fieldName = this.getSymbol(this.fieldNameSid);
        if (fieldName == null) {
            throw new UnknownSymbolException(this.fieldNameSid);
        }
        return fieldName;
    }

    @Override
    public SymbolToken getFieldNameSymbol() {
        if (this.fieldNameSid < 0) {
            return null;
        }
        return this.getSymbolToken(this.fieldNameSid);
    }

    @Override
    public boolean isNullValue() {
        return this.valueTypeID != null && this.valueTypeID.isNull;
    }

    @Override
    public boolean isInStruct() {
        return !this.containerStack.isEmpty() && this.containerStack.peek().type == IonType.STRUCT;
    }

    @Override
    public boolean booleanValue() {
        this.requireType(IonType.BOOL);
        return this.valueTypeID.lowerNibble == 1;
    }

    @Override
    public <T> T asFacet(Class<T> facetType) {
        return null;
    }

    @Override
    public void requireCompleteValue() {
        if (this.lookahead.isSkippingCurrentValue()) {
            throw new IonException("Unexpected EOF.");
        }
        if (this.lookahead.available() > 0 && this.lookahead.moreDataRequired() && (this.lookahead.getIvmIndex() < 0 || this.lookahead.available() != _Private_IonConstants.BINARY_VERSION_MARKER_SIZE)) {
            throw new IonException("Unexpected EOF.");
        }
    }

    @Override
    public void close() throws IOException {
        this.requireCompleteValue();
        this.inputStream.close();
        this.utf8Decoder.close();
    }

    static {
        int maxBufferSizeExponent = IonReaderBinaryIncremental.logBase2(STANDARD_BUFFER_CONFIGURATION.getInitialBufferSize());
        FIXED_SIZE_CONFIGURATIONS = new IonBufferConfiguration[maxBufferSizeExponent + 1];
        for (int i = 0; i <= maxBufferSizeExponent; ++i) {
            int size = Math.max(8, (int)Math.pow(2.0, i));
            IonReaderBinaryIncremental.FIXED_SIZE_CONFIGURATIONS[i] = ((IonBufferConfiguration.Builder)((IonBufferConfiguration.Builder)IonBufferConfiguration.Builder.from(STANDARD_BUFFER_CONFIGURATION).withInitialBufferSize(size)).withMaximumBufferSize(size)).build();
        }
        EMPTY_CATALOG = new SimpleCatalog();
        ION_1_0_IMPORTS = new LocalSymbolTableImports(SharedSymbolTable.getSystemSymbolTable(1), new SymbolTable[0]);
        EMPTY_ITERATOR = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public String next() {
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove from an empty iterator.");
            }
        };
    }

    private class LocalSymbolTableSnapshot
    implements SymbolTable,
    SymbolTableAsStruct {
        private final SymbolTable system;
        private final int maxId;
        private final LocalSymbolTableImports importedTables;
        final Map<String, Integer> mapView;
        final List<String> listView;
        private SymbolTableStructCache structCache;

        LocalSymbolTableSnapshot() {
            this.system = IonReaderBinaryIncremental.this.getSystemSymbolTable();
            this.structCache = null;
            int importsMaxId = IonReaderBinaryIncremental.this.imports.getMaxId();
            int numberOfLocalSymbols = IonReaderBinaryIncremental.this.symbols.size();
            this.importedTables = IonReaderBinaryIncremental.this.imports;
            this.maxId = importsMaxId + numberOfLocalSymbols;
            this.listView = new ArrayList<String>(IonReaderBinaryIncremental.this.symbols.subList(0, numberOfLocalSymbols));
            this.mapView = new HashMap<String, Integer>((int)Math.ceil((double)numberOfLocalSymbols / 0.75), 0.75f);
            for (int i = 0; i < numberOfLocalSymbols; ++i) {
                String symbol = this.listView.get(i);
                if (symbol == null) continue;
                this.mapView.put(symbol, i + importsMaxId + 1);
            }
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public boolean isLocalTable() {
            return true;
        }

        @Override
        public boolean isSharedTable() {
            return false;
        }

        @Override
        public boolean isSubstitute() {
            return false;
        }

        @Override
        public boolean isSystemTable() {
            return false;
        }

        @Override
        public SymbolTable getSystemSymbolTable() {
            return this.system;
        }

        @Override
        public String getIonVersionId() {
            return this.system.getIonVersionId();
        }

        @Override
        public SymbolTable[] getImportedTables() {
            return this.importedTables.getImportedTables();
        }

        @Override
        public int getImportedMaxId() {
            return this.importedTables.getMaxId();
        }

        @Override
        public SymbolToken find(String text) {
            SymbolToken token = this.importedTables.find(text);
            if (token != null) {
                return token;
            }
            Integer sid = this.mapView.get(text);
            if (sid == null) {
                return null;
            }
            return new SymbolTokenImpl(text, sid, null);
        }

        @Override
        public int findSymbol(String name) {
            Integer sid = this.importedTables.findSymbol(name);
            if (sid > -1) {
                return sid;
            }
            sid = this.mapView.get(name);
            if (sid == null) {
                return -1;
            }
            return sid;
        }

        @Override
        public String findKnownSymbol(int id) {
            if (id < 0) {
                throw new IllegalArgumentException("Symbol IDs must be at least 0.");
            }
            if (id > this.getMaxId()) {
                return null;
            }
            return IonReaderBinaryIncremental.this.getSymbolString(id, this.importedTables, this.listView);
        }

        @Override
        public Iterator<String> iterateDeclaredSymbolNames() {
            return new Iterator<String>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < LocalSymbolTableSnapshot.this.listView.size();
                }

                @Override
                public String next() {
                    String symbol = LocalSymbolTableSnapshot.this.listView.get(this.index);
                    ++this.index;
                    return symbol;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("This iterator does not support element removal.");
                }
            };
        }

        @Override
        public SymbolToken intern(String text) {
            SymbolToken token = this.find(text);
            if (token != null) {
                return token;
            }
            throw new ReadOnlyValueException();
        }

        @Override
        public int getMaxId() {
            return this.maxId;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void makeReadOnly() {
        }

        @Override
        public void writeTo(IonWriter writer) throws IOException {
            SymbolTableReader reader = new SymbolTableReader(this);
            writer.writeValues(reader);
        }

        public String toString() {
            return "(LocalSymbolTable max_id:" + this.getMaxId() + ')';
        }

        @Override
        public IonStruct getIonRepresentation(ValueFactory valueFactory) {
            if (this.structCache == null) {
                this.structCache = new SymbolTableStructCache(this, this.getImportedTables(), null);
            }
            return this.structCache.getIonRepresentation(valueFactory);
        }
    }

    static class SymbolTokenImpl
    implements _Private_SymbolToken {
        private final String text;
        private final int sid;
        private final ImportLocation importLocation;

        SymbolTokenImpl(String text, int sid, ImportLocation importLocation) {
            this.text = text;
            this.sid = sid;
            this.importLocation = importLocation;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public String assumeText() {
            if (this.text == null) {
                throw new UnknownSymbolException(this.sid);
            }
            return this.text;
        }

        @Override
        public int getSid() {
            return this.sid;
        }

        public ImportLocation getImportLocation() {
            return this.importLocation;
        }

        public String toString() {
            return String.format("SymbolToken::{text: %s, sid: %d, importLocation: %s}", this.text, this.sid, this.importLocation);
        }

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof SymbolToken)) {
                return false;
            }
            SymbolToken other = (SymbolToken)o2;
            if (this.getText() == null || other.getText() == null) {
                return this.getText() == other.getText();
            }
            return this.getText().equals(other.getText());
        }

        @Override
        public int hashCode() {
            if (this.getText() != null) {
                return this.getText().hashCode();
            }
            return 0;
        }
    }

    private class SingleUseAnnotationIterator
    implements Iterator<String> {
        private final IntList annotationSids;
        private int index = 0;

        SingleUseAnnotationIterator() {
            this.annotationSids = new IntList(IonReaderBinaryIncremental.this.getAnnotationSids());
        }

        @Override
        public boolean hasNext() {
            return this.index < this.annotationSids.size();
        }

        @Override
        public String next() {
            int sid = this.annotationSids.get(this.index);
            String annotation = IonReaderBinaryIncremental.this.getSymbol(sid);
            if (annotation == null) {
                throw new UnknownSymbolException(sid);
            }
            ++this.index;
            return annotation;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support element removal.");
        }
    }

    private class AnnotationIterator
    implements Iterator<String> {
        private int nextAnnotationPeekIndex;

        private AnnotationIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.nextAnnotationPeekIndex < IonReaderBinaryIncremental.this.annotationEndPosition;
        }

        @Override
        public String next() {
            int savedPeekIndex = IonReaderBinaryIncremental.this.peekIndex;
            IonReaderBinaryIncremental.this.peekIndex = this.nextAnnotationPeekIndex;
            int sid = IonReaderBinaryIncremental.this.readVarUInt();
            this.nextAnnotationPeekIndex = IonReaderBinaryIncremental.this.peekIndex;
            IonReaderBinaryIncremental.this.peekIndex = savedPeekIndex;
            String annotation = IonReaderBinaryIncremental.this.getSymbol(sid);
            if (annotation == null) {
                throw new UnknownSymbolException(sid);
            }
            return annotation;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support element removal.");
        }

        void ready() {
            this.nextAnnotationPeekIndex = IonReaderBinaryIncremental.this.annotationStartPosition;
        }

        void invalidate() {
            this.nextAnnotationPeekIndex = Integer.MAX_VALUE;
        }
    }

    private static class SystemSymbolIDs {
        private static final int ION_SYMBOL_TABLE_ID = 3;
        private static final int NAME_ID = 4;
        private static final int VERSION_ID = 5;
        private static final int IMPORTS_ID = 6;
        private static final int SYMBOLS_ID = 7;
        private static final int MAX_ID_ID = 8;

        private SystemSymbolIDs() {
        }
    }

    private static class ContainerInfo {
        private IonType type;
        private int endPosition;

        private ContainerInfo() {
        }
    }
}

