/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl;

import com.amazon.ion.IonType;

final class IonTypeID {
    private static final int NUMBER_OF_BYTES = 256;
    private static final int BITS_PER_NIBBLE = 4;
    private static final int LOW_NIBBLE_BITMASK = 15;
    private static final int NULL_VALUE_NIBBLE = 15;
    private static final int VARIABLE_LENGTH_NIBBLE = 14;
    private static final int NEGATIVE_INT_TYPE_CODE = 3;
    private static final int TYPE_CODE_INVALID = 15;
    private static final int ANNOTATION_WRAPPER_MIN_LENGTH = 3;
    private static final int ANNOTATION_WRAPPER_MAX_LENGTH = 14;
    static final int ORDERED_STRUCT_NIBBLE = 1;
    static final IonType ION_TYPE_ANNOTATION_WRAPPER = IonType.DATAGRAM;
    static final IonType[] ION_TYPES = new IonType[]{IonType.NULL, IonType.BOOL, IonType.INT, IonType.INT, IonType.FLOAT, IonType.DECIMAL, IonType.TIMESTAMP, IonType.SYMBOL, IonType.STRING, IonType.CLOB, IonType.BLOB, IonType.LIST, IonType.SEXP, IonType.STRUCT, ION_TYPE_ANNOTATION_WRAPPER, null};
    static final IonTypeID[] TYPE_IDS = new IonTypeID[256];
    final IonType type;
    final byte length;
    final boolean variableLength;
    final boolean isNull;
    final boolean isNopPad;
    final byte lowerNibble;
    final boolean isValid;
    final boolean isNegativeInt;

    private static boolean isValid(byte upperNibble, byte lowerNibble, IonType type) {
        if (upperNibble == 15) {
            return false;
        }
        if (type == IonType.BOOL) {
            return lowerNibble <= 1 || lowerNibble == 15;
        }
        if (type == IonType.INT && upperNibble == 3) {
            return lowerNibble != 0;
        }
        if (type == IonType.FLOAT) {
            return lowerNibble == 0 || lowerNibble == 4 || lowerNibble == 8 || lowerNibble == 15;
        }
        if (type == IonType.TIMESTAMP) {
            return lowerNibble > 1;
        }
        if (type == ION_TYPE_ANNOTATION_WRAPPER) {
            return lowerNibble >= 3 && lowerNibble <= 14;
        }
        return true;
    }

    private IonTypeID(byte id) {
        byte upperNibble = (byte)(id >> 4 & 0xF);
        this.lowerNibble = (byte)(id & 0xF);
        this.type = ION_TYPES[upperNibble];
        this.isValid = IonTypeID.isValid(upperNibble, this.lowerNibble, this.type);
        this.isNull = this.lowerNibble == 15;
        this.isNopPad = this.type == IonType.NULL && !this.isNull;
        byte length = this.lowerNibble;
        if (this.type == IonType.NULL && !this.isNopPad || this.type == IonType.BOOL || !this.isValid) {
            this.variableLength = false;
            length = 0;
        } else if (this.type == IonType.STRUCT && length == 1) {
            this.variableLength = true;
        } else {
            boolean bl = this.variableLength = length == 14;
        }
        if (this.isNull) {
            length = 0;
        }
        this.isNegativeInt = this.type == IonType.INT && upperNibble == 3;
        this.length = length;
    }

    static {
        for (int b = 0; b < 256; ++b) {
            IonTypeID.TYPE_IDS[b] = new IonTypeID((byte)b);
        }
    }
}

