/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.core.ServerVersion;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class Utils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Charset utf8Charset = Charset.forName("UTF-8");

    public static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte element : data) {
            sb.append(Integer.toHexString(element >> 4 & 0xF));
            sb.append(Integer.toHexString(element & 0xF));
        }
        return sb.toString();
    }

    public static byte[] encodeUTF8(String str) {
        return str.getBytes(utf8Charset);
    }

    public static StringBuilder escapeLiteral(StringBuilder sbuf, String value, boolean standardConformingStrings, boolean onlyQuotes) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder((value.length() + 10) / 10 * 11);
        }
        Utils.doAppendEscapedLiteral(sbuf, value, standardConformingStrings, onlyQuotes);
        return sbuf;
    }

    public static StringBuilder escapeLiteral(StringBuilder sbuf, String value, boolean standardConformingStrings) throws SQLException {
        return Utils.escapeLiteral(sbuf, value, standardConformingStrings, false);
    }

    private static void doAppendEscapedLiteral(Appendable sbuf, String value, boolean standardConformingStrings, boolean onlyQuote) throws SQLException {
        try {
            if (standardConformingStrings) {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if (ch == '\u0000') {
                        throw new RedshiftException(GT.tr("Zero bytes may not occur in string parameters.", new Object[0]), RedshiftState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch == '\'') {
                        sbuf.append('\'');
                    }
                    sbuf.append(ch);
                }
            } else {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if (ch == '\u0000') {
                        throw new RedshiftException(GT.tr("Zero bytes may not occur in string parameters.", new Object[0]), RedshiftState.INVALID_PARAMETER_VALUE);
                    }
                    if (onlyQuote) {
                        if (ch == '\'') {
                            sbuf.append(ch);
                        }
                    } else if (ch == '\\' || ch == '\'') {
                        sbuf.append(ch);
                    }
                    sbuf.append(ch);
                }
            }
        }
        catch (IOException e) {
            throw new RedshiftException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
        }
    }

    public static StringBuilder escapeIdentifier(StringBuilder sbuf, String value) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder(2 + (value.length() + 10) / 10 * 11);
        }
        Utils.doAppendEscapedIdentifier(sbuf, value);
        return sbuf;
    }

    private static void doAppendEscapedIdentifier(Appendable sbuf, String value) throws SQLException {
        try {
            sbuf.append('\"');
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\u0000') {
                    throw new RedshiftException(GT.tr("Zero bytes may not occur in identifiers.", new Object[0]), RedshiftState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\"') {
                    sbuf.append(ch);
                }
                sbuf.append(ch);
            }
            sbuf.append('\"');
        }
        catch (IOException e) {
            throw new RedshiftException(GT.tr("No IOException expected from StringBuffer or StringBuilder", new Object[0]), RedshiftState.UNEXPECTED_ERROR, (Throwable)e);
        }
    }

    @Deprecated
    public static int parseServerVersionStr(String serverVersion) throws NumberFormatException {
        return ServerVersion.parseServerVersionStr(serverVersion);
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static JsonNode parseJson(String json) throws JsonProcessingException {
        return OBJECT_MAPPER.readTree(json);
    }
}

