/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.SamlCredentialsProvider;
import com.amazonaws.SdkClientException;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class OktaCredentialsProvider
extends SamlCredentialsProvider {
    private static final String KEY_APP_URL = "app_id";
    private static final String KEY_APP_NAME = "app_name";
    protected String m_app_id;
    protected String m_app_name;

    @Override
    public void addParameter(String key, String value) {
        super.addParameter(key, value);
        if (KEY_APP_URL.equalsIgnoreCase(key)) {
            this.m_app_id = value;
        }
        if (KEY_APP_NAME.equalsIgnoreCase(key)) {
            this.m_app_name = value;
        }
    }

    @Override
    protected String getSamlAssertion() throws IOException {
        this.checkRequiredParameters();
        if (StringUtils.isNullOrEmpty((String)this.m_app_id)) {
            throw new IOException("Missing required property: app_id");
        }
        CloseableHttpClient httpClient = null;
        try {
            httpClient = this.getHttpClient();
            String strOktaSessionToken = this.oktaAuthentication(httpClient);
            String string = this.handleSamlAssertion(httpClient, strOktaSessionToken);
            return string;
        }
        catch (GeneralSecurityException e) {
            throw new SdkClientException("Failed create SSLContext.", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)httpClient, null);
        }
    }

    private String oktaAuthentication(CloseableHttpClient httpClient) throws IOException {
        block5: {
            String string;
            CloseableHttpResponse responseAuthenticate = null;
            try {
                ObjectMapper mapper = new ObjectMapper();
                String uri = "https://" + this.m_idpHost + "/api/v1/authn";
                if (RedshiftLogger.isEnable()) {
                    this.m_log.logDebug("uri: {0}", uri);
                }
                HttpPost httpost = new HttpPost(uri);
                httpost.addHeader("Accept", "application/json");
                httpost.addHeader("Content-Type", "application/json");
                httpost.addHeader("Cache-Control", "no-cache");
                HashMap<String, String> creds = new HashMap<String, String>();
                creds.put("username", this.m_userName);
                creds.put("password", this.m_password);
                StringWriter writer = new StringWriter();
                mapper.writeValue((Writer)writer, creds);
                StringEntity entity = new StringEntity(writer.toString(), "UTF-8");
                entity.setContentType("application/json");
                httpost.setEntity((HttpEntity)entity);
                responseAuthenticate = httpClient.execute((HttpUriRequest)httpost);
                StatusLine statusLine = responseAuthenticate.getStatusLine();
                int requestStatus = statusLine.getStatusCode();
                if (requestStatus != 200) {
                    throw new IOException(statusLine.getReasonPhrase());
                }
                JsonNode json = mapper.readTree(EntityUtils.toString((HttpEntity)responseAuthenticate.getEntity()));
                if (!"SUCCESS".equals(json.get("status").asText())) break block5;
                string = json.get("sessionToken").asText();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(responseAuthenticate, null);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)responseAuthenticate, null);
            return string;
        }
        throw new IOException("No session token in the response.");
    }

    private String handleSamlAssertion(CloseableHttpClient httpClient, String oktaSessionToken) throws IOException {
        HttpGet httpget;
        CloseableHttpResponse responseSAML;
        int requestStatus;
        this.m_app_name = StringUtils.isNullOrEmpty((String)this.m_app_name) ? "amazon_aws" : URLEncoder.encode(this.m_app_name, "UTF-8");
        String oktaAWSAppUrl = "https://" + this.m_idpHost + "/home/" + this.m_app_name + "/" + this.m_app_id;
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("oktaAWSAppUrl: {0}", oktaAWSAppUrl);
        }
        if ((requestStatus = (responseSAML = httpClient.execute((HttpUriRequest)(httpget = new HttpGet(oktaAWSAppUrl + "?onetimetoken=" + oktaSessionToken)))).getStatusLine().getStatusCode()) != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + responseSAML.getStatusLine().getStatusCode() + " : Reason : " + responseSAML.getStatusLine().getReasonPhrase());
        }
        String body = EntityUtils.toString((HttpEntity)responseSAML.getEntity());
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("body: {0}", body);
        }
        for (String inputTags : this.getInputTagsfromHTML(body)) {
            String name = this.getValueByKey(inputTags, "name");
            String value = this.getValueByKey(inputTags, "value");
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("name: {0}", name);
            }
            if (!"SAMLResponse".equalsIgnoreCase(name)) continue;
            return value.replace("&#x2b;", "+").replace("&#x3d;", "=");
        }
        throw new IOException("Failed to retrieve SAMLAssertion.");
    }
}

