/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.impl.DSIErrorResult;
import com.amazon.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResults;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCDriver;
import com.amazon.redshift.exceptions.PGJDBCMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

public class PGMultipleParameterSetsExecutionResults
extends ExecutionResults {
    private final ILogger m_log;

    public PGMultipleParameterSetsExecutionResults(List<PGMessagingContext> contexts, ILogger logger, int socketTimeoutMS) throws ErrorException {
        this.m_log = logger;
        int totalExecutions = contexts.get((int)0).m_batchCount;
        for (int batchIndex = 0; batchIndex < totalExecutions; ++batchIndex) {
            long totalRowCount = 0L;
            for (PGMessagingContext current : contexts) {
                try {
                    boolean resultAdded = false;
                    while (!resultAdded) {
                        try {
                            IInboundMessage peeked;
                            if (current.m_totalMessageCount > current.m_currentMessageCount && (peeked = current.peekNextMessage(socketTimeoutMS)) instanceof ErrorResponse) {
                                current.getErrorResponse();
                            }
                            if (current.m_isPreparedStatement && null == current.m_readyForQueryFromPipelineForPrepare) {
                                current.getReadyForQuery();
                            }
                            CommandComplete commandComplete = null;
                            while (current.m_multipleParameterSetsCommandComplete.size() < batchIndex + 1 || null == (commandComplete = current.m_multipleParameterSetsCommandComplete.get(batchIndex))) {
                                current.doMoveToNextClass(CommandComplete.class);
                            }
                            long currentUpdateCount = commandComplete.getNumRows();
                            if (this.m_log.isEnabled()) {
                                LogUtilities.logDebug("Parameter Set idx " + batchIndex + " updatecount " + currentUpdateCount, this.m_log);
                            }
                            totalRowCount = PGCoreUtils.willAdditionOverflow(totalRowCount, currentUpdateCount) ? Long.MAX_VALUE : (totalRowCount += commandComplete.getNumRows());
                            resultAdded = true;
                        }
                        catch (ErrorException e) {
                            DSIErrorResult error = new DSIErrorResult(e);
                            this.addExecutionResult(new ExecutionResult(error, false));
                            resultAdded = true;
                            throw e;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorException err = current.receivedFatalExeption();
                    if (null != err) {
                        throw err;
                    }
                    if (ex instanceof ErrorException) {
                        throw (ErrorException)ex;
                    }
                    throw PGJDBCDriver.s_PostgreSQLMessages.createGeneralException(PGJDBCMessageKey.CONN_GENERAL_ERR.name(), (Throwable)ex);
                }
            }
            this.addExecutionResult(new ExecutionResult(new DSISimpleRowCountResult(totalRowCount)));
        }
    }
}

