/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine;

import com.amazon.dsi.dataengine.impl.DSIDataEngine;
import com.amazon.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.amazon.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.interfaces.IQueryExecutor;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.dataengine.utilities.MetadataSourceID;
import com.amazon.dsi.dataengine.utilities.OrderType;
import com.amazon.dsi.exceptions.ParsingException;
import com.amazon.jdbc.utils.ParseQueryUtils;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGCallableStatementParser;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGJDBCSettings;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.core.PGScalarFunctionParser;
import com.amazon.redshift.dataengine.PGBatchQueryExecutor;
import com.amazon.redshift.dataengine.PGCatalogQueryBuilder;
import com.amazon.redshift.dataengine.PGQueryExecutor;
import com.amazon.redshift.dataengine.metadata.PGJDBCTypeInfoMetadataSource;
import com.amazon.redshift.dataengine.metadata.PGMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGProcedureColumnsMetadatSourceFromQuery;
import com.amazon.redshift.dataengine.metadata.PGTablePrivilegesMetadatSourceFromQuery;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PGDataEngine
extends DSIDataEngine {
    private PGClient m_client;
    private PGJDBCStatement m_statement;
    private ILogger m_log;
    private boolean m_isDirectExecution;
    private int m_socketTimeoutMS;
    private PGJDBCSettings m_settings;

    public PGDataEngine(PGJDBCStatement statement, PGClient m_postgresqlClient, PGJDBCSettings settings, ILogger log, int socketTimeoutMS) {
        super(statement);
        this.m_statement = statement;
        this.m_log = log;
        this.m_client = m_postgresqlClient;
        this.m_settings = settings;
        this.m_isDirectExecution = false;
        this.m_socketTimeoutMS = socketTimeoutMS;
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> queries) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, queries);
        return new PGBatchQueryExecutor(null, queries, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, true);
    }

    @Override
    public IQueryExecutor prepare(String query) throws ParsingException, ErrorException {
        List<String> queries;
        if (this.m_statement.isCallableStatement()) {
            try {
                PGCallableStatementParser parser = new PGCallableStatementParser();
                parser.Translate(query);
                this.m_statement.sethasReturnQuestionMark(parser.isReturnParameter());
                return new PGQueryExecutor(PGScalarFunctionParser.parseSingleQuery(parser.getResult()), this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS);
            }
            catch (Exception parser) {
                // empty catch block
            }
        }
        if (1 == (queries = ParseQueryUtils.splitQueries(query, true)).size()) {
            return new PGQueryExecutor(PGScalarFunctionParser.parseSingleQuery(queries.get(0)), this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS);
        }
        ArrayList<String> modifiedQueries = new ArrayList<String>();
        for (String q : queries) {
            boolean isUnload = PGCoreUtils.isUnloadStatement(q);
            String scalarFunctionParsedString = PGScalarFunctionParser.scalarFunctionParse(q, isUnload);
            modifiedQueries.add(scalarFunctionParsedString);
        }
        return new PGBatchQueryExecutor(query, modifiedQueries, this.m_client, this.m_log, this.m_isDirectExecution, this.m_statement, this.m_socketTimeoutMS, false);
    }

    @Override
    public void setDirectExecute() {
        this.m_isDirectExecution = true;
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceId, ArrayList<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, OrderType orderType) throws ErrorException {
        if (MetadataSourceID.PRIMARY_KEYS == metadataSourceId) {
            return super.makeNewMetadataResult(metadataSourceId, filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, OrderType.NONE);
        }
        return super.makeNewMetadataResult(metadataSourceId, filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, orderType);
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceId, Map<MetadataSourceColumnTag, String> restrictions, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier) throws ErrorException {
        switch (metadataSourceId) {
            case TYPE_INFO: {
                return new PGJDBCTypeInfoMetadataSource(this.getLog());
            }
            case TABLETYPE_ONLY: {
                ArrayList<String> tableTypes = new ArrayList<String>();
                tableTypes.add("TABLE");
                tableTypes.add("VIEW");
                tableTypes.add("SEQUENCE");
                tableTypes.add("INDEX");
                tableTypes.add("SYSTEM TABLE");
                tableTypes.add("SYSTEM TOAST TABLE");
                tableTypes.add("TEMPORARY TABLE");
                tableTypes.add("SYSTEM VIEW");
                tableTypes.add("TEMPORARY VIEW");
                tableTypes.add("SYSTEM INDEX");
                tableTypes.add("SYSTEM TOAST INDEX");
                tableTypes.add("TEMPORARY INDEX");
                tableTypes.add("TEMPORARY SEQUENCE");
                tableTypes.add("TYPE");
                return new DSITableTypeOnlyMetadataSource(this.getLog(), tableTypes);
            }
            case CATALOG_ONLY: 
            case CATALOG_SCHEMA_ONLY: 
            case SCHEMA_ONLY: 
            case TABLES: 
            case COLUMNS: 
            case FOREIGN_KEYS: 
            case PRIMARY_KEYS: {
                String catalogFunctionQuery = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceId, restrictions, this.m_settings);
                PGMessagingContext catalogQueryContext = this.m_client.directExecute(catalogFunctionQuery, false, 0, 0, null, true);
                return new PGMetadatSourceFromQuery(metadataSourceId, catalogQueryContext, 0, this.m_log);
            }
            case TABLE_PRIVILEGES: {
                String catalogFunctionQuery = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceId, restrictions, this.m_settings);
                PGMessagingContext catalogQueryContext = this.m_client.directExecute(catalogFunctionQuery, false, 0, 0, null, false);
                return new PGTablePrivilegesMetadatSourceFromQuery(catalogQueryContext, this.m_log);
            }
            case PROCEDURES: {
                String catalogFunctionQuery = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceId, restrictions, this.m_settings);
                PGMessagingContext catalogQueryContext = this.m_client.directExecute(catalogFunctionQuery, false, 0, 0, null, false);
                return new PGMetadatSourceFromQuery(metadataSourceId, catalogQueryContext, 0, this.m_log);
            }
            case PROCEDURE_COLUMNS: {
                String serverVersion = PGCoreUtils.SERVER_VERSION;
                int majorVersionNumber = Integer.parseInt(serverVersion.split("\\.")[0]);
                int minorVersionNumber = Integer.parseInt(serverVersion.split("\\.")[1]);
                if (majorVersionNumber >= 8 && minorVersionNumber >= 4) {
                    String catalogFunctionQuery = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceId, restrictions, this.m_settings);
                    PGMessagingContext catalogQueryContext = this.m_client.directExecute(catalogFunctionQuery, false, 0, 0, null, false);
                    return new PGMetadatSourceFromQuery(metadataSourceId, catalogQueryContext, 0, this.m_log);
                }
                String catalogFunctionQuery = PGCatalogQueryBuilder.buildProcedureColumnsQueryForOldPostgres(restrictions);
                PGMessagingContext catalogQueryContext = this.m_client.directExecute(catalogFunctionQuery, false, 0, 0, null, false);
                return new PGProcedureColumnsMetadatSourceFromQuery(catalogQueryContext, 0, this.m_log);
            }
            case FUNCTIONS_JDBC4: {
                if (!PGCoreUtils.REDSHIFT_SERVER) {
                    String catalogFunctionQuery = PGCatalogQueryBuilder.BuildCatalogQuery(metadataSourceId, restrictions, this.m_settings);
                    PGMessagingContext catalogQueryContext = this.m_client.directExecute(catalogFunctionQuery, false, 0, 0, null, false);
                    return new PGMetadatSourceFromQuery(metadataSourceId, catalogQueryContext, 0, this.m_log);
                }
                return new DSIEmptyMetadataSource(this.getLog());
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }
}

