/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc42;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.jdbc.jdbc42.S42Connection;
import com.amazon.redshift.client.interfaces.Notification;
import com.amazon.redshift.core.NotifiedConnection;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.core.PGDSIOverrideHelper;
import com.amazon.redshift.core.PGJDBCConnection;
import com.amazon.support.IWarningListener;
import java.sql.SQLException;
import java.util.List;

public class S42NotifiedConnection
extends S42Connection
implements NotifiedConnection {
    public S42NotifiedConnection(IConnection conn, String url) throws SQLException {
        super(conn, url);
    }

    @Override
    public List<Notification> getNotifications() {
        IWarningListener warningListener = this.getWarningListener();
        return PGCoreUtils.getNotifications(warningListener);
    }

    @Override
    public void clearNotifications() {
        IWarningListener warningListener = this.getWarningListener();
        PGCoreUtils.clearNotifications(warningListener);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        boolean isValid = super.isValid(timeout);
        if (!isValid) {
            return false;
        }
        PGJDBCConnection pgConn = (PGJDBCConnection)this.getDSIConnection();
        return PGDSIOverrideHelper.checkIsValidQuery(pgConn);
    }
}

