/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc42;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.jdbc.common.SCallableStatement;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SDatabaseMetaData;
import com.amazon.jdbc.common.SPreparedStatement;
import com.amazon.jdbc.common.SStatement;
import com.amazon.jdbc.jdbc42.JDBC42ObjectFactory;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.redshift.core.jdbc42.PGJDBC42CallableStatement;
import com.amazon.redshift.core.jdbc42.PGJDBC42DatabaseMetaData;
import com.amazon.redshift.core.jdbc42.PGJDBC42PreparedStatement;
import com.amazon.redshift.core.jdbc42.PGJDBC42Statement;
import com.amazon.redshift.core.jdbc42.S42NotifiedConnection;
import com.amazon.support.ILogger;
import java.sql.SQLException;

public class PGJDBC42ObjectFactory
extends JDBC42ObjectFactory {
    protected PGJDBC42ObjectFactory() {
    }

    @Override
    protected SCallableStatement createCallableStatement(String sql, IStatement dsiStatement, SConnection parentConnection, int concurrency) throws SQLException {
        PGJDBCStatement callableStatement = (PGJDBCStatement)dsiStatement;
        callableStatement.setIsCallableStatement(true);
        return new PGJDBC42CallableStatement(sql, callableStatement, parentConnection, concurrency);
    }

    @Override
    protected SConnection createConnection(IConnection dsiConnection, String url) throws SQLException {
        return new S42NotifiedConnection(dsiConnection, url);
    }

    @Override
    protected SDatabaseMetaData createDatabaseMetaData(SConnection conn, ILogger logger) throws SQLException {
        IConnection DSIcon = null;
        if (conn != null) {
            DSIcon = conn.getDSIConnection();
        }
        return new PGJDBC42DatabaseMetaData(DSIcon, conn, logger);
    }

    @Override
    protected SPreparedStatement createPreparedStatement(String sql, IStatement dsiStatement, SConnection parentConnection, int concurrency) throws SQLException {
        return new PGJDBC42PreparedStatement(sql, dsiStatement, parentConnection, concurrency);
    }

    @Override
    protected SStatement createStatement(IStatement dsiStatement, SConnection parentConnection, int concurrency) throws SQLException {
        return new PGJDBC42Statement(dsiStatement, parentConnection, concurrency);
    }
}

