/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client;

import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.jdbc.communications.InboundMessagesContainer;
import com.amazon.jdbc.communications.InboundMessagesPipeline;
import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import com.amazon.redshift.client.PGClient;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.client.messages.inbound.Authentication;
import com.amazon.redshift.client.messages.inbound.BindComplete;
import com.amazon.redshift.client.messages.inbound.CloseComplete;
import com.amazon.redshift.client.messages.inbound.CommandComplete;
import com.amazon.redshift.client.messages.inbound.DataRow;
import com.amazon.redshift.client.messages.inbound.EmptyQueryResponse;
import com.amazon.redshift.client.messages.inbound.ErrorResponse;
import com.amazon.redshift.client.messages.inbound.NoData;
import com.amazon.redshift.client.messages.inbound.NoticeResponse;
import com.amazon.redshift.client.messages.inbound.ParameterDescription;
import com.amazon.redshift.client.messages.inbound.ParseComplete;
import com.amazon.redshift.client.messages.inbound.ReadyForQuery;
import com.amazon.redshift.client.messages.inbound.RowDescription;
import com.amazon.redshift.core.IPGLogger;
import com.amazon.redshift.core.PGCoreUtils;
import com.amazon.redshift.dataengine.metadata.ColumnsIsNullResultSet;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class PGMessagingContext
extends InboundMessagesPipeline
implements PGConstants {
    private CloseMode m_closeMode;
    private Authentication m_authentication;
    private RowDescription m_rowDescription;
    private boolean m_rowDescriptionPrepareExecute;
    private ParameterDescription m_parameterDescription;
    private NoData m_noData;
    private boolean m_noDataPrepareExecute;
    private EmptyQueryResponse m_emptyQueryResponse;
    private BindComplete m_bindComplete;
    public ParseComplete m_parseComplete;
    public ReadyForQuery m_readyForQueryFromPipelineForQuery;
    public ReadyForQuery m_readyForQueryFromPipelineForPrepare;
    public long m_dataRowCount;
    public CommandComplete m_commandCompleteFromPipeline;
    public boolean m_commandCompleteFromWire = false;
    public ErrorResponse m_errorResponse;
    public AtomicBoolean m_syncSent = new AtomicBoolean(false);
    public boolean m_closeCompleteFromPipeline = false;
    public boolean m_closeCompleteFromWire = false;
    public List<ParameterMetadata> m_parameterMetadata = null;
    public List<Integer> m_parameterOids = null;
    public short[] m_columnTypes = null;
    public AtomicBoolean m_isCanceled = new AtomicBoolean(false);
    public DataRow m_currentDataRow;
    private byte[] m_portalName;
    public byte[] m_serverStatementName;
    public boolean m_hasResults;
    public boolean m_isPreparedStatement;
    public boolean m_isPreparedStatementExecuted;
    private PGClient m_client;
    public int m_maxRow = 0;
    public int m_fetchSize = 0;
    protected IPGLogger m_log;
    private IWarningListener m_statementWarningListener;
    public ColumnsIsNullResultSet m_columnsIsNullResultSet;
    public boolean m_multipleParameterSetsMode;
    public int m_batchCount;
    public boolean m_finalCommandInBatch;
    public int m_batchCommandCompleteToPipelineCount;
    public List<CommandComplete> m_multipleParameterSetsCommandComplete;
    public List<BindComplete> m_multipleParameterSetsBindComplete;

    private PGMessagingContext(PGClient client, String query, int nRowMode, int maxRows, IPGLogger logger, IWarningListener warningListener, IWarningListener statementWarningListener) {
        super(nRowMode, logger, warningListener);
        this.m_log = logger;
        this.m_query = query;
        this.m_client = client;
        this.m_parameterMetadata = new ArrayList<ParameterMetadata>();
        this.m_parameterOids = new ArrayList<Integer>();
        this.m_statementWarningListener = statementWarningListener;
        this.m_fetchSize = nRowMode;
        this.m_maxRow = maxRows;
        this.m_isPreparedStatement = false;
        this.m_isPreparedStatementExecuted = false;
        this.m_noDataPrepareExecute = false;
        this.m_rowDescriptionPrepareExecute = false;
        this.m_closeMode = CloseMode.ReadyForQuery;
        this.m_finalCommandInBatch = true;
        this.openCurrentOperation();
    }

    public static PGMessagingContext createStatementContext(PGClient client, String query, int nRowMode, int maxRows, IPGLogger logger, IWarningListener warningListener, IWarningListener statementWarningListener) {
        return new PGMessagingContext(client, query, nRowMode, maxRows, logger, warningListener, statementWarningListener);
    }

    public static PGMessagingContext createPreparedStatementContext(PGClient client, String query, int nRowMode, int maxRows, IPGLogger logger, IWarningListener warningListener, IWarningListener statementWarningListener) throws ErrorException {
        PGMessagingContext context = new PGMessagingContext(client, query, nRowMode, maxRows, logger, warningListener, statementWarningListener);
        context.m_isPreparedStatement = true;
        context.m_query = PGCoreUtils.parameterQueryFormatter(query, context.m_parameterOids);
        return context;
    }

    private void initialize() {
        try {
            IInboundMessage message;
            while (null != this.m_currentMessagesContainer && this.m_currentMessagesContainer.hasNext()) {
                message = this.m_currentMessagesContainer.next(1);
                if (!this.m_log.isEnabled()) continue;
                LogUtilities.logDebug("Consume message from container: " + message.getClass().getSimpleName(), (ILogger)this.m_log);
            }
            if (this.m_nRowMode == 0) {
                while (this.m_messageContainersQueue.size() != 0) {
                    this.m_currentMessagesContainer = (InboundMessagesContainer)this.m_messageContainersQueue.poll();
                    while (null != this.m_currentMessagesContainer && this.m_currentMessagesContainer.hasNext()) {
                        message = this.m_currentMessagesContainer.next(1);
                        if (!this.m_log.isEnabled()) continue;
                        LogUtilities.logDebug("Consume message from container: " + message.getClass().getSimpleName(), (ILogger)this.m_log);
                    }
                }
            }
        }
        catch (ErrorException e) {
            LogUtilities.logDebug("Error while initializing PGMessagingContext, during old message consumption", (ILogger)this.m_log);
            LogUtilities.logDebug(e, (ILogger)this.m_log);
        }
        this.m_hasResults = false;
        this.m_isCanceled.set(false);
        this.m_multipleParameterSetsMode = false;
        this.m_multipleParameterSetsCommandComplete = null;
        this.m_multipleParameterSetsBindComplete = null;
        this.m_totalMessageCount = 0L;
        this.m_currentMessageCount = 0L;
        this.m_batchCount = 0;
        this.m_batchCommandCompleteToPipelineCount = 0;
        this.m_peekedMessage = null;
        this.m_dataRowCount = 0L;
        this.m_commandCompleteFromPipeline = null;
        this.m_commandCompleteFromWire = false;
        this.m_isPreparedStatementExecuted = false;
        this.m_readyForQueryFromPipelineForQuery = null;
        this.m_bindComplete = null;
        this.m_currentDataRow = null;
        this.m_emptyQueryResponse = null;
        this.m_closeCompleteFromPipeline = false;
        this.m_closeCompleteFromWire = false;
        this.m_noDataPrepareExecute = false;
        this.m_rowDescriptionPrepareExecute = false;
        if (!this.m_isPreparedStatement) {
            this.m_readyForQueryFromPipelineForPrepare = null;
            this.m_noData = null;
            this.m_rowDescription = null;
            this.m_parameterDescription = null;
        }
    }

    public void openCurrentOperation(int maxRows, boolean executePreparedStatement) {
        this.initialize();
        this.m_maxRow = maxRows;
        this.m_isPreparedStatementExecuted = executePreparedStatement;
        super.openCurrentOperation();
    }

    public void openCurrentOperationParameterSets(int batchCount) {
        this.initialize();
        this.m_multipleParameterSetsMode = true;
        this.m_batchCount = batchCount;
        this.m_multipleParameterSetsCommandComplete = new ArrayList<CommandComplete>(batchCount);
        this.m_multipleParameterSetsBindComplete = new ArrayList<BindComplete>(batchCount);
        this.m_isPreparedStatementExecuted = true;
        super.openCurrentOperation();
    }

    public void setFinalCommandInBatch(boolean finalCommandInBatch) {
        this.m_finalCommandInBatch = finalCommandInBatch;
    }

    public void setCloseMode(CloseMode closeMode) {
        this.m_closeMode = closeMode;
    }

    public CloseMode getCloseMode() {
        return this.m_closeMode;
    }

    @Override
    protected boolean handleMessage(IInboundMessage message) throws ErrorException {
        if (null != message) {
            if (message instanceof DataRow) {
                this.m_hasResults = true;
                this.m_currentDataRow = (DataRow)message;
            } else {
                if (message instanceof InboundErrorMessage) {
                    this.m_hasResults = true;
                    this.closeCurrentOperation();
                    this.m_client.sync();
                    throw (InboundErrorMessage)message;
                }
                if (message instanceof NoticeResponse) {
                    this.m_hasResults = true;
                    this.handleErrorResponse((NoticeResponse)message);
                } else if (message instanceof Authentication) {
                    this.m_hasResults = true;
                    this.m_authentication = (Authentication)message;
                } else if (message instanceof ErrorResponse) {
                    this.m_hasResults = true;
                    ErrorResponse error = (ErrorResponse)message;
                    if (error.getTranslateSeverity() != ErrorResponse.Severity.FATAL) {
                        this.m_errorResponse = error;
                    }
                    try {
                        this.handleErrorResponse(error);
                    }
                    finally {
                        this.closeCurrentOperation();
                    }
                } else if (message instanceof CommandComplete) {
                    this.m_hasResults = true;
                    if (this.m_multipleParameterSetsMode) {
                        this.m_multipleParameterSetsCommandComplete.add((CommandComplete)message);
                    } else {
                        this.m_commandCompleteFromPipeline = (CommandComplete)message;
                    }
                    this.evaluateClose(CloseMode.CommandComplete);
                } else if (message instanceof CloseComplete) {
                    this.m_hasResults = true;
                    this.m_closeCompleteFromPipeline = true;
                    this.evaluateClose(CloseMode.CloseComplete);
                } else if (message instanceof EmptyQueryResponse) {
                    this.m_hasResults = true;
                    this.m_emptyQueryResponse = (EmptyQueryResponse)message;
                    if (this.m_multipleParameterSetsMode) {
                        this.m_multipleParameterSetsCommandComplete.add((CommandComplete)message);
                    } else {
                        this.m_commandCompleteFromPipeline = (CommandComplete)message;
                    }
                    this.evaluateClose(CloseMode.CommandComplete);
                } else if (message instanceof ReadyForQuery) {
                    if (this.m_isPreparedStatement && !this.m_hasResults && null == this.m_readyForQueryFromPipelineForPrepare) {
                        this.m_readyForQueryFromPipelineForPrepare = (ReadyForQuery)message;
                    } else {
                        this.m_readyForQueryFromPipelineForQuery = (ReadyForQuery)message;
                    }
                    this.evaluateClose(CloseMode.ReadyForQuery);
                } else if (message instanceof BindComplete) {
                    BindComplete bindComplete = (BindComplete)message;
                    if (this.m_multipleParameterSetsMode) {
                        this.m_multipleParameterSetsBindComplete.add(bindComplete);
                    } else {
                        this.m_bindComplete = bindComplete;
                    }
                } else if (message instanceof RowDescription) {
                    if (this.m_isPreparedStatementExecuted && null != this.m_rowDescription) {
                        this.m_rowDescriptionPrepareExecute = true;
                    }
                    this.m_rowDescription = (RowDescription)message;
                } else if (message instanceof ParameterDescription) {
                    this.m_parameterDescription = (ParameterDescription)message;
                } else if (message instanceof NoData) {
                    if (this.m_isPreparedStatementExecuted && null != this.m_noData) {
                        this.m_noDataPrepareExecute = true;
                    }
                    this.m_noData = (NoData)message;
                } else if (message instanceof ParseComplete) {
                    this.m_parseComplete = (ParseComplete)message;
                }
            }
        }
        return true;
    }

    private void evaluateClose(CloseMode attemptCloseMode) {
        if (this.m_multipleParameterSetsMode && this.m_multipleParameterSetsCommandComplete.size() != this.m_batchCount) {
            return;
        }
        if (this.m_closeMode == attemptCloseMode) {
            this.closeCurrentOperation();
        }
    }

    private void handleErrorResponse(ErrorResponse error) throws ErrorException {
        if (this.m_log.isEnabled()) {
            LogUtilities.logDebug(error.toString(), (ILogger)this.m_log);
        }
        switch (error.getTranslateSeverity()) {
            case FATAL: 
            case PANIC: 
            case ERROR: {
                throw error.toErrorException();
            }
            case WARNING: {
                if (null != this.m_statementWarningListener) {
                    this.m_statementWarningListener.postWarning(error.toWarning());
                } else {
                    if (null != this.m_warningListener) {
                        this.m_warningListener.postWarning(error.toWarning());
                        break;
                    }
                    throw error.toErrorException();
                }
            }
            case DEBUG: 
            case INFO: 
            case LOG: 
            case NOTICE: {
                if (null != this.m_statementWarningListener) {
                    this.m_statementWarningListener.postWarning(error.toWarning());
                    break;
                }
                if (null == this.m_warningListener) break;
                this.m_warningListener.postWarning(error.toWarning());
            }
        }
    }

    public Authentication getAuthentication(int timeoutMS) throws ErrorException {
        this.m_authentication = null;
        this.getNextMessageOfClass(Authentication.class, timeoutMS);
        return this.m_authentication;
    }

    public boolean getRowDescriptionForPrepareExecute() throws ErrorException {
        this.moveThroughMetadataPrepareExecute();
        return this.m_rowDescriptionPrepareExecute;
    }

    public boolean getNoDataForPrepareExecute() throws ErrorException {
        this.moveThroughMetadataPrepareExecute();
        return this.m_noDataPrepareExecute;
    }

    private void moveThroughMetadataPrepareExecute() throws ErrorException {
        while (!this.m_noDataPrepareExecute && !this.m_rowDescriptionPrepareExecute && !this.m_close.get() && this.hasOpenOperation()) {
            if (this.doMoveToNextClass(null)) continue;
            LogUtilities.logFatal("PGMessagingContext.moveThroughMetadataPrepareExecute()", (ILogger)this.m_log);
        }
    }

    public RowDescription getRowDescription() throws ErrorException {
        this.moveThroughMetadata();
        return this.m_rowDescription;
    }

    public NoData getNoData() throws ErrorException {
        this.moveThroughMetadata();
        return this.m_noData;
    }

    private void moveThroughMetadata() throws ErrorException {
        while (null == this.m_noData && null == this.m_rowDescription && !this.m_close.get() && this.hasOpenOperation()) {
            if (this.doMoveToNextClass(null)) continue;
            LogUtilities.logFatal("PGMessagingContext.moveThroughMetadata()", (ILogger)this.m_log);
        }
    }

    public BindComplete getBindComplete() throws ErrorException {
        if (null == this.m_bindComplete && !this.doMoveToNextClass(BindComplete.class)) {
            LogUtilities.logFatal("PGMessagingContext.getParameterDescription()", (ILogger)this.m_log);
        }
        return this.m_bindComplete;
    }

    public ParameterDescription getParameterDescription() throws ErrorException {
        if (null == this.m_parameterDescription && !this.doMoveToNextClass(ParameterDescription.class)) {
            LogUtilities.logFatal("PGMessagingContext.getParameterDescription()", (ILogger)this.m_log);
        }
        return this.m_parameterDescription;
    }

    public boolean doMoveToNextRow() throws ErrorException {
        return this.doMoveToNextClass(DataRow.class);
    }

    public CommandComplete getCommandCompleteMessage() throws ErrorException {
        if (null == this.m_commandCompleteFromPipeline && !this.doMoveToNextClass(CommandComplete.class)) {
            LogUtilities.logFatal("PGMessagingContext.getCommandCompleteMessage()", (ILogger)this.m_log);
        }
        return this.m_commandCompleteFromPipeline;
    }

    public boolean getErrorResponse() throws ErrorException {
        return this.doMoveToNextClass(ErrorResponse.class);
    }

    public boolean getReadyForQuery() throws ErrorException {
        return this.doMoveToNextClass(ReadyForQuery.class);
    }

    public boolean doMoveToNextClass(Class cl) throws ErrorException {
        do {
            if (!this.getNextMessageOfClass(cl, 0)) continue;
            return true;
        } while (this.hasOpenOperation() && !this.m_close.get());
        return false;
    }

    public void setPortalName(byte[] portalName) {
        this.m_portalName = portalName;
    }

    public void checkErrorResponse(int timeoutMS) throws ErrorException {
        this.getNextMessageOfClass(ErrorResponse.class, timeoutMS);
    }

    public void clearPortalName() {
        this.m_portalName = null;
    }

    public byte[] getPortalName() {
        return this.m_portalName;
    }

    public void closeOperation() {
        try {
            if (null == this.m_readyForQueryFromPipelineForQuery) {
                this.getReadyForQuery();
            }
        }
        catch (ErrorException ex) {
            LogUtilities.logFatal(ex, (ILogger)this.m_log);
        }
    }

    static enum CloseMode {
        CommandComplete,
        CloseComplete,
        ReadyForQuery;

    }
}

