/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.utils;

import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import java.util.concurrent.Semaphore;

public abstract class AbstractDoubleBufferManager
implements Runnable {
    protected ILogger m_logger;
    protected BufferHolder[] m_cachedBuffers;
    private ErrorException m_exception;
    private int m_currentBufferIndex;
    private int m_bufferCacheIndex;
    private int m_bufferFetchIndex;
    private boolean m_isRunning = true;
    private final Semaphore m_cacheBufferSemaphore;
    private final Semaphore m_fetchBufferSemaphore;
    protected final int m_bufferSize;

    protected AbstractDoubleBufferManager(ILogger logger, int bufferSize) {
        this.m_logger = logger;
        this.m_cacheBufferSemaphore = new Semaphore(0);
        this.m_fetchBufferSemaphore = new Semaphore(1);
        this.m_bufferCacheIndex = 0;
        this.m_bufferFetchIndex = 0;
        this.m_exception = null;
        this.m_bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.m_cachedBuffers = new BufferHolder[2];
        this.m_cachedBuffers[0] = this.makeBuffer();
        this.m_cachedBuffers[1] = this.makeBuffer();
        while (this.m_isRunning) {
            try {
                this.m_fetchBufferSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.m_isRunning) break;
            try {
                this.fetchData(this.m_cachedBuffers[this.m_bufferCacheIndex]);
                if (!this.m_cachedBuffers[this.m_bufferCacheIndex].m_serverHasMoreRows) {
                    AbstractDoubleBufferManager abstractDoubleBufferManager = this;
                    synchronized (abstractDoubleBufferManager) {
                        this.m_isRunning = false;
                        continue;
                    }
                }
                this.m_bufferCacheIndex = 1 - this.m_bufferCacheIndex;
            }
            catch (ErrorException ex) {
                AbstractDoubleBufferManager abstractDoubleBufferManager = this;
                synchronized (abstractDoubleBufferManager) {
                    this.m_exception = ex;
                    this.m_isRunning = false;
                }
            }
            finally {
                this.m_cacheBufferSemaphore.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getNextBuffer() throws ErrorException {
        boolean isRunning;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_exception) {
            throw this.m_exception;
        }
        AbstractDoubleBufferManager abstractDoubleBufferManager = this;
        synchronized (abstractDoubleBufferManager) {
            isRunning = this.m_isRunning;
        }
        if (isRunning) {
            try {
                this.m_cacheBufferSemaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (null != this.m_exception) {
            throw this.m_exception;
        }
        this.m_currentBufferIndex = this.m_bufferFetchIndex;
        this.m_cachedBuffers[this.m_currentBufferIndex].m_currentRow = 0;
        if (!this.m_cachedBuffers[this.m_currentBufferIndex].m_serverHasMoreRows) {
            return false;
        }
        this.m_bufferFetchIndex = 1 - this.m_bufferFetchIndex;
        if (this.m_bufferFetchIndex == this.m_bufferCacheIndex) {
            this.m_fetchBufferSemaphore.release();
        }
        return true;
    }

    public final void stop() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isRunning = false;
        this.m_fetchBufferSemaphore.release();
    }

    protected BufferHolder getFetchBuffer() {
        return this.m_cachedBuffers[this.m_currentBufferIndex];
    }

    protected abstract void fetchData(BufferHolder var1) throws ErrorException;

    protected abstract BufferHolder makeBuffer();

    public static class BufferHolder<BufferT> {
        public BufferT m_buffer = null;
        public boolean m_serverHasMoreRows = false;
        public int m_currentRow;
        public int m_numRows;
    }
}

