/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc42;

import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.core.utilities.Variant;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.interfaces.IResults;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SForwardResultSet;
import com.amazon.jdbc.jdbc41.S41Statement;
import com.amazon.jdbc.jdbc42.S42ForwardResultSet;
import com.amazon.jdbc.jdbc42.S42UpdatableForwardResultSet;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.JDBCVersion;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class S42Statement
extends S41Statement {
    private long m_longTotal = Long.MAX_VALUE;

    public S42Statement(IStatement iStatement, SConnection sConnection, int n) {
        super(iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    protected ResultSet createResultSet(IResultSet iResultSet, boolean bl, int n) throws SQLException {
        SForwardResultSet sForwardResultSet = bl ? new S42UpdatableForwardResultSet(this, iResultSet, this.getLogger()) : new S42ForwardResultSet(this, iResultSet, this.getLogger());
        sForwardResultSet.setFetchSize(n);
        return sForwardResultSet;
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            this.executeAnyBatch();
            return this.processLargeBatchResults(this.m_queryExecutor.getResults());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public synchronized long[] processLargeBatchResults(IResults iResults) throws ErrorException, SQLException {
        ArrayList<Long> arrayList = this.processAllBatchResults(iResults);
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            if (Long.MAX_VALUE < arrayList.get(i)) {
                lArray[i] = -2L;
                this.m_isTotalUnknown = true;
                continue;
            }
            lArray[i] = arrayList.get(i);
        }
        BatchUpdateException batchUpdateException = S42Statement.largeBatchException(this.m_errorExceptions, lArray);
        if (this.m_longTotal < this.m_total) {
            this.m_total = this.m_longTotal;
        }
        this.addToResultPair(this.m_isTotalUnknown, this.m_total);
        if (null != batchUpdateException) {
            throw batchUpdateException;
        }
        return lArray;
    }

    protected static BatchUpdateException largeBatchException(List<SQLException> list, long[] lArray) {
        BatchUpdateException batchUpdateException = null;
        if (null != list) {
            Iterator<SQLException> iterator = list.iterator();
            SQLException sQLException = iterator.next();
            int[] nArray = new int[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                nArray[i] = new Long(lArray[i]).intValue();
            }
            SQLException sQLException2 = batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray, null);
            while (iterator.hasNext()) {
                SQLException sQLException3 = iterator.next();
                sQLException2.setNextException(sQLException3);
                sQLException2 = sQLException3;
            }
        }
        return batchUpdateException;
    }

    @Override
    public synchronized long executeLargeUpdate(String string) throws SQLException {
        try {
            return this.executeAnyUpdate(string);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            if (n == 2 || !S42Statement.isInsertStatement(string)) {
                return this.executeLargeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            if (!S42Statement.isInsertStatement(string)) {
                return this.executeLargeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            if (!S42Statement.isInsertStatement(string)) {
                return this.executeLargeUpdate(string);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Variant variant = this.m_statement.getProperty(2);
            long l = variant.getLong();
            if (Long.MAX_VALUE < l || Long.MIN_VALUE > l) {
                return 0L;
            }
            return l;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return this.getAnyUpdateCount();
    }

    @Override
    public synchronized void setLargeMaxRows(long l) throws SQLException {
        this.setAnyMaxRows(l);
    }
}

