/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc42;

import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.dataengine.interfaces.IResults;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.jdbc41.S41CallableStatement;
import com.amazon.jdbc.jdbc42.S42Statement;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.JDBCVersion;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;

public class S42CallableStatement
extends S41CallableStatement {
    private long m_longMaxRows = Long.MAX_VALUE;

    public S42CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = JDBCVersion.JDBC42;
    }

    @Override
    public void registerOutParameter(int n, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, sQLType);
        if (!(sQLType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        this.registerOutParameter(n, sQLType, 0);
        if (TypeUtilities.isExactNumericType(sQLType.getVendorTypeNumber())) {
            this.m_parameterScale.remove(n);
        }
    }

    @Override
    public synchronized void registerOutParameter(int n, SQLType sQLType, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, sQLType, n2);
        if (!(sQLType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int n3 = sQLType.getVendorTypeNumber();
        this.registerOutParameter(n, n3, n2);
    }

    @Override
    public synchronized void registerOutParameter(int n, SQLType sQLType, String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, sQLType, string);
        if (!(sQLType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int n2 = sQLType.getVendorTypeNumber();
        this.registerOutParameter(n, n2, string);
    }

    @Override
    public synchronized void registerOutParameter(String string, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, sQLType);
        if (!(sQLType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        this.registerOutParameter(string, sQLType, 0);
        if (TypeUtilities.isExactNumericType(sQLType.getVendorTypeNumber())) {
            this.m_parameterScale.remove(this.getParameterIndex(string));
        }
    }

    @Override
    public synchronized void registerOutParameter(String string, SQLType sQLType, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, sQLType, n);
        if (!(sQLType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int n2 = sQLType.getVendorTypeNumber();
        this.registerOutParameter(string, n2, n);
    }

    @Override
    public synchronized void registerOutParameter(String string, SQLType sQLType, String string2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, sQLType, string2);
        if (!(sQLType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int n = sQLType.getVendorTypeNumber();
        this.registerOutParameter(string, n, string2);
    }

    @Override
    public synchronized void setObject(int n, Object object, SQLType sQLType) throws SQLException {
        if (sQLType instanceof SQLType) {
            try {
                LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType);
                int n2 = 0;
                if (object instanceof BigDecimal) {
                    n2 = this.createExactNumMetadata((BigDecimal)object, 2).getScale();
                }
                this.setObject(n, object, sQLType, n2);
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        } else {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, object, sQLType, n2);
        if (!(sQLType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        int n3 = sQLType.getVendorTypeNumber();
        this.setObject(n, object, n3, n2);
    }

    @Override
    public synchronized void setObject(String string, Object object, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType);
        if (!(sQLType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        this.setObject(this.getParameterIndex(string), object, sQLType);
    }

    @Override
    public synchronized void setObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType, n);
        if (!(sQLType instanceof SQLType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        this.setObject(this.getParameterIndex(string), object, sQLType, n);
    }

    @Override
    protected void checkTypeSupported(int n) throws SQLException {
        switch (n) {
            case -11: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: {
                break;
            }
            default: {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
        }
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            if (this.executePreparedAnyBatch()) {
                return new long[0];
            }
            return this.processLargeBatchResults(this.m_queryExecutor.getResults());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public synchronized long[] processLargeBatchResults(IResults iResults) throws ErrorException, SQLException {
        ArrayList<Long> arrayList = this.processAllBatchResults(iResults);
        long[] lArray = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            if (Long.MAX_VALUE < arrayList.get(i)) {
                lArray[i] = -2L;
                this.m_isTotalUnknown = true;
                continue;
            }
            lArray[i] = arrayList.get(i);
        }
        BatchUpdateException batchUpdateException = S42Statement.largeBatchException(this.m_errorExceptions, lArray);
        if (this.m_longMaxRows < this.m_total) {
            this.m_total = this.m_longMaxRows;
        }
        this.addToResultPair(this.m_isTotalUnknown, this.m_total);
        if (null != batchUpdateException) {
            throw batchUpdateException;
        }
        return lArray;
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        return this.executeAnyUpdate();
    }
}

