/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.jdbc42;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.dsi.dataengine.interfaces.IArray;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.jdbc.common.SArray;
import com.amazon.jdbc.jdbc42.S42ArrayResultSet;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class S42Array
extends SArray {
    public S42Array(IArray iArray, IConnection iConnection, ILogger iLogger, IWarningListener iWarningListener) {
        super(iArray, iConnection, iLogger, iWarningListener);
    }

    @Override
    protected Object createArray(long l, int n) throws SQLException {
        try {
            Object object = this.getDSIArray().createArray(l - 1L, n);
            if (2003 == this.getBaseType()) {
                IArray[] iArrayArray = (IArray[])object;
                int n2 = iArrayArray.length;
                IConnection iConnection = this.getParentConnection();
                ILogger iLogger = this.getLogger();
                IWarningListener iWarningListener = this.getWarningListener();
                S42Array[] s42ArrayArray = new S42Array[n2];
                for (int i = 0; i < n2; ++i) {
                    s42ArrayArray[i] = new S42Array(iArrayArray[i], iConnection, iLogger, iWarningListener);
                }
                return s42ArrayArray;
            }
            return object;
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, super.getWarningListener());
        }
    }

    @Override
    protected ResultSet createResultSet(long l, int n) throws SQLException {
        if (0L >= l) {
            throw new IndexOutOfBoundsException("" + l);
        }
        IResultSet iResultSet = this.getDSIArray().createResultSet(l - 1L, n);
        assert (null != iResultSet);
        return new S42ArrayResultSet(this, iResultSet, this.getLogger());
    }

    @Override
    protected IConnection getParentConnection() {
        return super.getParentConnection();
    }
}

