/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.communications;

import com.amazon.jdbc.communications.exceptions.InboundErrorMessage;
import com.amazon.jdbc.communications.interfaces.IInboundMessage;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class InboundMessagesContainer
implements Closeable {
    public static final int NO_REQUESTED_TIMEOUT = 0;
    private static final int NEXT_POLL_TIMEOUT_MS = 50;
    private static final int MESSAGE_ADD_TIMEOUT_MS_INITIAL = 0;
    private static final int MESSAGE_ADD_TIMEOUT_MS_MORE_ATTEMPTS = 50;
    private BlockingQueue<IInboundMessage> m_nRowMessages;
    private List<IInboundMessage> m_messages;
    private boolean m_valid;
    private AtomicBoolean m_close;
    private boolean m_inQueue;
    private boolean m_nRowMode;
    private Iterator<IInboundMessage> m_iterator;

    public InboundMessagesContainer(int nRowMode) {
        if (nRowMode > 0) {
            this.m_nRowMode = true;
            this.m_nRowMessages = new ArrayBlockingQueue<IInboundMessage>(nRowMode);
        } else {
            this.m_nRowMode = false;
            this.m_messages = new ArrayList<IInboundMessage>();
        }
        this.m_valid = true;
        this.m_inQueue = false;
        this.m_close = new AtomicBoolean(false);
    }

    public IInboundMessage next(int timeoutMS) throws InboundErrorMessage {
        boolean returnAfterTimeout = false;
        if (timeoutMS == 0) {
            timeoutMS = 50;
        } else {
            returnAfterTimeout = true;
        }
        if (this.m_nRowMode) {
            do {
                try {
                    IInboundMessage message = this.m_nRowMessages.poll(timeoutMS, TimeUnit.MILLISECONDS);
                    if (null != message) {
                        if (message instanceof InboundErrorMessage) {
                            throw (InboundErrorMessage)message;
                        }
                        return message;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!this.m_close.get() && !returnAfterTimeout);
            return null;
        }
        this.initializeIterator();
        if (this.m_iterator.hasNext()) {
            return this.m_iterator.next();
        }
        return null;
    }

    private void initializeIterator() {
        if (null == this.m_iterator) {
            this.invalidate();
            this.m_iterator = this.m_messages.iterator();
        }
    }

    public boolean hasNext() {
        if (this.m_nRowMode) {
            return !this.m_nRowMessages.isEmpty();
        }
        this.initializeIterator();
        return this.m_iterator.hasNext();
    }

    public boolean add(IInboundMessage message) {
        return this.add(message, false);
    }

    public synchronized boolean add(IInboundMessage message, boolean makeOneAttemptOnly) {
        if (this.m_nRowMode) {
            if (this.m_valid) {
                int timeout = 0;
                do {
                    try {
                        if (this.m_nRowMessages.offer(message, timeout, TimeUnit.MILLISECONDS)) {
                            return true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    timeout = 50;
                } while (!this.m_close.get() && !makeOneAttemptOnly);
            }
        } else {
            if (this.m_valid && !this.m_close.get()) {
                this.m_messages.add(message);
                return true;
            }
            return false;
        }
        return false;
    }

    private synchronized void invalidate() {
        this.m_valid = false;
    }

    public boolean isInQueue() {
        return this.m_inQueue;
    }

    public void setInQueue() {
        this.m_inQueue = true;
    }

    @Override
    public void close() {
        this.m_close.set(true);
    }

    public boolean isClosed() {
        return this.m_close.get();
    }
}

