/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.materializer;

import com.amazon.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AECreateTable;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEDropTable;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEInsertDefaults;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEQuery;
import com.amazon.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.amazon.sqlengine.dsiext.dataengine.SqlDataEngineContext;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.exceptions.SQLEngineMemoryException;
import com.amazon.sqlengine.executor.IStatementExecutor;
import com.amazon.sqlengine.executor.StatementExecutor;
import com.amazon.sqlengine.executor.conversions.SqlConverterGenerator;
import com.amazon.sqlengine.executor.etree.ETMemoryManager;
import com.amazon.sqlengine.executor.etree.ETResourceManager;
import com.amazon.sqlengine.executor.etree.IETResource;
import com.amazon.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.relation.ETTable;
import com.amazon.sqlengine.executor.etree.statement.ETQuery;
import com.amazon.sqlengine.executor.etree.statement.ETSearchedDelete;
import com.amazon.sqlengine.executor.etree.statement.IETStatement;
import com.amazon.sqlengine.executor.etree.statement.RowCountStatement;
import com.amazon.sqlengine.executor.materializer.ETBoolExprMaterializer;
import com.amazon.sqlengine.executor.materializer.ETDmlMaterializer;
import com.amazon.sqlengine.executor.materializer.ETRelationalExprMaterializer;
import com.amazon.sqlengine.executor.materializer.ETTableMaterializer;
import com.amazon.sqlengine.executor.materializer.IStatementMaterializer;
import com.amazon.sqlengine.executor.materializer.MaterializerContext;
import com.amazon.sqlengine.executor.queryplan.IQueryPlan;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.ILogger;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.InvalidOperationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETStatementMaterializer
extends AEDefaultVisitor<IETStatement>
implements IStatementMaterializer {
    private IQueryPlan m_plan;
    private MaterializerContext m_materializerContext;

    public ETStatementMaterializer(SqlConverterGenerator sqlConverterGenerator, IWarningListener iWarningListener, SqlDataEngineContext sqlDataEngineContext, ILogger iLogger) {
        this.m_materializerContext = new MaterializerContext(sqlConverterGenerator, iWarningListener, sqlDataEngineContext, new ETResourceManager(iLogger), iLogger);
    }

    @Override
    public IStatementExecutor materialize(IQueryPlan iQueryPlan) throws ErrorException {
        Object object;
        this.m_plan = iQueryPlan;
        IETStatement iETStatement = null;
        try {
            object = iQueryPlan.getAETree();
            object.notifyDataNeeded();
            iETStatement = object.acceptVisitor(this);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.STACK_OVERFLOW.name());
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SQLEngineMemoryException(SQLEngineMessageKey.OUT_OF_MEMORY.name());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException(7, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{runtimeException.getLocalizedMessage()}, (Throwable)runtimeException);
        }
        object = ETMemoryManager.createMemoryManager(iETStatement);
        this.m_materializerContext.getResourceManager().registerResource((IETResource)object);
        return new StatementExecutor(iETStatement, this.m_materializerContext.getResourceManager(), this.m_materializerContext.getCancelState());
    }

    @Override
    public ETQuery visit(AEQuery aEQuery) throws ErrorException {
        MaterializerContext materializerContext = this.m_materializerContext;
        ETRelationalExpr eTRelationalExpr = aEQuery.getOperand().acceptVisitor(new ETRelationalExprMaterializer(this.m_plan, materializerContext));
        return new ETQuery(eTRelationalExpr, this.m_materializerContext.getParameters());
    }

    @Override
    public IETStatement visit(AECreateTable aECreateTable) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("CREATE statement");
    }

    @Override
    public IETStatement visit(AEDelete aEDelete) throws ErrorException {
        MaterializerContext materializerContext = this.m_materializerContext;
        ETTable eTTable = aEDelete.getTable().acceptVisitor(new ETTableMaterializer(this.m_plan, materializerContext));
        ETBooleanExpr eTBooleanExpr = aEDelete.getCondition().acceptVisitor(new ETBoolExprMaterializer(this.m_plan, materializerContext));
        return new ETSearchedDelete(eTTable, eTBooleanExpr, materializerContext.getParameters());
    }

    @Override
    public IETStatement visit(AEDropTable aEDropTable) throws ErrorException {
        throw SQLEngineExceptionFactory.featureNotImplementedException("DROP statement");
    }

    @Override
    public RowCountStatement visit(AEInsert aEInsert) throws ErrorException {
        return aEInsert.acceptVisitor(new ETDmlMaterializer(this.m_plan, this.m_materializerContext));
    }

    @Override
    public IETStatement visit(AEInsertDefaults aEInsertDefaults) throws ErrorException {
        return new ETDmlMaterializer(this.m_plan, this.m_materializerContext).visit(aEInsertDefaults);
    }

    @Override
    public IETStatement visit(AEUpdate aEUpdate) throws ErrorException {
        return new ETDmlMaterializer(this.m_plan, this.m_materializerContext).visit(aEUpdate);
    }

    @Override
    protected IETStatement defaultVisit(IAENode iAENode) throws ErrorException {
        throw new UnsupportedOperationException("Logic Error: Default visit method is called with " + iAENode + " from base AE tree builder class");
    }
}

