/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.functor.arithmetic;

import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.amazon.support.IWarningListener;
import com.amazon.support.exceptions.ErrorException;

public abstract class AbstractIntBinArithFunctor
implements IBinaryArithmeticFunctor {
    protected boolean m_isSigned;

    protected AbstractIntBinArithFunctor(boolean bl) {
        this.m_isSigned = bl;
    }

    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        long l = iSqlDataWrapper.getInteger();
        long l2 = iSqlDataWrapper2.getInteger();
        assert (this.m_isSigned && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE || !this.m_isSigned && l >= 0L && l <= 0xFFFFFFFFL);
        assert (this.m_isSigned && l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE || !this.m_isSigned && l2 >= 0L && l2 <= 0xFFFFFFFFL);
        long l3 = this.calculate(l, l2);
        if (this.m_isSigned && l3 <= Integer.MAX_VALUE && l3 >= Integer.MIN_VALUE || !this.m_isSigned && l3 >= 0L && l3 <= 0xFFFFFFFFL) {
            eTDataRequest.getData().setInteger(l3);
            return false;
        }
        throw SQLEngineExceptionFactory.numArithOverflowException();
    }

    protected abstract long calculate(long var1, long var3) throws ErrorException;
}

