/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.dsiext.dataengine.ddl;

import com.amazon.sqlengine.dsiext.dataengine.ddl.TableConstraint;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKeyConstraint
extends TableConstraint {
    private static final TableConstraint.ConstraintType CONSTRAINT_TYPE = TableConstraint.ConstraintType.PRIMARY_KEY;
    private Set<String> m_primaryKeyColumns;

    public PrimaryKeyConstraint(String string, Collection<String> collection) {
        super(string);
        if (collection == null || collection.size() == 0) {
            throw new IllegalArgumentException("Primary key constraint requires at least one column");
        }
        this.m_primaryKeyColumns = new HashSet<String>();
        this.m_primaryKeyColumns.addAll(collection);
    }

    public Set<String> getPrimaryKeyColumns() {
        return Collections.unmodifiableSet(this.m_primaryKeyColumns);
    }

    @Override
    public TableConstraint.ConstraintType getType() {
        return CONSTRAINT_TYPE;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("PRIMARY KEY(");
        Object[] objectArray = this.m_primaryKeyColumns.toArray(new String[this.m_primaryKeyColumns.size()]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            stringBuilder.append((String)object);
            stringBuilder.append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

