/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aebuilder.value;

import com.amazon.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.amazon.sqlengine.aeprocessor.aebuilder.bool.AEBooleanExprOuterRefProcessor;
import com.amazon.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.amazon.sqlengine.aeprocessor.aetree.AENodeList;
import com.amazon.sqlengine.aeprocessor.aetree.AESemantics;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEBinaryValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.amazon.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.amazon.sqlengine.aeprocessor.aetree.value.AENegate;
import com.amazon.sqlengine.aeprocessor.aetree.value.AENull;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.amazon.sqlengine.aeprocessor.aetree.value.AERename;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESimpleWhenClause;
import com.amazon.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEUnaryValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.DiagState;
import com.amazon.support.exceptions.ErrorException;
import java.util.Iterator;

public class AEValueExprOuterRefProcessor {
    private AEValueExprOuterRefProcessor() {
    }

    public static void process(AEValueExprList aEValueExprList, AEQueryScope aEQueryScope) throws ErrorException {
        AEValueExprProcessor aEValueExprProcessor = new AEValueExprProcessor(aEQueryScope);
        Iterator iterator = aEValueExprList.getChildItr();
        int n = 0;
        while (iterator.hasNext()) {
            AEValueExpr aEValueExpr = (AEValueExpr)iterator.next();
            aEValueExprList.replaceNode((IAENode)aEValueExpr.acceptVisitor(aEValueExprProcessor), n);
            ++n;
        }
    }

    public static AEValueExpr process(AEValueExpr aEValueExpr, AEQueryScope aEQueryScope) throws ErrorException {
        return aEValueExpr.acceptVisitor(new AEValueExprProcessor(aEQueryScope));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AEValueExprProcessor
    extends AEDefaultVisitor<AEValueExpr> {
        private final AEQueryScope m_scope;

        AEValueExprProcessor(AEQueryScope aEQueryScope) {
            this.m_scope = aEQueryScope;
        }

        @Override
        public AEValueExpr visit(AEAdd aEAdd) throws ErrorException {
            return this.processBinary(aEAdd);
        }

        @Override
        public AEValueExpr visit(AEColumnReference aEColumnReference) throws ErrorException {
            AEQueryScope aEQueryScope = aEColumnReference.getResolvedQueryScope();
            if (this.isOuterScope(aEQueryScope) && this.mustBeGroupingExpr(aEQueryScope)) {
                AEValueExpr aEValueExpr = aEQueryScope.proxyToAggregateExpr(aEColumnReference);
                if (null == aEValueExpr) {
                    throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.NON_GROUPING_COLUMN_IN_SEL_LIST.name(), new String[]{aEColumnReference.getLogString()});
                }
                return aEValueExpr;
            }
            return aEColumnReference;
        }

        @Override
        public AEValueExpr visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
            return this.processAggregate(aECountStarAggrFn);
        }

        @Override
        public AEValueExpr visit(AEConcat aEConcat) throws ErrorException {
            return this.processBinary(aEConcat);
        }

        @Override
        public AEValueExpr visit(AEDivide aEDivide) throws ErrorException {
            return this.processBinary(aEDivide);
        }

        @Override
        public AEValueExpr visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
            return this.processAggregate(aEGeneralAggrFn);
        }

        @Override
        public AEValueExpr visit(AELiteral aELiteral) throws ErrorException {
            return aELiteral;
        }

        @Override
        public AEValueExpr visit(AEMultiply aEMultiply) throws ErrorException {
            return this.processBinary(aEMultiply);
        }

        @Override
        public AEValueExpr visit(AENegate aENegate) throws ErrorException {
            return this.processUnary(aENegate);
        }

        @Override
        public AEValueExpr visit(AENull aENull) throws ErrorException {
            return aENull;
        }

        @Override
        public AEValueExpr visit(AEParameter aEParameter) throws ErrorException {
            return aEParameter;
        }

        @Override
        public AEValueExpr visit(AERename aERename) throws ErrorException {
            return this.processUnary(aERename);
        }

        @Override
        public AEValueExpr visit(AEScalarFn aEScalarFn) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aEScalarFn);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            AEValueExprOuterRefProcessor.process(aEScalarFn.getArguments(), this.m_scope);
            return aEScalarFn;
        }

        @Override
        public AEValueExpr visit(AESearchedCase aESearchedCase) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aESearchedCase);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            aESearchedCase.setElseClause(aESearchedCase.getElseClause().acceptVisitor(this));
            AENodeList<AESearchedWhenClause> aENodeList = aESearchedCase.getWhenClauseList();
            Iterator iterator = aENodeList.getChildItr();
            while (iterator.hasNext()) {
                AESearchedWhenClause aESearchedWhenClause = (AESearchedWhenClause)iterator.next();
                aESearchedWhenClause.setThenExpression(aESearchedWhenClause.getThenExpression().acceptVisitor(this));
                AEBooleanExprOuterRefProcessor.process(aESearchedWhenClause.getWhenCondition(), this.m_scope);
            }
            return aESearchedCase;
        }

        @Override
        public AEValueExpr visit(AESimpleCase aESimpleCase) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aESimpleCase);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            aESimpleCase.setCaseOperand(aESimpleCase.getCaseOperand().acceptVisitor(this));
            aESimpleCase.setElseOperand(aESimpleCase.getElseOperand().acceptVisitor(this));
            Iterator iterator = aESimpleCase.getWhenClauseList().getChildItr();
            while (iterator.hasNext()) {
                AESimpleWhenClause aESimpleWhenClause = (AESimpleWhenClause)iterator.next();
                aESimpleWhenClause.setWhenExpression(aESimpleWhenClause.getWhenExpression().acceptVisitor(this));
                aESimpleWhenClause.setThenExpression(aESimpleWhenClause.getThenExpression().acceptVisitor(this));
            }
            return aESimpleCase;
        }

        @Override
        public AEValueExpr visit(AESubtract aESubtract) throws ErrorException {
            return this.processBinary(aESubtract);
        }

        @Override
        public AEValueExpr visit(AEValueSubQuery aEValueSubQuery) {
            return aEValueSubQuery;
        }

        @Override
        protected AEValueExpr defaultVisit(IAENode iAENode) throws ErrorException {
            throw new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.NON_GROUPING_COLUMN_IN_SEL_LIST.name(), new String[]{iAENode.getLogString()});
        }

        private AEValueExpr processAggregate(AEAggrFn aEAggrFn) throws ErrorException {
            AEQueryScope aEQueryScope = AESemantics.findUniqueQueryScope(aEAggrFn, true);
            if (this.isOuterScope(aEQueryScope)) {
                assert (AEQueryScope.ClauseType.HAVING == aEQueryScope.getCurrentClause() || AEQueryScope.ClauseType.SELECT_LIST == aEQueryScope.getCurrentClause());
                return aEQueryScope.addAggregateFunction(aEAggrFn);
            }
            return aEAggrFn;
        }

        private AEValueExpr processBinary(AEBinaryValueExpr aEBinaryValueExpr) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aEBinaryValueExpr);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            aEBinaryValueExpr.setLeftOperand(aEBinaryValueExpr.getLeftOperand().acceptVisitor(this));
            aEBinaryValueExpr.setRightOperand(aEBinaryValueExpr.getRightOperand().acceptVisitor(this));
            return aEBinaryValueExpr;
        }

        private AEValueExpr processUnary(AEUnaryValueExpr aEUnaryValueExpr) throws ErrorException {
            AEValueExpr aEValueExpr = this.createProxy(aEUnaryValueExpr);
            if (null != aEValueExpr) {
                return aEValueExpr;
            }
            aEUnaryValueExpr.setOperand(aEUnaryValueExpr.getOperand().acceptVisitor(this));
            return aEUnaryValueExpr;
        }

        private AEValueExpr createProxy(AEValueExpr aEValueExpr) throws ErrorException {
            AEQueryScope aEQueryScope = AESemantics.findUniqueQueryScope(aEValueExpr, false);
            if (this.isOuterScope(aEQueryScope) && this.mustBeGroupingExpr(aEQueryScope)) {
                return aEQueryScope.proxyToAggregateExpr(aEValueExpr);
            }
            return null;
        }

        private boolean isOuterScope(AEQueryScope aEQueryScope) {
            return null != aEQueryScope && this.m_scope != aEQueryScope;
        }

        private boolean mustBeGroupingExpr(AEQueryScope aEQueryScope) {
            AEQueryScope.ClauseType clauseType = aEQueryScope.getCurrentClause();
            return AEQueryScope.ClauseType.HAVING == clauseType || AEQueryScope.ClauseType.SELECT_LIST == clauseType && aEQueryScope.hasAggregate();
        }
    }
}

